/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.FinPlanRowService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.servicehelper.RevCfmBillSerivceHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.helper.FinarPremHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.ar.validator.FinArBillImportValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.RevCfmChargeAgainstService;
import kd.fi.arapcommon.service.WriteOffUnSettleService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.concurrency.ConcuCtrlBizEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.verify.ArOriginalUnWriteOffService;
import kd.fi.arapcommon.service.verify.ArRevWrittenOffVerifyService;
import kd.fi.arapcommon.service.verify.ArSaloutUnWriteOffService;
import kd.fi.arapcommon.service.writeback.helper.ArPremiumWBFinBillServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.SupplierandMaterial4VmiValidator;
import kd.fi.arapcommon.validator.WriteOffBillValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import kd.fi.arapcommon.validator.paysecurity.FinArExcessBusValidator;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import org.apache.commons.lang.StringUtils;

public class FinArSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinArSaveOp.class);
    private final List<Long> writeOffBillPks = new ArrayList<Long>(1);
    private final List<Long> failedPks = new ArrayList<Long>(1);
    private static final ReentrantLock lock = new ReentrantLock();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if (!"true".equals(isAppend)) {
            e.addValidator((AbstractValidator)new FinArBillImportValidator());
        }
        e.addValidator((AbstractValidator)new SupplierandMaterial4VmiValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new WriteOffBillValidator(this.writeOffBillPks));
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction start");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeEmptyPlanEntry start");
        this.removeEmptyPlanEntry(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeEmptyPlanEntry end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction sortPlanDueDate start");
        ArApHelper.sortPlanDueDate((DynamicObject[])entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction sortPlanDueDate end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setBookDate start");
        BookDateHelper.billSavesetBookDate((DynamicObject[])entities, (boolean)true);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setBookDate end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeEmptyPreEntry start");
        ArApRecOrPayBillHelper.removeEmptyPreEntry((DynamicObject[])entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeEmptyPreEntry end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction sortPreEntryByDate start");
        ArApRecOrPayBillHelper.sortPreEntryByDate((DynamicObject[])entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction sortPreEntryByDate end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction writtenOffVerifyDispose start");
        this.writtenOffVerifyDispose(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction writtenOffVerifyDispose end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setAcctAgeCalcDate start");
        this.setAcctAgeCalcDate(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setAcctAgeCalcDate end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeSubEntry start");
        this.removeSubEntry(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction removeSubEntry end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setImptCustomers start");
        this.setImptCustomers(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction setImptCustomers end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction splitPlanEntryForImport start");
        this.splitPlanEntryForImport(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction splitPlanEntryForImport end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction splitPlanEntry4InvoiceAdjust start");
        this.splitPlanEntry4InvoiceAdjust(entities);
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction splitPlanEntry4InvoiceAdjust end");
        logger.info("FinArSaveOp.beforeExecuteOperationTransaction end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinArSaveOp.beginOperationTransaction start");
        logger.info("FinArSaveOp.beginOperationTransaction appendAmt start");
        this.appendAmt(entities);
        logger.info("FinArSaveOp.beginOperationTransaction appendAmt end");
        logger.info("FinArSaveOp.writeOffBillSetAuditStatus start");
        this.writeOffBillSetAuditStatus(entities);
        logger.info("FinArSaveOp.writeOffBillSetAuditStatus end");
        logger.info("FinArSaveOp.repaireFinArAmtField start");
        ArApDataRepairHelper.repaireFinArAmtField((DynamicObject[])entities);
        logger.info("FinArSaveOp.repaireFinArAmtField end");
        logger.info("FinArBillSaveOp.beginOperationTransaction premiumSaveDispose start");
        DynamicObject[] premiumBills = (DynamicObject[])Stream.of(entities).filter(entity -> entity.getBoolean("ispremium") && !entity.getBoolean("iswrittenoff")).toArray(DynamicObject[]::new);
        this.premiumSaveDispose(premiumBills);
        logger.info("FinArBillSaveOp.beginOperationTransaction premiumSaveDispose end");
        logger.info("FinArSaveOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinArSaveOp.endOperationTransaction paysecurityvalidator start");
        this.busQtyAndAmtValidator(entities);
        logger.info("FinArSaveOp.endOperationTransaction paysecurityvalidator start");
        logger.info("FinArSaveOp.endOperationTransaction start");
        List<DynamicObject> writeOffBills = Stream.of(entities).filter(entity -> entity.getBoolean("iswrittenoff")).collect(Collectors.toList());
        writeOffBills = writeOffBills.stream().filter(bill -> !this.writeOffBillPks.contains(bill.getLong("id"))).collect(Collectors.toList());
        if (writeOffBills.size() == 0) {
            return;
        }
        logger.info("FinArSaveOp.endOperationTransaction addWriteOffCtrl start");
        this.addWriteOffCtrl(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction addWriteOffCtrl end");
        logger.info("FinArSaveOp.endOperationTransaction settle start");
        this.executeSettle(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction settle end");
        logger.info("FinArSaveOp.endOperationTransaction ArRevWriteOffVerify start");
        this.executeArRevWriteOffVerify(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction ArRevWriteOffVerify end");
        logger.info("FinArSaveOp.endOperationTransaction.executeArSaloutUnWriteOff.start");
        this.executeArSaloutUnWriteOff(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction.executeArSaloutUnWriteOff.end");
        logger.info("FinArSaveOp.endOperationTransaction.updateSettleStatusZeroBills.end");
        this.updateSettleStatusZeroBills(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction.updateSettleStatusZeroBills.end");
        logger.info("FinArSaveOp.endOperationTransaction genRevCfmBill start");
        this.genRevCfmBill(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction genRevCfmBill end");
        logger.info("FinArSaveOp.endOperationTransaction.executeArOriginalUnWriteOff.start");
        ArOriginalUnWriteOffService arOriginalUnWriteOffService = new ArOriginalUnWriteOffService();
        arOriginalUnWriteOffService.generateRedWfRecord(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction.executeArOriginalUnWriteOff.end");
        logger.info("FinArSaveOp.endOperationTransaction writebackbus start");
        this.writeBackBusBill(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction writebackbus end");
        logger.info("FinArSaveOp.endOperationTransaction writeBackSrcBillWrittenStatus start");
        this.writeBackSrcBillWrittenStatus(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction writeBackSrcBillWrittenStatus end");
        logger.info("FinArSaveOp.endOperationTransaction invalidBill start");
        this.invalidBill(writeOffBills.toArray(new DynamicObject[0]));
        logger.info("FinArSaveOp.endOperationTransaction invalidBill end");
        logger.info("FinArSaveOp.endOperationTransaction writeBackToScm start");
        this.writeBackToScm(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction writeBackToScm end");
        logger.info("FinArSaveOp.endOperationTransaction executePushRevCfmChargeAgainstBill start");
        this.executePushRevCfmChargeAgainstBill(writeOffBills);
        logger.info("FinArSaveOp.endOperationTransaction executePushRevCfmChargeAgainstBill end");
        logger.info("FinArSaveOp.endOperationTransaction end");
    }

    private void busQtyAndAmtValidator(DynamicObject[] bills) {
        if ("true".equals(StdConfig.get((String)"busPaysecurityUseTolerance"))) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (DynamicObject bill : bills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (kd.fi.arapcommon.util.StringUtils.isEmpty((String)sourceBillType) || bill.getBoolean("iswrittenoff")) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() == 0) {
            return;
        }
        FinArExcessBusValidator validator = new FinArExcessBusValidator();
        List results = validator.validate(billIds, "save");
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (BusValidatorResult result : results) {
            String message = result.getMessage();
            errMessage.add(message);
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        logger.info("FinArSaveOp.afterExecuteOperationTransaction start");
        logger.info("FinArSaveOp.afterExecuteOperationTransaction recordTaxLog start");
        TaxHelper.recordTaxLog((DynamicObject[])datas, (boolean)true);
        logger.info("FinArSaveOp.afterExecuteOperationTransaction recordTaxLog end");
        DynamicObject[] writeOffBills = Stream.of(datas).filter(data -> !this.writeOffBillPks.contains(data.getLong("id"))).collect(Collectors.toSet()).toArray(new DynamicObject[0]);
        logger.info("FinArSaveOp.afterExecuteOperationTransaction executeWriteOffBillSubmitAndAudit start");
        this.executeWriteOffBillSubmitAndAudit(writeOffBills);
        logger.info("FinArSaveOp.afterExecuteOperationTransaction executeWriteOffBillSubmitAndAudit end");
        if (!this.failedPks.isEmpty()) {
            logger.info("FinArSaveOp.afterExecuteOperationTransaction failedPks.size:" + this.failedPks.size());
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
        logger.info("FinArSaveOp.afterExecuteOperationTransaction start");
    }

    private void addWriteOffCtrl(List<DynamicObject> writeOffBills) {
        DynamicObject[] srcBills;
        HashSet<Long> srcBillIds = new HashSet<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            srcBillIds.add(writeOffBill.getLong("sourcebillid"));
        }
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_finarbill", (String)ConcuCtrlBizEnum.WRITEOFF.getValue(), srcBillIds, (boolean)false);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)})) {
            if (!srcBill.getBoolean("hadwrittenoff")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u7ecf\u88ab\u51b2\u9500\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArSaveOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void executeSettle(List<DynamicObject> writeOffBills) {
        AbstractSettleTemplate service = SettleServiceFactory.getService((String)SettleRelationEnum.ARWRITEOFF.getValue());
        JournalService journalService = new JournalService();
        for (DynamicObject writeOffBill : writeOffBills) {
            long srcBillID = writeOffBill.getLong("sourcebillid");
            Date bookDate = writeOffBill.getDate("bookdate");
            try {
                WriteOffUnSettleService unSettleService = new WriteOffUnSettleService(Long.valueOf(srcBillID), bookDate, true);
                unSettleService.unSettle();
            }
            catch (KDBizException e1) {
                this.failedPks.add(writeOffBill.getLong("id"));
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue(writeOffBill.getPkValue());
                errorInfo.setErrorLevel(ErrorLevel.Error.name());
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684\u5e94\u6536\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0 : %2$s", (String)"FinArSaveOp_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), writeOffBill.getString("billno"), e1.getMessage()));
                this.operationResult.addErrorInfo(errorInfo);
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"ar_finarbill");
            DynamicObject[] mainRows = new DynamicObject[]{srcBill};
            DynamicObject[] asstRows = new DynamicObject[]{writeOffBill};
            SettleSchemeVO scheme = new SettleSchemeVO();
            int settleParam = ArApHelper.getArSettleParam((Object)srcBill.getLong("org.id"));
            if (settleParam == 1) {
                scheme.setOnlyByBotp(true);
            }
            service.settle(mainRows, asstRows, scheme, SettleTypeEnum.AUTO.getValue());
            journalService.pushAndSaveJournals(new DynamicObject[]{writeOffBill});
            List finPrems = FinarPremHelper.gettargetFinPrem((DynamicObject)srcBill);
            if (finPrems == null || finPrems.size() <= 0) continue;
            for (DynamicObject finPrem : finPrems) {
                DynamicObject[] writeFin = BOTPHelper.push((String)"ar_finarbill", (String)"ar_finarbill", (String)"516550166468103168", (DynamicObject)finPrem, (String)ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u5931\u8d25", (String)"FinArBillSaveOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                if (writeFin.length <= 0) continue;
                OperationResult saveReault = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])writeFin, (OperateOption)OperateOption.create());
                OperationHelper.assertResult((OperationResult)saveReault);
            }
        }
    }

    private void executeArRevWriteOffVerify(List<DynamicObject> writeOffBills) {
        ArRevWrittenOffVerifyService arRevWrittenOffVerifyService = new ArRevWrittenOffVerifyService();
        arRevWrittenOffVerifyService.writtenOffVerify(writeOffBills);
    }

    private void executeArSaloutUnWriteOff(List<DynamicObject> writeOffBills) {
        ArSaloutUnWriteOffService arSaloutUnWriteOffService = new ArSaloutUnWriteOffService();
        arSaloutUnWriteOffService.generateRedWfRecord(writeOffBills);
    }

    private void genRevCfmBill(List<DynamicObject> writeOffBills) {
        for (DynamicObject writeOffBill : writeOffBills) {
            try {
                RevCfmBillSerivceHelper.getInstance().genRevCfmBill(new DynamicObject[]{writeOffBill});
            }
            catch (KDBizException e1) {
                this.failedPks.add(writeOffBill.getLong("id"));
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue(writeOffBill.getPkValue());
                errorInfo.setErrorLevel(ErrorLevel.Error.name());
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684\u8d22\u52a1\u5e94\u6536\u5355\u81ea\u52a8\u4e0b\u63a8\u6536\u5165\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0 : %2$s", (String)"FinArSaveOp_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), writeOffBill.getString("billno"), e1.getMessage()));
                this.operationResult.addErrorInfo(errorInfo);
            }
        }
    }

    private void writeBackBusBill(List<DynamicObject> writeOffBills) {
        try {
            BusWoffHelper.finWriteOffWriteBackBusForSave((boolean)true, writeOffBills);
        }
        catch (KDBizException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5931\u8d25 : %s", (String)"FinArSaveOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), e1.getMessage()));
        }
    }

    private void writeOffBillSetAuditStatus(DynamicObject[] entities) {
        Long curUserPk = RequestContext.get().getCurrUserId();
        DynamicObject curUser = BusinessDataServiceHelper.loadSingleFromCache((Object)curUserPk, (String)"bos_user");
        Date curDate = new Date();
        for (DynamicObject bill : entities) {
            if (!bill.getBoolean("iswrittenoff")) continue;
            bill.set("billstatus", (Object)"C");
            bill.set("auditor", (Object)curUser);
            bill.set("auditdate", (Object)curDate);
        }
    }

    private void writeBackToScm(List<DynamicObject> writeOffBills) {
        List salContractParamList;
        ArrayList paramList = new ArrayList(writeOffBills.size());
        ArApProcessParamsHelper.processArToSm(paramList, (DynamicObject[])writeOffBills.toArray(new DynamicObject[0]), (boolean)true);
        List salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
        if (salOrderParamList.size() > 0) {
            Settle4ScmcHelper.disposeArToSalOrder(salOrderParamList, (boolean)true);
            Settle4ScmcHelper.disposeSaleCont(salOrderParamList, (boolean)true);
        }
        if ((salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList())).size() > 0) {
            Settle4ScmcHelper.disposeSaleCont(salContractParamList, (boolean)true);
        }
    }

    private void appendAmt(DynamicObject[] datas) {
        if (this.isAppendEntryRows()) {
            for (DynamicObject data : datas) {
                if (!data.getBoolean("iswrittenoff")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u7684\u8f6c\u6362\u89c4\u5219\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u4e0b\u63a8\u81ea\u52a8\u4fdd\u5b58\u201d\u6309\u94ae\u3002\u5982\u679c\u6e90\u5355\u7269\u6599\u884c\u5206\u5f55\u7684\u5927\u5c0f\u8d85\u8fc7\u5e73\u53f0\u9650\u5236\u768420000\u884c\u5206\u5f55,\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u91c7\u7528\u540e\u53f0\u51b2\u9500\u7684\u65b9\u5f0f\u5904\u7406:https://vip.kingdee.com/knowledge/specialDetail/223800781941044992?category=433217318319929600&id=464213782940848384&productLineId=2", (String)"FinArSaveOp_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isAppendEntryRows() {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        return "true".equals(isAppend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void appendHeadAmt(DynamicObject[] datas) {
        try {
            lock.lock();
            for (DynamicObject data : datas) {
                String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                if (amtJson != null) {
                    amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                    data.set("recamount", (Object)data.getBigDecimal("recamount").add(amtMap.getOrDefault("recamount", BigDecimal.ZERO)));
                    data.set("reclocalamt", (Object)data.getBigDecimal("reclocalamt").add(amtMap.getOrDefault("reclocalamt", BigDecimal.ZERO)));
                    data.set("amount", (Object)data.getBigDecimal("amount").add(amtMap.getOrDefault("amount", BigDecimal.ZERO)));
                    data.set("localamt", (Object)data.getBigDecimal("localamt").add(amtMap.getOrDefault("localamt", BigDecimal.ZERO)));
                    data.set("tax", (Object)data.getBigDecimal("tax").add(amtMap.getOrDefault("tax", BigDecimal.ZERO)));
                    data.set("unverifyamount", (Object)data.getBigDecimal("unverifyamount").add(amtMap.getOrDefault("unverifyamount", BigDecimal.ZERO)));
                    data.set("unsettleamount", (Object)data.getBigDecimal("unsettleamount").add(amtMap.getOrDefault("unsettleamount", BigDecimal.ZERO)));
                    data.set("unsettlelocalamt", (Object)data.getBigDecimal("unsettlelocalamt").add(amtMap.getOrDefault("unsettlelocalamt", BigDecimal.ZERO)));
                    data.set("adjustamount", (Object)data.getBigDecimal("adjustamount").add(amtMap.getOrDefault("adjustamount", BigDecimal.ZERO)));
                    data.set("adjustlocalamt", (Object)data.getBigDecimal("adjustlocalamt").add(amtMap.getOrDefault("adjustlocalamt", BigDecimal.ZERO)));
                }
                this.buildAmtMap(amtMap, data);
                ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    private void appendPlanAmt(DynamicObject[] datas) {
        String selector = "settlementtype,basecurrency,currency,exchangerate,paycond,recamount,duedate,reclocalamt,planentity.seq,planentity.planpricetax,planentity.unplanlockamt,planentity.unplansettleamt,planentity.planpricetaxloc,planentity.unplansettlelocamt,planentity.planduedate,planentity.plansettletype";
        List ids = Stream.of(datas).map(data -> data.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dbFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dbFinArBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> dbFinArMap = new HashMap<Long, DynamicObject>(dbFinArBills.length);
        for (DynamicObject dbFinArBill : dbFinArBills) {
            dbFinArMap.put(dbFinArBill.getLong("id"), dbFinArBill);
        }
        FinPlanRowService planRowService = new FinPlanRowService();
        for (DynamicObject finArBill : datas) {
            Date planMaxDuedate = null;
            DynamicObject settlementType = finArBill.getDynamicObject("settlementtype");
            DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
            int baseprecision = bascur.getInt("amtprecision");
            int amtprecision = finArBill.getInt("currency.amtprecision");
            List planRows = planRowService.calculatePlanRows(finArBill);
            BigDecimal amt = BigDecimal.ZERO;
            BigDecimal amtLoc = BigDecimal.ZERO;
            BigDecimal rate = finArBill.getBigDecimal("exchangerate");
            DynamicObjectCollection planEntities = finArBill.getDynamicObjectCollection("planentity");
            DynamicObjectCollection dbPlanEntryDatas = ((DynamicObject)dbFinArMap.get(finArBill.getLong("id"))).getDynamicObjectCollection("planentity");
            planEntities.clear();
            for (int i = 0; i < planRows.size(); ++i) {
                DynamicObject planEntry = new DynamicObject(planEntities.getDynamicObjectType());
                PlanRow planRow = (PlanRow)planRows.get(i);
                DynamicObject dbPlanRow = (DynamicObject)dbPlanEntryDatas.get(i);
                Date palnDuedate = planRow.getDueDate();
                BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
                BigDecimal planAmtLoc = planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP);
                amt = amt.add(planAmt.setScale(amtprecision, RoundingMode.HALF_UP));
                amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, RoundingMode.HALF_UP));
                if (i == planRows.size() - 1) {
                    BigDecimal priceLoc;
                    BigDecimal price;
                    BigDecimal pricetaxtotal = finArBill.getBigDecimal("recamount");
                    BigDecimal planpricetaxloc = finArBill.getBigDecimal("reclocalamt");
                    if (amt.compareTo(pricetaxtotal) > 0) {
                        price = amt.subtract(pricetaxtotal);
                        planAmt = planAmt.subtract(price);
                    } else if (amt.compareTo(pricetaxtotal) < 0) {
                        price = pricetaxtotal.subtract(amt);
                        planAmt = planAmt.add(price);
                    }
                    if (amtLoc.compareTo(planpricetaxloc) > 0) {
                        priceLoc = amtLoc.subtract(planpricetaxloc);
                        planAmtLoc = planAmtLoc.subtract(priceLoc);
                    } else if (amtLoc.compareTo(planpricetaxloc) < 0) {
                        priceLoc = planpricetaxloc.subtract(amtLoc);
                        planAmtLoc = planAmtLoc.add(priceLoc);
                    }
                }
                planEntry.set("id", (Object)dbPlanRow.getLong("id"));
                planEntry.set("seq", (Object)(i + 1));
                planEntry.set("planpricetax", (Object)planAmt);
                planEntry.set("unplanlockamt", (Object)planAmt);
                planEntry.set("unplansettleamt", (Object)planAmt);
                planEntry.set("planpricetaxloc", (Object)planAmtLoc);
                planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
                planEntry.set("planduedate", (Object)palnDuedate);
                planEntry.set("plansettletype", (Object)settlementType);
                planEntry.getDataEntityState().setPushChanged(true);
                if (planMaxDuedate == null) {
                    planMaxDuedate = palnDuedate;
                } else if (palnDuedate != null) {
                    planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
                }
                planEntities.add((Object)planEntry);
            }
            if (finArBill.getDate("duedate") == null && planMaxDuedate != null) {
                finArBill.set("duedate", planMaxDuedate);
            }
            dbPlanEntryDatas.clear();
        }
        SaveServiceHelper.save((DynamicObject[])dbFinArBills);
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        amtMap.put("recamount", data.getBigDecimal("recamount"));
        amtMap.put("reclocalamt", data.getBigDecimal("reclocalamt"));
        amtMap.put("amount", data.getBigDecimal("amount"));
        amtMap.put("localamt", data.getBigDecimal("localamt"));
        amtMap.put("tax", data.getBigDecimal("tax"));
        amtMap.put("unverifyamount", data.getBigDecimal("unverifyamount"));
        amtMap.put("unsettleamount", data.getBigDecimal("unsettleamount"));
        amtMap.put("unsettlelocalamt", data.getBigDecimal("unsettlelocalamt"));
        amtMap.put("adjustamount", data.getBigDecimal("adjustamount"));
        amtMap.put("adjustlocalamt", data.getBigDecimal("adjustlocalamt"));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("iswrittenoff");
        props.add("hadwrittenoff");
        props.add("sourcebilltype");
        props.add("sourcebillid");
        props.add("recamount");
        props.add("currency");
        props.add("org");
        props.add("verifystatus");
        props.add("unverifyamount");
        props.add("entry.e_verifiedqty");
        props.add("entry.e_unverifyqty");
        props.add("entry.e_verifiedamt");
        props.add("entry.e_unverifyamt");
        props.add("entry.e_quantity");
        props.add("entry.e_amount");
        props.add("quotation");
        props.add("asstacttype");
        props.add("asstact");
        props.add("biztype");
        props.add("e_material");
        props.add("billtype");
        props.add("exchangerate");
        props.add("basecurrency");
        props.add("entry");
        props.add("e_corebilltype");
        props.add("corebillid");
        props.add("corebillentryid");
        props.add("e_baseunitqty");
        props.add("e_recamount");
        props.add("e_conbillid");
        props.add("e_conbillentryid");
        props.add("e_conbillentity");
        props.add("acctagecalcdate");
        props.add("bizdate");
        props.add("planentity.planduedate");
        props.add("bookdate");
        props.add("istransfer");
        props.add("reclocalamt");
        props.add("amount");
        props.add("localamt");
        props.add("tax");
        props.add("taxlocamt");
        props.add("unsettleamount");
        props.add("unsettlelocalamt");
        props.add("adjustamount");
        props.add("adjustlocalamt");
        props.add("billsrctype");
        props.add("entry.e_material");
        props.add("entry.e_measureunit");
        props.add("entry.e_baseunit");
        props.add("entry.e_unitcoefficient");
        props.add("entry.configuredcode");
        props.add("isperiod");
        props.add("isincludetax");
        props.add("entry.e_discountmode");
        props.add("entry.e_discountrate");
        props.add("entry.e_taxunitprice");
        props.add("entry.e_unitprice");
        props.add("entry.e_tax");
        props.add("entry.e_taxlocalamt");
        props.add("entry.e_discountamount");
        props.add("entry.e_discountlocalamt");
        props.add("entry.e_localamt");
        props.add("entry.e_reclocalamt");
        props.add("entry.e_unsettlelocalamt");
        props.add("entry.e_uninvoicedamt");
        props.add("entry.e_uninvoicedlocalamt");
        props.add("entry.e_adjustamount");
        props.add("entry.e_adjustlocalamt");
        props.add("duedate");
        props.add("planentity.planpricetax");
        props.add("billno");
        props.add("splitscheme");
        props.add("planmaterial");
        props.add("planexpenseitem");
        props.add("invoicedamt");
        props.add("invoicedlocalamt");
        props.add("uninvoicedamt");
        props.add("uninvoicedlocalamt");
        props.add("plancorebillno");
        props.add("planproject");
        props.add("plancontract");
        props.add("paymentcustomerid");
        props.add("entry.e_ispresent");
        props.add("settleamount");
        props.add("settlelocalamt");
        props.add("entry.e_lockedamt");
        props.add("entry.e_settledamt");
        props.add("entry.e_settledlocalamt");
        props.add("entry.e_verifybaseqty");
        props.add("entry.e_confirmedqty");
        props.add("entry.e_confirmedamt");
        props.add("entry.e_unlockamt");
        props.add("entry.e_unsettleamt");
        props.add("entry.e_unverifybaseqty");
        props.add("entry.e_unconfirmqty");
        props.add("entry.e_unconfirmamt");
        props.add("entry.e_invoicedamt");
        props.add("entry.e_invoicedlocalamt");
        props.add("entry.e_confirmedbaseqty");
        props.add("entry.e_unconfirmbaseqty");
        props.add("entry.e_delivercustomerid");
        props.add("entry.e_invoicecustomerid");
        props.add("planentity.planlockedamt");
        props.add("planentity.plansettledamt");
        props.add("planentity.plansettledlocamt");
        props.add("planentity.unplanlockamt");
        props.add("planentity.unplansettleamt");
        props.add("planentity.planpricetaxloc");
        props.add("planentity.unplansettlelocamt");
        props.add("planentity.seq");
        props.add("planentity.plancorebillid");
        props.add("planentity.p_splitdimensionid");
        props.add("preentry.seq");
        props.add("ispremium");
        props.add("settlementtype");
        props.add("paycond");
        props.add("entry.e_splitdimensionid");
        props.addAll(FinArBillHandleHelper.getSelector());
        props.addAll(PlanSplitSchemeServiceHelper.getNeedProperties((boolean)true));
        fieldKeys.addAll(props);
    }

    private void executeWriteOffBillSubmitAndAudit(DynamicObject[] entities) {
        ArrayList<Long> writeOffBillIds = new ArrayList<Long>(16);
        for (DynamicObject entity : entities) {
            boolean isWriteOff = entity.getBoolean("iswrittenoff");
            if (!isWriteOff) continue;
            writeOffBillIds.add(entity.getLong("id"));
        }
        if (EmptyUtils.isEmpty(writeOffBillIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"noctrlsubmit", (String)"ar_finarbill", (Object[])writeOffBillIds.toArray(new Object[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"nocheckaudit", (String)"ar_finarbill", (Object[])writeOffBillIds.toArray(new Object[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)auditResult);
        Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)this.billEntityType.getName(), (String)"nocheckaudit", writeOffBillIds, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
        logger.info("Voucher Insert White List result: " + isSuccess);
    }

    private void executePushRevCfmChargeAgainstBill(List<DynamicObject> writeOffBills) {
        try {
            List chargeAgainstSourceBills = writeOffBills.stream().filter(entity -> entity.getBoolean("iswrittenoff")).collect(Collectors.toList());
            if (EmptyUtils.isEmpty(chargeAgainstSourceBills)) {
                return;
            }
            RevCfmChargeAgainstService againstService = new RevCfmChargeAgainstService();
            List againstRevCfmBills = againstService.generate(chargeAgainstSourceBills);
            if (EmptyUtils.isEmpty((Object)againstRevCfmBills)) {
                return;
            }
            againstService.executeSubmitAndAudit(againstRevCfmBills);
            againstService.executeSourceBillDispose(againstRevCfmBills);
        }
        catch (KDBizException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\u5931\u8d25 : %s", (String)"FinArSaveOp_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), e1.getMessage()));
        }
    }

    private void invalidBill(DynamicObject[] dataEntities) {
        Object[] pkIds = Arrays.stream(dataEntities).filter(entity -> entity.getBoolean("iswrittenoff")).map(entity -> Long.valueOf(entity.getString("sourcebillid"))).toArray();
        if (EmptyUtils.isEmpty((Object)pkIds)) {
            return;
        }
        ValidOperationServiceHelper.invalid((String)"ar_finarbill", (Object[])pkIds);
    }

    private void writeBackSrcBillWrittenStatus(List<DynamicObject> writeOffBills) {
        HashSet<Long> hadWrittenOffBillIds = new HashSet<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            hadWrittenOffBillIds.add(writeOffBill.getLong("sourcebillid"));
        }
        if (EmptyUtils.isNotEmpty(hadWrittenOffBillIds)) {
            DynamicObject[] hadWrittenOffBills;
            for (DynamicObject hadWrittenOffBill : hadWrittenOffBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", hadWrittenOffBillIds)})) {
                hadWrittenOffBill.set("hadwrittenoff", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.save((DynamicObject[])hadWrittenOffBills);
        }
    }

    private Set<String> getExcludeBillTypeNum() {
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("arfin_borrowar_BT_S");
        billTypeSet.add("arfin_other_BT_S");
        billTypeSet.add("arfin_salefee_BT_S");
        return billTypeSet;
    }

    private void writtenOffVerifyDispose(DynamicObject[] datas) {
        HashMap<Long, Boolean> parmeterMap = new HashMap<Long, Boolean>(8);
        HashSet<Long> srcBillIds = new HashSet<Long>(datas.length);
        for (DynamicObject bill2 : datas) {
            boolean isWriteOff = bill2.getBoolean("iswrittenoff");
            if (!isWriteOff) continue;
            String srcBillId = bill2.getString("sourcebillid");
            srcBillIds.add(Long.parseLong(srcBillId));
            long orgId = bill2.getLong("org.id");
            Boolean ar005 = (Boolean)parmeterMap.get(orgId);
            if (ar005 != null) continue;
            ar005 = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ar_005");
            parmeterMap.put(orgId, ar005);
        }
        DynamicObjectCollection transferBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds), new QFilter("istransfer", "=", (Object)Boolean.TRUE)});
        List transferBillIds = transferBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        for (DynamicObject bill3 : datas) {
            boolean isWriteOff = bill3.getBoolean("iswrittenoff");
            if (!isWriteOff) continue;
            long srcBillId = Long.parseLong(bill3.getString("sourcebillid"));
            long orgId = bill3.getLong("org.id");
            String billTypeNumber = bill3.getString("billtype.number");
            Boolean ar005 = (Boolean)parmeterMap.get(orgId);
            if (!ar005.booleanValue() || this.getExcludeBillTypeNum().contains(billTypeNumber) || transferBillIds.contains(srcBillId)) continue;
            bill3.set("verifystatus", (Object)"verified");
            bill3.set("unverifyamount", (Object)BigDecimal.ZERO);
            DynamicObjectCollection entry = bill3.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                row.set("e_verifiedqty", (Object)row.getBigDecimal("e_quantity"));
                row.set("e_unverifyqty", (Object)BigDecimal.ZERO);
                row.set("e_verifiedamt", (Object)row.getBigDecimal("e_amount"));
                row.set("e_unverifyamt", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void splitPlanEntryForImport(DynamicObject[] entities) {
        String billSrctype = entities[0].getString("billsrctype");
        if (BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype) && this.isSplitPlanEntry()) {
            this.splitPlanEntry(entities);
        }
    }

    private void splitPlanEntry4InvoiceAdjust(DynamicObject[] entities) {
        String billSrctype = entities[0].getString("billsrctype");
        if (BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(billSrctype)) {
            PlanSplitAndBuilder.splitAndBuild((DynamicObject[])entities);
        }
    }

    private void setImptCustomers(DynamicObject[] entities) {
        List customerBills = Arrays.stream(entities).filter(s -> ("1".equals(s.getString("billsrctype")) || "3".equals(s.getString("billsrctype"))) && "bd_customer".equals(s.getString("asstacttype"))).collect(Collectors.toList());
        if (customerBills.size() > 0) {
            FinArBillHelper.setImptCustomers(customerBills);
        }
    }

    private void removeSubEntry(DynamicObject[] entities) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            for (DynamicObject data : entities) {
                DynamicObjectCollection entryList = data.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryList) {
                    Optional<IDataEntityProperty> findFirst = entry.getDataEntityType().getProperties().stream().filter(p -> "subentryentity".equals(p.getName())).findFirst();
                    if (!findFirst.isPresent()) continue;
                    entry.getDynamicObjectCollection("subentryentity").clear();
                }
            }
        }
    }

    private void setAcctAgeCalcDate(DynamicObject[] entities) {
        HashMap orgMap = new HashMap();
        for (DynamicObject bill : entities) {
            FinArBillHelper.setAcctAgeCalcDate((DynamicObject)bill, orgMap);
        }
    }

    private void splitPlanEntry(DynamicObject[] datas) {
        ArrayList<DynamicObject> needSplitDatas = new ArrayList<DynamicObject>(8);
        ArrayList<Long> splitSchemeIds = new ArrayList<Long>(8);
        ArrayList<DynamicObject> needMatchSplitDatas = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            if ("C".equals(data.getString("billstatus"))) continue;
            if (data.getDynamicObject("splitscheme") != null) {
                splitSchemeIds.add(data.getDynamicObject("splitscheme").getLong("id"));
                needSplitDatas.add(data);
                continue;
            }
            needMatchSplitDatas.add(data);
        }
        DynamicObject[] schemes = PlanSplitSchemeServiceHelper.getSchemesBySchemeIds((String)this.billEntityType.getName(), splitSchemeIds);
        HashMap<Long, DynamicObject> schemeMap = new HashMap<Long, DynamicObject>(schemes.length);
        for (DynamicObject scheme : schemes) {
            schemeMap.put(scheme.getLong("id"), scheme);
        }
        for (DynamicObject needSplitData : needSplitDatas) {
            PlanSplitAndBuilder.splitAndBuild((DynamicObject)needSplitData, (DynamicObject)((DynamicObject)schemeMap.get(needSplitData.getDynamicObject("splitscheme").getLong("id"))));
        }
        PlanSplitAndBuilder.splitAndBuildByApi((DynamicObject[])needMatchSplitDatas.toArray(new DynamicObject[0]));
    }

    private boolean isSplitPlanEntry() {
        String isSplitPlanEntry = StdConfig.get((String)"isSplitPlanEntry");
        return isSplitPlanEntry == null || "true".equals(isSplitPlanEntry);
    }

    private void removeEmptyPlanEntry(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObjectCollection planEntryCol = bill.getDynamicObjectCollection("planentity");
            if (ObjectUtils.isEmpty((Object)planEntryCol)) continue;
            DynamicObject planEntry = (DynamicObject)planEntryCol.get(0);
            planEntryCol.removeIf(row -> row.getBigDecimal("planpricetax").compareTo(BigDecimal.ZERO) == 0);
            if (planEntryCol.size() != 0) continue;
            planEntryCol.add((Object)planEntry);
        }
    }

    private void premiumSaveDispose(DynamicObject[] finBills) {
        List<DynamicObject> noSavedPremiumBills = this.getNoSavedPremiumBills(finBills);
        if (noSavedPremiumBills.isEmpty()) {
            return;
        }
        ArrayList<Long> premiumSourceBillIds = new ArrayList<Long>(noSavedPremiumBills.size());
        for (DynamicObject bill : noSavedPremiumBills) {
            premiumSourceBillIds.add(bill.getLong("sourcebillid"));
        }
        QFilter[] sourceBillFilters = new QFilter[]{new QFilter("id", "in", premiumSourceBillIds)};
        List selectors = FinArBillHandleHelper.getLockWBSelector();
        selectors.add("creator");
        selectors.add("billno");
        DynamicObject[] sourceFinBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", selectors), (QFilter[])sourceBillFilters);
        HashMap<Object, DynamicObject> sourceFinBillsMap = new HashMap<Object, DynamicObject>(sourceFinBills.length);
        for (DynamicObject finBill : sourceFinBills) {
            sourceFinBillsMap.put(finBill.getPkValue(), finBill);
        }
        for (DynamicObject premiumBill : noSavedPremiumBills) {
            Long sourceBillId = premiumBill.getLong("sourcebillid");
            DynamicObject sourceFinBill = (DynamicObject)sourceFinBillsMap.get(sourceBillId);
            Object srcCreator = sourceFinBill.get("creator");
            premiumBill.set("creator", srcCreator);
            premiumBill.set("modifier", srcCreator);
            ArPremiumWBFinBillServiceHelper.saveWriteBack((DynamicObject)sourceFinBill, (DynamicObject)premiumBill);
            String billno = sourceFinBill.getString("billno");
            DynamicObjectCollection entryCol = sourceFinBill.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal price = entryInfo.getBigDecimal("e_recamount");
                BigDecimal lockedAmt = entryInfo.getBigDecimal("e_lockedamt");
                if ((price.compareTo(BigDecimal.ZERO) <= 0 || lockedAmt.compareTo(price) <= 0) && (price.compareTo(BigDecimal.ZERO) >= 0 || lockedAmt.compareTo(price) >= 0)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5e94\u6536\u5355\u8d28\u4fdd\u91d1\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u7684\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u4fe1\u606f\u3002", (String)"FinArSaveOp_6", (String)"fi-ar-opplugin", (Object[])new Object[0]), billno));
            }
        }
        SaveServiceHelper.save((DynamicObject[])sourceFinBills);
    }

    private List<DynamicObject> getNoSavedPremiumBills(DynamicObject[] finBills) {
        ArrayList<Object> premiumBillIds = new ArrayList<Object>(1);
        ArrayList<DynamicObject> premiumBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject bill2 : finBills) {
            if (!bill2.getBoolean("ispremium")) continue;
            premiumBills.add(bill2);
            Object pkValue = bill2.getPkValue();
            if (EmptyUtils.isEmpty((Object)pkValue)) continue;
            premiumBillIds.add(pkValue);
        }
        if (!premiumBillIds.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", premiumBillIds)};
            DynamicObjectCollection savedPremiumBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])filters);
            Set savedPremiumBillIds = savedPremiumBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
            Iterator iterator = premiumBills.iterator();
            while (iterator.hasNext()) {
                DynamicObject premiumBill = (DynamicObject)iterator.next();
                Long billId = premiumBill.getLong("id");
                if (!savedPremiumBillIds.contains(billId)) continue;
                iterator.remove();
            }
        }
        return premiumBills;
    }

    private void updateSettleStatusZeroBills(List<DynamicObject> writeOffBills) {
        DynamicObject[] noSettleBills;
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>(4);
        List writeOffBillIds = writeOffBills.stream().map(temp -> temp.getLong("id")).collect(Collectors.toList());
        for (DynamicObject bill : noSettleBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,recamount,settleversion,settlestatus,e_recamount,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,unplansettlelocamt,plansettledamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", writeOffBillIds), new QFilter("settlestatus", "=", (Object)"unsettle")})) {
            if (!this.checkAmt4Settled(bill, orgMap)) continue;
            bill.set("settlestatus", (Object)ARSettleStatusEnum.SETTLED.getValue());
            DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                BigDecimal planPricetaxLoc = planEntry.getBigDecimal("planpricetaxloc");
                planEntry.set("unplanlockamt", (Object)BigDecimal.ZERO);
                planEntry.set("planlockedamt", (Object)planPricetax);
                planEntry.set("unplansettleamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledamt", (Object)planPricetax);
                planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledlocamt", (Object)planPricetaxLoc);
            }
        }
        SaveServiceHelper.save((DynamicObject[])noSettleBills);
    }

    private boolean checkAmt4Settled(DynamicObject entity, Map<Long, Integer> orgMap) {
        boolean isSettled;
        block4: {
            block5: {
                if (BigDecimal.ZERO.compareTo(entity.getBigDecimal("recamount")) != 0) {
                    return false;
                }
                isSettled = true;
                Long orgPk = entity.getDynamicObject("org").getLong("id");
                Integer param = orgMap.get(orgPk);
                if (ObjectUtils.isEmpty((Object)param)) {
                    param = ArApHelper.getArSettleParam((Object)orgPk);
                    orgMap.put(orgPk, param);
                }
                if (1 != param) break block5;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("e_recamount")) == 0) continue;
                    isSettled = false;
                    break block4;
                }
                break block4;
            }
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion((DynamicObject)entity);
            if (isOldVersion) break block4;
            DynamicObjectCollection planEntries = entity.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                if (BigDecimal.ZERO.compareTo(planEntry.getBigDecimal("planpricetax")) == 0) continue;
                isSettled = false;
            }
        }
        return isSettled;
    }
}

