/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.servicehelper.RevCfmBillSerivceHelper;
import kd.fi.ar.mservice.ArAdjustAutoSettleService;
import kd.fi.ar.mservice.ArFinTransferAutoSettleService;
import kd.fi.ar.mservice.ArPremAutoSettleService;
import kd.fi.ar.mservice.ArReceiveAutoSettleService;
import kd.fi.ar.mservice.ArReceiveSettleService;
import kd.fi.ar.mservice.SettleServiceHelper;
import kd.fi.ar.validator.FinArBillPremAuditValidator;
import kd.fi.ar.validator.FinArToBusQtyAndAmtToleranceValidator;
import kd.fi.ar.validator.FinarBillAudValidator;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.FinBillFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.opplugin.ArApSuiteValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.FinBillPreInfoValidator;
import kd.fi.arapcommon.service.bus.ArWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.fin.FinCoordinationService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PremiumConvertServiceHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.FinArExitPremiumWBServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class FinarBillAuditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinarBillAuditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new FinarBillAudValidator());
        e.addValidator((AbstractValidator)new FinBillPreInfoValidator(true));
        e.addValidator((AbstractValidator)new ArApSuiteValidator());
        e.addValidator((AbstractValidator)new FinArBillPremAuditValidator());
        e.addValidator((AbstractValidator)new FinArToBusQtyAndAmtToleranceValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] finBills = e.getDataEntities();
        logger.info("FinarBillAuditOp.beginOperationTransaction start");
        logger.info("FinarBillAuditOp.beginOperationTransaction setBookDate start");
        BookDateHelper.setBookDate((DynamicObject[])finBills, (boolean)true);
        logger.info("FinarBillAuditOp.beginOperationTransaction setBookDate end");
        logger.info("FinarBillAuditOp.beginOperationTransaction setSrcIdAndEntryIdForAdjustBill start");
        this.setSrcIdAndEntryIdForAdjustBill(finBills);
        logger.info("FinarBillAuditOp.beginOperationTransaction setSrcIdAndEntryIdForAdjustBill end");
        logger.info("FinarBillAuditOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinarBillAuditOp.endOperationTransaction start");
        logger.info("FinarBillAuditOp.endOperationTransaction autosettle start");
        this.autoSettle(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction autosettle end");
        logger.info("FinarBillAuditOp.endOperationTransaction writeBackToScm start");
        this.writeBackToScm(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction writeBackToScm end");
        logger.info("FinarBillAuditOp.endOperationTransaction autoPushPrem start");
        this.autoPushPremium(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction autoPushPrem end");
        logger.info("FinarBillAuditOp.endOperationTransaction coordination start");
        FinCoordinationService coordinationService = FinBillFactory.getCoordinationService((boolean)true);
        coordinationService.kdtxCoordination(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction coordination end");
        logger.info("FinarBillAuditOp.endOperationTransaction autoWoff start");
        this.autoWoff(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction autoWoff end");
        logger.info("FinarBillAuditOp.endOperationTransaction genRevCfmBill start");
        this.genRevCfmBill(entities);
        logger.info("FinarBillAuditOp.endOperationTransaction genRevCfmBill end");
        logger.info("FinarBillAuditOp.endOperationTransaction end");
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        logger.info("FinarBillAuditOp rollbackOperation begin");
        DynamicObject[] dataEntitys = e.getDataEntitys();
        List finArBillId = Arrays.stream(dataEntitys).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        List revcfmBillIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_revcfmbill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finArBillId)}, (String)"", (int)-1);
        if (ObjectUtils.isEmpty((Object)revcfmBillIds)) {
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"nocheckdel", (String)"ar_revcfmbill", (Object[])revcfmBillIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
        logger.info("FinarBillAuditOp rollbackOperation operationResult message: " + operationResult.getMessage());
    }

    private void autoWoff(DynamicObject[] entities) {
        try {
            Boolean woffServiceV2 = BusWoffHelper.woffServiceV2();
            logger.info("audit.woff.woffServiceV2:" + woffServiceV2);
            if (woffServiceV2.booleanValue()) {
                ArWoffService woffService = new ArWoffService();
                Set srcBusIds = woffService.initWoffDetailInfo(entities);
                if (ObjectUtils.isEmpty((Object)srcBusIds)) {
                    return;
                }
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_busbill", (String)"woff", (Set)srcBusIds);
                woffService.genWoffBill();
            } else {
                BusWoffHelper.doBusWoffFromFinAr((DynamicObject[])entities);
            }
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5931\u8d25 : %s", (String)"FinArBillAuditOp_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void autoPushPremium(DynamicObject[] entities) {
        List sourceBillIds = Arrays.stream(entities).map(v -> v.getString("id")).collect(Collectors.toList());
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceBillIds), new QFilter("ispremium", "=", (Object)Boolean.TRUE)});
        HashSet<Long> hasPremBillIds = new HashSet<Long>();
        for (DynamicObject[] coll : colls) {
            hasPremBillIds.add(Long.valueOf(coll.getString("sourcebillid")));
        }
        HashMap<Long, DynamicObject> canPushPremBillsMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject data : entities) {
            boolean isPremium = data.getBoolean("ispremium");
            BigDecimal premiumAmt = data.getBigDecimal("premiumamt");
            if (premiumAmt.compareTo(BigDecimal.ZERO) == 0 || isPremium || hasPremBillIds.contains(data.getLong("id"))) continue;
            canPushPremBillsMap.put(data.getLong("id"), data);
        }
        if (!ObjectUtils.isEmpty(canPushPremBillsMap)) {
            try {
                PremiumConvertServiceHelper.pushAndSave(canPushPremBillsMap, (String)"ar_finarbill");
            }
            catch (KDBizException e) {
                String message = e.getMessage();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u8d28\u4fdd\u91d1\u4e0b\u63a8\u5931\u8d25 : %s", (String)"FinarBillAuditOp_5", (String)"fi-ar-opplugin", (Object[])new Object[0]), message));
            }
        }
    }

    private void autoSettle(DynamicObject[] entities) {
        Set submitSettleFinIds;
        DynamicObject[] submitSettleFinBills;
        List settledBills;
        ArAdjustAutoSettleService settleService;
        List<Object> needArRecSettleBills = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> needArAdjustSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needArTranferSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needUpdateSettleStatusZeroBills = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> needArPremSettleBills = new ArrayList<DynamicObject>(1);
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>(4);
        for (DynamicObject entity2 : entities) {
            if ("ar_finarmodifybill".equals(entity2.get("billtype"))) continue;
            int isAdjust = BillTypeConsts.ARFIN_BORROW.equals(entity2.getLong("billtype.id"));
            if (this.checkAmt4Settled(entity2, orgMap)) {
                needUpdateSettleStatusZeroBills.add(entity2);
                continue;
            }
            if (isAdjust == 0) {
                needArRecSettleBills.add(entity2);
            }
            if (entity2.getBoolean("istransfer")) {
                needArTranferSettleBills.add(entity2);
            }
            if (isAdjust != 0) {
                needArAdjustSettleBills.add(entity2);
            }
            if (!entity2.getBoolean("ispremium")) continue;
            needArPremSettleBills.add(entity2);
        }
        if (!needUpdateSettleStatusZeroBills.isEmpty()) {
            DynamicObject[] needSaveZeroBills;
            List zeroArBillIds = needUpdateSettleStatusZeroBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
            for (DynamicObject zeroBill : needSaveZeroBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"settlestatus,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,unplansettlelocamt,plansettledamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", zeroArBillIds)})) {
                zeroBill.set("settlestatus", (Object)ARSettleStatusEnum.SETTLED.getValue());
                DynamicObjectCollection planEntries = zeroBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planEntry : planEntries) {
                    BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                    BigDecimal planPricetaxLoc = planEntry.getBigDecimal("planpricetaxloc");
                    planEntry.set("unplanlockamt", (Object)BigDecimal.ZERO);
                    planEntry.set("planlockedamt", (Object)planPricetax);
                    planEntry.set("unplansettleamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledamt", (Object)planPricetax);
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)planPricetaxLoc);
                }
            }
            SaveServiceHelper.save((DynamicObject[])needSaveZeroBills);
        }
        if (needArAdjustSettleBills.size() > 0) {
            settleService = new ArAdjustAutoSettleService();
            for (DynamicObject adjustBill : needArAdjustSettleBills) {
                String sourceBilltype = adjustBill.getString("sourcebilltype");
                if (!StringUtils.isNotEmpty((String)sourceBilltype) || !sourceBilltype.equals("ar_finarbill")) continue;
                long sourcebillid = adjustBill.getLong("sourcebillid");
                HashSet<Long> needAddCtrlIds = new HashSet<Long>(1);
                needAddCtrlIds.add(sourcebillid);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(needAddCtrlIds, (String)"ar_finarbill", (boolean)false);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ar_finarbill", (String)"recamount, e_lockedamt");
                BigDecimal sourcebillAmout = dynamicObject.getBigDecimal("recamount");
                DynamicObjectCollection detailentrys = dynamicObject.getDynamicObjectCollection("entry");
                BigDecimal lockedamt = BigDecimal.ZERO;
                for (DynamicObject detailentry : detailentrys) {
                    lockedamt = lockedamt.add(detailentry.getBigDecimal("e_lockedamt"));
                }
                BigDecimal adjustAmout = adjustBill.getBigDecimal("recamount").abs();
                if (sourcebillAmout.compareTo(lockedamt.add(adjustAmout)) < 0) continue;
                settleService.autoSettle(adjustBill, false);
            }
        }
        if (needArTranferSettleBills.size() > 0) {
            settleService = new ArFinTransferAutoSettleService();
            for (DynamicObject transferBill : needArTranferSettleBills) {
                settleService.autoSettle(transferBill, false);
            }
        }
        if (needArPremSettleBills.size() > 0) {
            ArPremAutoSettleService premAutoSettleService = new ArPremAutoSettleService();
            premAutoSettleService.batchAutoSettle(needArPremSettleBills.toArray(new DynamicObject[0]), false);
        }
        if (needArRecSettleBills.size() > 0 && (settledBills = Arrays.stream(submitSettleFinBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"settlestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", submitSettleFinIds = needArRecSettleBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet()))})).filter(bill -> !"unsettle".equals(bill.getString("settlestatus"))).collect(Collectors.toList())).size() > 0) {
            List entityIds = settledBills.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
            QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.RECSETTLE.getValue());
            filter.and("mainbillid", "in", entityIds);
            filter.and("billstatus", "=", (Object)"B");
            List submitSettleRecordIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_settlerecord", (QFilter[])filter.toArray(), (String)"", (int)-1);
            DynamicObject[] submitSettleRecords = BusinessDataServiceHelper.load((Object[])submitSettleRecordIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_settlerecord"));
            if (submitSettleRecords.length > 0) {
                SettleRecordOpHelper.sumbitStatusSettleRecordAudit(Arrays.asList(submitSettleRecords), (String)"ar_settlerecord");
            }
        }
        if (needArRecSettleBills.size() > 0 && (needArRecSettleBills = needArRecSettleBills.stream().filter(bill -> "unsettle".equals(bill.getString("settlestatus"))).collect(Collectors.toList())).size() > 0) {
            BigDecimal disposeAmount;
            DynamicObject[] existHasPremiumBills;
            ArrayList<Long> existHasPremiumBillIds;
            ArrayList<Object> needSettleBillList = new ArrayList<Object>(1);
            ArrayList<DynamicObject> settleByPreEntryBillList = new ArrayList<DynamicObject>(needArRecSettleBills.size());
            ArrayList<Object> settleByCoreBillBillList = new ArrayList<Object>(needArRecSettleBills.size());
            List orgIds = needArRecSettleBills.stream().map(bill -> bill.getLong("org.id")).distinct().collect(Collectors.toList());
            Map appParametersMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.TRUE, orgIds, (String[])new String[]{"ar_013", "ar_003"});
            for (Object arRecSettleBill : needArRecSettleBills) {
                long l = arRecSettleBill.getLong("org.id");
                Map orgParametersMap = (Map)appParametersMap.get(l);
                boolean isPeriod = arRecSettleBill.getBoolean("isperiod");
                DynamicObjectCollection preEntries = arRecSettleBill.getDynamicObjectCollection("preentry");
                boolean isNeedSettle = false;
                if (!ObjectUtils.isEmpty((Object)preEntries)) {
                    settleByPreEntryBillList.add((DynamicObject)arRecSettleBill);
                    isNeedSettle = true;
                }
                DynamicObjectCollection detailEntries = arRecSettleBill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries) {
                    String corebillno = detailEntry.getString("e_corebillno");
                    if (!StringUtils.isNotEmpty((String)corebillno) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ar_013")).booleanValue()) continue;
                    settleByCoreBillBillList.add(arRecSettleBill);
                    isNeedSettle = true;
                    break;
                }
                if (!isNeedSettle) continue;
                needSettleBillList.add(arRecSettleBill);
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList<Long>(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount2 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount2.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    for (DynamicObject finArBill : existHasPremiumBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finArBill.getBigDecimal("premiumamt");
                        FinArExitPremiumWBServiceHelper.occupy((DynamicObject)finArBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])existHasPremiumBills);
                }
            }
            if (!ObjectUtils.isEmpty(settleByPreEntryBillList)) {
                this.doSettleByPreEntry(settleByPreEntryBillList);
            }
            if (!settleByCoreBillBillList.isEmpty()) {
                String settleModel;
                HashMap<String, List> needCoreSettleByModelMap = new HashMap<String, List>(8);
                existHasPremiumBills = settleByCoreBillBillList.iterator();
                while (existHasPremiumBills.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)existHasPremiumBills.next();
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ar_003");
                    List tempFinApBills = needCoreSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needCoreSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map recedBillIdsMap = SettleServiceHelper.getRecedBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                Map map = SettleServiceHelper.getRecBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                for (Map.Entry entrySet : needCoreSettleByModelMap.entrySet()) {
                    SettleSchemeVO scheme;
                    ArReceiveAutoSettleService service = new ArReceiveAutoSettleService();
                    settleModel = (String)entrySet.getKey();
                    List finArBills = (List)entrySet.getValue();
                    Set arBillIds = finArBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set recedBillIds = (Set)recedBillIdsMap.get(settleModel);
                    Set recBillIds = (Set)map.get(settleModel);
                    if (!ObjectUtils.isEmpty((Object)recedBillIds)) {
                        CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)recedBillIds, (String)"ar_receivedbill", (boolean)true);
                        scheme = new SettleSchemeVO();
                        scheme.setOnlyByCoreBill(true);
                        service.batchAutoSettle(arBillIds, "ar_receivedbill", recedBillIds, scheme);
                    }
                    if (ObjectUtils.isEmpty((Object)recBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)recBillIds, (String)"cas_recbill", (boolean)true);
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(recBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    scheme = new SettleSchemeVO();
                    scheme.setOnlyByCoreBill(true);
                    service.batchAutoSettle(arBillIds, "cas_recbill", recBillIds, scheme);
                }
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount3 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount3.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    for (DynamicObject finArBill : existHasPremiumBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finArBill.getBigDecimal("premiumamt");
                        FinArExitPremiumWBServiceHelper.release((DynamicObject)finArBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])existHasPremiumBills);
                }
            }
        }
    }

    private void genRevCfmBill(DynamicObject[] entities) {
        try {
            RevCfmBillSerivceHelper.getInstance().genRevCfmBill(entities);
        }
        catch (KDBizException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u81ea\u52a8\u4e0b\u63a8\u6536\u5165\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0 : %s", (String)"FinArBillAuditOp_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), e1.getMessage()));
        }
    }

    private void writeBackToScm(DynamicObject[] entities) {
        List salContractParamList;
        ArrayList paramList = new ArrayList(1);
        ArApProcessParamsHelper.processArToSm(paramList, (DynamicObject[])entities, (boolean)true);
        List salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
        if (salOrderParamList.size() > 0) {
            Settle4ScmcHelper.disposeArToSalOrder(salOrderParamList, (boolean)true);
            Settle4ScmcHelper.disposeSaleCont(salOrderParamList, (boolean)true);
        }
        if ((salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList())).size() > 0) {
            Settle4ScmcHelper.disposeSaleCont(salContractParamList, (boolean)true);
        }
    }

    private void setSrcIdAndEntryIdForAdjustBill(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> adjustBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isAdjust = BillTypeConsts.ARFIN_BORROW.equals(dataEntity.getLong("billtype.id"));
            String sourceBillType = dataEntity.getString("sourcebilltype");
            if (!isAdjust || !"ar_finarbill".equals(sourceBillType)) continue;
            adjustBills.add(dataEntity);
        }
        if (adjustBills.size() == 0) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcIds = new HashSet<Long>(1);
        for (DynamicObject adjustBill : adjustBills) {
            orgIds.add(adjustBill.getLong("org.id"));
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("entry");
            for (DynamicObject detailEntry : detailEntries) {
                srcIds.add(detailEntry.getLong("e_srcid"));
            }
        }
        DynamicObject[] srcFinBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,recamount,unplanlockamt,planlockedamt,settleversion,e_splitdimensionid,p_splitdimensionid", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
        HashMap<Long, DynamicObject> srcFinBillMap = new HashMap<Long, DynamicObject>(srcFinBills.length);
        for (DynamicObject srcFinBill : srcFinBills) {
            srcFinBillMap.put(srcFinBill.getLong("id"), srcFinBill);
        }
        if (srcFinBills.length == 0) {
            return;
        }
        Map settleParamMap = ArApHelper.batchGetArSettleParam(orgIds);
        Iterator iterator = adjustBills.iterator();
        while (iterator.hasNext()) {
            DynamicObject adjustBill = (DynamicObject)iterator.next();
            long orgId = adjustBill.getLong("org.id");
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("entry");
            long sourceBillId = ((DynamicObject)detailEntries.get(0)).getLong("e_srcid");
            if ((Integer)settleParamMap.get(orgId) == 2 && !SettleVersionServiceHelper.isOldVersion((DynamicObject)((DynamicObject)srcFinBillMap.get(sourceBillId)))) continue;
            iterator.remove();
        }
        if (adjustBills.size() == 0) {
            return;
        }
        Iterator iterator0 = adjustBills.iterator();
        while (iterator0.hasNext()) {
            DynamicObject adjustBill = (DynamicObject)iterator0.next();
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("entry");
            long srcBilllId = ((DynamicObject)detailEntries.get(0)).getLong("e_srcid");
            DynamicObject sourceBill = (DynamicObject)srcFinBillMap.get(srcBilllId);
            BigDecimal adjustPriceTaxTotal = adjustBill.getBigDecimal("recamount");
            if (sourceBill == null || adjustPriceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
                iterator0.remove();
                continue;
            }
            BigDecimal sourcePriceTaxTotal = sourceBill.getBigDecimal("recamount");
            DynamicObjectCollection sourcePlanEntries = sourceBill.getDynamicObjectCollection("planentity");
            BigDecimal planLockedAmt = BigDecimal.ZERO;
            for (DynamicObject planEntry : sourcePlanEntries) {
                planLockedAmt = planLockedAmt.add(planEntry.getBigDecimal("planlockedamt"));
            }
            if (adjustPriceTaxTotal.abs().add(planLockedAmt).compareTo(sourcePriceTaxTotal) <= 0) continue;
            iterator0.remove();
        }
        if (adjustBills.size() == 0) {
            return;
        }
        HashMap<Long, Integer> srcEntryIdToDimensionId = new HashMap<Long, Integer>(8);
        for (DynamicObject srcFinBill : srcFinBills) {
            DynamicObjectCollection detailEntries = srcFinBill.getDynamicObjectCollection("entry");
            for (DynamicObject detailEntry : detailEntries) {
                srcEntryIdToDimensionId.put(detailEntry.getLong("id"), detailEntry.getInt("e_splitdimensionid"));
            }
        }
        for (DynamicObject adjustBill : adjustBills) {
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("entry");
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_srcentryid");
                detailEntry.set("e_splitdimensionid", srcEntryIdToDimensionId.get(srcEntryId));
            }
        }
        this.splitPlanEntryBySrcIdAndDimensionId(adjustBills);
        this.setAdjustBillPlanEntrySrcIdAndEntryId(adjustBills, srcFinBillMap);
        this.reSetSplitDimensionId(adjustBills);
    }

    private void splitPlanEntryBySrcIdAndDimensionId(List<DynamicObject> adjustBills) {
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(2);
        ArrayList<String> dimensions = new ArrayList<String>(2);
        dimensionMappings.put("e_srcid", "p_sourcebillid");
        dimensionMappings.put("e_splitdimensionid", "p_splitdimensionid");
        dimensions.add("e_srcid");
        dimensions.add("e_splitdimensionid");
        for (DynamicObject adjustBill : adjustBills) {
            PlanSplitService splitService = new PlanSplitService(adjustBill, dimensions);
            List planRowDatas = splitService.execute();
            DynamicObjectCollection planEntries = adjustBill.getDynamicObjectCollection("planentity");
            planEntries.clear();
            DynamicObject settlementType = adjustBill.getDynamicObject("settlementtype");
            for (int i = 0; i < planRowDatas.size(); ++i) {
                PlanRowData planRowData = (PlanRowData)planRowDatas.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                Map dimensionMap = groupData.getDimensionMap();
                DynamicObject planEntry = new DynamicObject(planEntries.getDynamicObjectType());
                planEntry.set("seq", (Object)(i + 1));
                for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                    String detailKey = (String)dimensionMapping.getKey();
                    String planKey = (String)dimensionMapping.getValue();
                    Object dimensionValue = dimensionMap.get(detailKey);
                    planEntry.set(planKey, dimensionValue);
                }
                BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
                planEntry.set("planpricetax", (Object)priceTaxTotal);
                planEntry.set("unplanlockamt", (Object)priceTaxTotal);
                planEntry.set("unplansettleamt", (Object)priceTaxTotal);
                BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
                planEntry.set("unplansettlelocamt", (Object)priceTaxTotalLocal);
                planEntry.set("planduedate", (Object)planRowData.getDueDate());
                planEntry.set("plansettletype", (Object)settlementType);
                planEntry.set("p_recrate", (Object)planRowData.getRate());
                planEntries.add((Object)planEntry);
            }
        }
    }

    private void setAdjustBillPlanEntrySrcIdAndEntryId(List<DynamicObject> adjustBills, Map<Long, DynamicObject> srcFinBillMap) {
        for (DynamicObject adjustBill : adjustBills) {
            int basePrecision = adjustBill.getInt("basecurrency.amtprecision");
            String quotation = adjustBill.getString("quotation");
            BigDecimal exchange = adjustBill.getBigDecimal("exchangerate");
            DynamicObjectCollection adjustPlanEntries = adjustBill.getDynamicObjectCollection("planentity");
            ArrayList<DynamicObject> newPlanEntries = new ArrayList<DynamicObject>(1);
            int seqCount = 0;
            CloneUtils clone = new CloneUtils(true, true);
            block1: for (DynamicObject adjustPlanEntry : adjustPlanEntries) {
                BigDecimal planEntryPriceTaxTotal = adjustPlanEntry.getBigDecimal("planpricetax");
                if (planEntryPriceTaxTotal.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal planEntryPriceTaxLocalTotal = adjustPlanEntry.getBigDecimal("planpricetaxloc");
                BigDecimal planRecRate = adjustPlanEntry.getBigDecimal("p_recrate");
                BigDecimal remainAmt = planEntryPriceTaxTotal;
                BigDecimal remainLocalAmt = BigDecimal.ZERO;
                BigDecimal remainRate = BigDecimal.ZERO;
                long srcBillId = adjustPlanEntry.getLong("p_sourcebillid");
                DynamicObject sourceBill = srcFinBillMap.get(srcBillId);
                DynamicObjectCollection sourcePlanEntries = sourceBill.getDynamicObjectCollection("planentity");
                BigDecimal amtDirection = new BigDecimal(planEntryPriceTaxTotal.signum());
                for (DynamicObject sourcePlanEntry : sourcePlanEntries) {
                    int transferPlanSplitDimensionId;
                    int srcPlanSplitDimensionId = sourcePlanEntry.getInt("p_splitdimensionid");
                    if (srcPlanSplitDimensionId != (transferPlanSplitDimensionId = adjustPlanEntry.getInt("p_splitdimensionid"))) continue;
                    BigDecimal planUnLockAmt = sourcePlanEntry.getBigDecimal("unplanlockamt");
                    BigDecimal sourceUnLockAmtDirection = new BigDecimal(planUnLockAmt.signum());
                    if (planUnLockAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject planEntry = (DynamicObject)clone.clone((IDataEntityBase)adjustPlanEntry);
                    BigDecimal curEntryAmt = amtDirection.multiply(remainAmt.abs().compareTo(planUnLockAmt.abs()) > 0 ? planUnLockAmt.abs() : remainAmt.abs());
                    BigDecimal curEntryLocalAmt = this.getLocalAmt(curEntryAmt, quotation, exchange, basePrecision);
                    planEntry.set("seq", (Object)(++seqCount));
                    planEntry.set("planpricetax", (Object)curEntryAmt);
                    planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                    planEntry.set("unplansettleamt", (Object)curEntryAmt);
                    planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                    planEntry.set("unplanlockamt", (Object)curEntryAmt);
                    planEntry.set("planduedate", adjustPlanEntry.get("planduedate"));
                    planEntry.set("plansettletype", adjustBill.get("settlementtype"));
                    BigDecimal recRate = curEntryAmt.divide(planEntryPriceTaxTotal, 2, RoundingMode.DOWN).multiply(planRecRate).setScale(2, RoundingMode.DOWN);
                    planEntry.set("p_recrate", (Object)recRate);
                    planEntry.set("p_sourcebillid", (Object)srcBillId);
                    planEntry.set("p_sourcebillentryid", (Object)sourcePlanEntry.getLong("id"));
                    if (curEntryAmt.signum() != 0) {
                        newPlanEntries.add(planEntry);
                    }
                    remainAmt = remainAmt.subtract(curEntryAmt);
                    sourcePlanEntry.set("unplanlockamt", (Object)planUnLockAmt.subtract(curEntryAmt.abs().multiply(sourceUnLockAmtDirection)));
                    if (remainAmt.compareTo(BigDecimal.ZERO) == 0) {
                        curEntryLocalAmt = planEntryPriceTaxLocalTotal.subtract(remainLocalAmt);
                        planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                        planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                        planEntry.set("p_recrate", (Object)planRecRate.subtract(remainRate));
                        continue block1;
                    }
                    remainLocalAmt = remainLocalAmt.add(curEntryLocalAmt);
                    remainRate = remainRate.add(recRate);
                }
            }
            adjustPlanEntries.clear();
            adjustPlanEntries.addAll(newPlanEntries);
        }
    }

    private void reSetSplitDimensionId(List<DynamicObject> adjustBills) {
        for (DynamicObject adjustBill : adjustBills) {
            String key;
            long srcBillId;
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection planEntries = adjustBill.getDynamicObjectCollection("planentity");
            int splitDimensionIdIndex = 0;
            HashMap<String, Integer> planSrcIdToSplitDimensionId = new HashMap<String, Integer>(8);
            for (DynamicObject planEntry : planEntries) {
                srcBillId = planEntry.getLong("p_sourcebillid");
                int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
                key = srcBillId + "_" + planSplitDimensionId;
                Integer newSplitDimensionId = (Integer)planSrcIdToSplitDimensionId.get(key);
                if (newSplitDimensionId == null) {
                    planSrcIdToSplitDimensionId.put(key, splitDimensionIdIndex);
                    planEntry.set("p_splitdimensionid", (Object)splitDimensionIdIndex);
                    ++splitDimensionIdIndex;
                    continue;
                }
                planEntry.set("p_splitdimensionid", (Object)newSplitDimensionId);
            }
            for (DynamicObject detailEntry : detailEntries) {
                srcBillId = detailEntry.getLong("e_srcid");
                int detailOldSplitDimensionId = detailEntry.getInt("e_splitdimensionid");
                key = srcBillId + "_" + detailOldSplitDimensionId;
                detailEntry.set("e_splitdimensionid", planSrcIdToSplitDimensionId.get(key));
            }
        }
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }

    private boolean checkAmt4Settled(DynamicObject entity, Map<Long, Integer> orgMap) {
        boolean isSettled;
        block4: {
            block5: {
                if (BigDecimal.ZERO.compareTo(entity.getBigDecimal("recamount")) != 0) {
                    return false;
                }
                isSettled = true;
                Long orgPk = entity.getDynamicObject("org").getLong("id");
                Integer param = orgMap.get(orgPk);
                if (ObjectUtils.isEmpty((Object)param)) {
                    param = ArApHelper.getArSettleParam((Object)orgPk);
                    orgMap.put(orgPk, param);
                }
                if (1 != param) break block5;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("e_recamount")) == 0) continue;
                    isSettled = false;
                    break block4;
                }
                break block4;
            }
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion((DynamicObject)entity);
            if (isOldVersion) break block4;
            DynamicObjectCollection planEntries = entity.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                if (BigDecimal.ZERO.compareTo(planEntry.getBigDecimal("planpricetax")) == 0) continue;
                isSettled = false;
            }
        }
        return isSettled;
    }

    private void doSettleByPreEntry(List<DynamicObject> settleByPreEntryBillList) {
        Object[] receivedArr;
        HashMap<String, HashSet<Long>> preInfoMap = new HashMap<String, HashSet<Long>>(settleByPreEntryBillList.size());
        for (DynamicObject bill : settleByPreEntryBillList) {
            DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
            for (DynamicObject row : preEntry) {
                long preBillId = row.getLong("y_billid");
                String preBillType = row.getString("y_billtype");
                BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                HashSet<Long> ids = (HashSet<Long>)preInfoMap.get(preBillType);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(preBillId);
                preInfoMap.put(preBillType, ids);
            }
        }
        HashMap<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        HashMap<Long, Map<Long, BigDecimal>> asstOrgAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        Set recIds = (Set)preInfoMap.get("cas_recbill");
        Set receivedIds = (Set)preInfoMap.get("ar_receivedbill");
        Object[] recArr = this.recValidateBeforeSettle(recIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList);
        Object[] recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])(receivedArr = this.receivedValidateBeforeSettle(receivedIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList)));
        if (ObjectUtils.isEmpty((Object[])recMergeArr)) {
            return;
        }
        List tempVOs = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recMergeArr);
        Map<Long, List<BillSettleVO>> entryIdVOMap = tempVOs.stream().collect(Collectors.groupingBy(BillSettleVO::getEntryId));
        if (!ObjectUtils.isEmpty(asstUnsettleAmtMap)) {
            Map<Long, List<DynamicObject>> collect = settleByPreEntryBillList.stream().collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
            Map orgSettleEntry = ArApHelper.batchGetArSettleParam(collect.keySet());
            for (Map.Entry<Long, List<DynamicObject>> entry : collect.entrySet()) {
                DynamicObject[] mainArr;
                Long orgId = entry.getKey();
                int settleEntry = (Integer)orgSettleEntry.get(orgId);
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setSettle(true);
                scheme.setSettleEntryParam(settleEntry);
                scheme.setMatchServiceClass("kd.fi.arapcommon.service.match.PreEntrySettleMatchService");
                ArrayList<BillSettleVO> asstListVO = new ArrayList<BillSettleVO>(1);
                for (DynamicObject finBill2 : settleByPreEntryBillList) {
                    BigDecimal canSettleAmt;
                    long asstId;
                    long id = finBill2.getLong("id");
                    String mainBillno = finBill2.getString("billno");
                    int rowIndex = 1;
                    boolean isMergeRows = ((DynamicObject)finBill2.getDynamicObjectCollection("preentry").get(0)).getLong("y_billentryid") != 0L ? Boolean.TRUE : Boolean.FALSE;
                    if (isMergeRows) {
                        for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                            asstId = row.getLong("y_billid");
                            long asstEntryId = row.getLong("y_billentryid");
                            String asstBillno = row.getString("y_billno");
                            BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            canSettleAmt = (BigDecimal)((Map)asstUnsettleAmtMap.get(asstId)).get(asstEntryId);
                            if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u6536\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillAuditOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                            }
                            BillSettleVO tempVO = entryIdVOMap.get(asstEntryId).get(0);
                            BillSettleVO billSettleVO = (BillSettleVO)tempVO.clone();
                            billSettleVO.setEntryUnSettleAmt(settleAmt);
                            HashMap<String, Long> resultExtMap = new HashMap<String, Long>(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            billSettleVO.setExtFields(resultExtMap);
                            asstListVO.add(billSettleVO);
                            ++rowIndex;
                            canSettleAmt = canSettleAmt.subtract(settleAmt);
                            ((Map)asstUnsettleAmtMap.get(asstId)).put(asstEntryId, canSettleAmt);
                            Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                            BigDecimal billCanSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                            orgIdAmtMap.put(orgId, billCanSettleAmt.subtract(settleAmt));
                            asstOrgAmtMap.put(asstId, orgIdAmtMap);
                        }
                        continue;
                    }
                    for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                        asstId = row.getLong("y_billid");
                        String asstBillno = row.getString("y_billno");
                        BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                        if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        Map entryIdAmtMap = (Map)asstUnsettleAmtMap.get(asstId);
                        Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                        canSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                        if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u6536\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillAuditOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                        }
                        for (Map.Entry entry2 : entryIdAmtMap.entrySet()) {
                            HashMap<String, Long> resultExtMap;
                            BillSettleVO newVO;
                            BigDecimal entryCanSettleAmt;
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) break;
                            long entryId = (Long)entry2.getKey();
                            BillSettleVO tempVO = entryIdVOMap.get(entryId).get(0);
                            long entryOrgId = tempVO.getOrgId();
                            if (entryOrgId != orgId || (entryCanSettleAmt = (BigDecimal)entry2.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                            if (settleAmt.abs().compareTo(entryCanSettleAmt.abs()) <= 0) {
                                newVO = (BillSettleVO)tempVO.clone();
                                newVO.setEntryUnSettleAmt(settleAmt);
                                resultExtMap = new HashMap<String, Long>(1);
                                resultExtMap.put("billId", id);
                                resultExtMap.putAll(tempVO.getExtFields());
                                newVO.setExtFields(resultExtMap);
                                asstListVO.add(newVO);
                                ++rowIndex;
                                orgIdAmtMap.put(orgId, canSettleAmt.subtract(settleAmt));
                                entryCanSettleAmt = entryCanSettleAmt.subtract(settleAmt);
                                settleAmt = BigDecimal.ZERO;
                                entry2.setValue(entryCanSettleAmt);
                                continue;
                            }
                            newVO = (BillSettleVO)tempVO.clone();
                            newVO.setEntryUnSettleAmt(entryCanSettleAmt);
                            resultExtMap = new HashMap(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            newVO.setExtFields(resultExtMap);
                            asstListVO.add(newVO);
                            ++rowIndex;
                            orgIdAmtMap.put(orgId, BigDecimal.ZERO);
                            settleAmt = settleAmt.subtract((BigDecimal)entry2.getValue());
                            entry2.setValue(BigDecimal.ZERO);
                        }
                        asstOrgAmtMap.put(asstId, orgIdAmtMap);
                    }
                }
                if (ObjectUtils.isEmpty(asstListVO)) continue;
                Set mainBillIds = entry.getValue().stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                for (DynamicObject obj : mainArr = FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
                    DynamicObjectCollection detailEntry = obj.getDynamicObjectCollection("entry");
                    for (DynamicObject row : detailEntry) {
                        row.set("e_settledamt", row.get("e_lockedamt"));
                        row.set("e_unsettleamt", row.get("e_unlockamt"));
                    }
                    DynamicObjectCollection planEntry = obj.getDynamicObjectCollection("planentity");
                    for (DynamicObject row : planEntry) {
                        row.set("plansettledamt", row.get("planlockedamt"));
                        row.set("unplansettleamt", row.get("unplanlockamt"));
                    }
                }
                List mainListVO = FinArBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
                for (BillSettleVO settleVO : mainListVO) {
                    Map extFields = settleVO.getExtFields();
                    extFields.put("billId", settleVO.getId());
                    settleVO.setExtFields(extFields);
                }
                ArReceiveSettleService service = new ArReceiveSettleService();
                service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.AUTO.getValue());
            }
        }
    }

    private DynamicObject[] recValidateBeforeSettle(Set<Long> recIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(recIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(recIds, (String)"cas_recbill", (boolean)true);
        TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(recIds.stream().map(String::valueOf).collect(Collectors.toList()));
        Object[] assts = RecBillHandlerHelper.loadRec((QFilter[])new QFilter[]{new QFilter("id", "in", recIds)});
        HashSet<Long> asstIds = new HashSet<Long>(recIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            for (DynamicObject row : entry) {
                DynamicObject receivingType = row.getDynamicObject("e_receivingtype");
                long entryOrgId = row.getLong("e_settleorg.id");
                if (ObjectUtils.isEmpty((Object)receivingType) || !receivingType.getBoolean("ispartreceivable") || !"101".equals(receivingType.getString("biztype"))) continue;
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                BigDecimal orgUnSettleAmt = (BigDecimal)orgUnSettleAmtMap.get(entryOrgId);
                if (orgUnSettleAmt == null) {
                    orgUnSettleAmt = BigDecimal.ZERO;
                }
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
                orgUnSettleAmtMap.put(entryOrgId, orgUnSettleAmt);
            }
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || recIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"cas_recbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u6536\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillAuditOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private DynamicObject[] receivedValidateBeforeSettle(Set<Long> receivedIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(receivedIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(receivedIds, (String)"ar_receivedbill", (boolean)true);
        Object[] assts = RecBillHandlerHelper.loadReced((QFilter[])new QFilter[]{new QFilter("id", "in", receivedIds)});
        HashSet<Long> asstIds = new HashSet<Long>(receivedIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            BigDecimal orgUnSettleAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
            }
            orgUnSettleAmtMap.put(asst.getLong("org.id"), orgUnSettleAmt);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || receivedIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"ar_receivedbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u6536\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillAuditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> lst = new HashSet<String>(50);
        lst.add("org");
        lst.add("billno");
        lst.add("bizdate");
        lst.add("duedate");
        lst.add("asstacttype");
        lst.add("asstact");
        lst.add("billtype");
        lst.add("amount");
        lst.add("recamount");
        lst.add("currency");
        lst.add("quotation");
        lst.add("exchangerate");
        lst.add("settlestatus");
        lst.add("e_amount");
        lst.add("e_localamt");
        lst.add("e_tax");
        lst.add("e_recamount");
        lst.add("e_reclocalamt");
        lst.add("e_material");
        lst.add("e_unsettleamt");
        lst.add("e_settledamt");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("groupnumber");
        lst.add("groupseq");
        lst.add("verifystatus");
        lst.add("e_expenseitem");
        lst.add("e_measureunit");
        lst.add("e_verifiedamt");
        lst.add("e_unverifyamt");
        lst.add("e_quantity");
        lst.add("e_verifiedqty");
        lst.add("e_unverifyqty");
        lst.add("e_ispresent");
        lst.add("e_baseunit");
        lst.add("e_baseunitqty");
        lst.add("e_unitcoefficient");
        lst.add("entry.e_srcid");
        lst.add("entry.e_srcentryid");
        lst.add("e_isallverify");
        lst.add("corebillid");
        lst.add("corebillentryid");
        lst.add("billsrctype");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("istransfer");
        lst.add("iswrittenoff");
        lst.add("e_srcentryid");
        lst.add("entry.e_unsettleamt");
        lst.add("isperiod");
        lst.add("basecurrency");
        lst.add("unsettleamount");
        lst.add("unsettlelocalamt");
        lst.add("planentity.planduedate");
        lst.add("planpricetax");
        lst.add("plansettledamt");
        lst.add("unplansettleamt");
        lst.add("payproperty");
        lst.add("payproperty.isbasedonamt");
        lst.add("bookdate");
        lst.add("e_conbillentity");
        lst.add("e_conbillid");
        lst.add("e_conbillentryid");
        lst.add("e_corebilltype");
        lst.add("y_billid");
        lst.add("y_billtype");
        lst.add("y_settleamt");
        lst.add("y_billno");
        lst.add("preentry.seq");
        lst.add("entry.seq");
        lst.add("e_srcid");
        lst.add("y_billentryid");
        lst.add("entry.linetype");
        lst.add("premiumamt");
        lst.add("ispremium");
        lst.add("e_splitdimensionid");
        lst.add("paycond");
        lst.add("settlementtype");
        lst.add("planentity.seq");
        lst.add("planentity.p_splitdimensionid");
        lst.add("planentity.planpricetaxloc");
        lst.add("planentity.unplansettlelocamt");
        lst.add("planentity.p_recrate");
        lst.addAll(FinArBillHandleHelper.getSelector());
        fieldKeys.addAll(lst);
    }
}

