/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.servicehelper.RevCfmBillSerivceHelper;
import kd.fi.ar.helper.FinarPremHelper;
import kd.fi.ar.mservice.ArAdjustAutoSettleService;
import kd.fi.ar.mservice.ArFinTransferAutoSettleService;
import kd.fi.ar.mservice.ArPremAutoSettleService;
import kd.fi.ar.mservice.ArReceiveAutoSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.ar.validator.FinArBillUnAuditPushValidator;
import kd.fi.ar.validator.FinArWriteOffUnAuditValidator;
import kd.fi.ar.validator.FinarBillUnaudValidator;
import kd.fi.ar.validator.WrittenOffBillUnAuditValidator;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.factory.FinBillFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.bus.ArWoffService;
import kd.fi.arapcommon.service.buswoff.BusBotpWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusCoreBillWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusGroupWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusPrepaidWoffFromFinAr;
import kd.fi.arapcommon.service.buswoff.BusSameSourceWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcuCtrlBizEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.fin.FinWoffService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.service.verify.ArOriginalUnWriteOffService;
import kd.fi.arapcommon.service.verify.ArRevWrittenOffVerifyService;
import kd.fi.arapcommon.service.verify.ArSaloutUnWriteOffService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.validator.PayBillStatusValidator;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;
import kd.fi.arapcommon.validator.VerifyECUnFinishValidator;
import kd.fi.arapcommon.vo.ErrorInfo;

public class FinarBillUnauditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinarBillUnauditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new FinArWriteOffUnAuditValidator());
        e.addValidator((AbstractValidator)new FinArBillUnAuditPushValidator());
        e.addValidator((AbstractValidator)new FinarBillUnaudValidator());
        e.addValidator((AbstractValidator)new PayBillStatusValidator());
        e.addValidator((AbstractValidator)new VerifyECUnFinishValidator());
        e.addValidator((AbstractValidator)new WrittenOffBillUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinarBillUnauditOp.beginOperationTransaction start");
        logger.info("FinarBillUnauditOp.beginOperationTransaction writeoffbus start");
        try {
            BusWoffHelper.finWriteOffWriteBackBusForUnAudit((boolean)true, (DynamicObject[])e.getDataEntities());
        }
        catch (KDBizException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u51b2\u56de\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0: %s", (String)"FinarBillUnauditOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), e1.getMessage()));
        }
        logger.info("FinarBillUnauditOp.beginOperationTransaction writeoffbus end");
        logger.info("FinarBillUnauditOp.beginOperationTransaction writeBackToScm start");
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        ArApProcessParamsHelper.processArToSm(paramList, (DynamicObject[])entities, (boolean)false);
        this.writeBackToScm(paramList, false);
        logger.info("FinarBillUnauditOp.beginOperationTransaction writeBackToScm end");
        logger.info("FinarBillUnauditOp.beginOperationTransaction deletePremiumBill start");
        this.deletePremiumBill(entities);
        logger.info("FinarBillUnauditOp.beginOperationTransaction deletePremiumBill end");
        logger.info("FinarBillUnauditOp.beginOperationTransaction disposeUnVerify start");
        ArSaloutUnWriteOffService arSaloutUnWriteOffService = new ArSaloutUnWriteOffService();
        arSaloutUnWriteOffService.disposeUnVerify(e.getDataEntities());
        logger.info("FinarBillUnauditOp.beginOperationTransaction disposeUnVerify end");
        logger.info("FinarBillUnauditOp.beginOperationTransaction ArOriginalUnWriteOffService start");
        ArOriginalUnWriteOffService arOriginalUnWriteOffService = new ArOriginalUnWriteOffService();
        arOriginalUnWriteOffService.disposeUnVerify(e.getDataEntities());
        logger.info("FinarBillUnauditOp.beginOperationTransaction ArOriginalUnWriteOffService end");
        logger.info("FinarBillUnauditOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinarBillUnauditOp.endOperationTransaction start");
        this.addWriteOffCtrl(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction delRedRevcfmBill start");
        RevCfmBillSerivceHelper.getInstance().delRedRevcfmBill(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction delRedRevcfmBill end");
        logger.info("FinarBillUnauditOp.endOperationTransaction executeUnSettle start");
        this.executeUnSettle(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction executeUnSettle end");
        logger.info("FinarBillUnauditOp.endOperationTransaction delCoordintionBill start");
        this.delCoordintionBill(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction delCoordintionBill end");
        logger.info("FinarBillUnauditOp.endOperationTransaction unAuditDeleteAutoRecBill start");
        this.unAuditDeleteAutoRecBill(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction unAuditDeleteAutoRecBill end");
        logger.info("FinarBillUnauditOp.endOperationTransaction executeUnWoff start");
        this.executeUnWoff(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction executeUnWoff end");
        logger.info("FinarBillUnauditOp.endOperationTransaction delRevCfmBill start");
        RevCfmBillSerivceHelper.getInstance().delRevCfmBill(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction delRevCfmBill end");
        logger.info("FinarBillUnauditOp.endOperationTransaction delArRevWrittenOffVerifyRecords start");
        this.delArRevWrittenOffVerifyRecords(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction delArRevWrittenOffVerifyRecords end");
        logger.info("FinarBillUnauditOp.endOperationTransaction validBill start");
        this.validBill(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction validBill end");
        logger.info("FinarBillUnauditOp.endOperationTransaction writeOffBillsDelete start");
        this.writeOffBillsDelete(entities);
        logger.info("FinarBillUnauditOp.endOperationTransaction writeOffBillsDelete end");
        logger.info("FinarBillUnauditOp.endOperationTransaction end");
    }

    private void addWriteOffCtrl(DynamicObject[] entities) {
        DynamicObject[] srcBills;
        Set billIds = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_finarbill", (String)ConcuCtrlBizEnum.WRITEOFF.getValue(), billIds, (boolean)false);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
            if (!srcBill.getBoolean("hadwrittenoff")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u7ecf\u88ab\u51b2\u9500\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArSaveOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void executeUnSettle(DynamicObject[] entities) {
        ArFinTransferAutoSettleService settleService;
        Set idSet = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(idSet, (String)this.billEntityType.getName(), (boolean)false);
        ArrayList<DynamicObject> needArWriteOffUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needArAdjustUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needArTransferUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needArRecUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needArPremUnSettleBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject entity2 : entities) {
            if (entity2.getBoolean("iswrittenoff")) {
                needArWriteOffUnSettleBills.add(entity2);
                continue;
            }
            if (entity2.getBoolean("ispremium")) {
                needArPremUnSettleBills.add(entity2);
                continue;
            }
            if (entity2.getBoolean("istransfer")) {
                needArTransferUnSettleBills.add(entity2);
                continue;
            }
            boolean isAdjust = BillTypeConsts.ARFIN_BORROW.equals(entity2.getLong("billtype.id"));
            if (isAdjust) {
                needArAdjustUnSettleBills.add(entity2);
                continue;
            }
            if (ARSettleStatusEnum.UNSETTLE.getValue().equals(entity2.getString("settlestatus"))) continue;
            needArRecUnSettleBills.add(entity2);
        }
        if (needArWriteOffUnSettleBills.size() > 0) {
            ArrayList<Long> srcBillIds = new ArrayList<Long>(needArWriteOffUnSettleBills.size());
            for (DynamicObject writeOffBill : needArWriteOffUnSettleBills) {
                long billId = writeOffBill.getLong("id");
                long srcBillId = writeOffBill.getLong("sourcebillid");
                this.writeOff(srcBillId, billId);
                srcBillIds.add(srcBillId);
            }
            FinarPremHelper.writeOff(srcBillIds);
        }
        if (needArPremUnSettleBills.size() > 0) {
            ArPremAutoSettleService premAutoSettleService = new ArPremAutoSettleService();
            premAutoSettleService.unAutoSettle(needArPremUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needArTransferUnSettleBills.size() > 0) {
            settleService = new ArFinTransferAutoSettleService();
            settleService.unAutoSettle(needArTransferUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needArAdjustUnSettleBills.size() > 0) {
            settleService = new ArAdjustAutoSettleService();
            settleService.unAutoSettle(needArAdjustUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needArRecUnSettleBills.size() > 0) {
            DynamicObject[] needSaveZeroBills;
            settleService = new ArReceiveAutoSettleService();
            settleService.unAutoSettle(needArRecUnSettleBills.toArray(new DynamicObject[0]));
            ArrayList<DynamicObject> zeroArBills = new ArrayList<DynamicObject>(1);
            for (DynamicObject arBill : needArRecUnSettleBills) {
                if (!APSettleStatusEnum.SETTLED.getValue().equals(arBill.getString("settlestatus")) || BigDecimal.ZERO.compareTo(arBill.getBigDecimal("recamount")) != 0) continue;
                zeroArBills.add(arBill);
            }
            List zeroArBillIds = zeroArBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
            for (DynamicObject zeroBill : needSaveZeroBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"settlestatus,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,unplansettlelocamt,plansettledamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", zeroArBillIds)})) {
                zeroBill.set("settlestatus", (Object)ARSettleStatusEnum.UNSETTLE.getValue());
                DynamicObjectCollection planEntries = zeroBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planEntry : planEntries) {
                    BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                    BigDecimal planPricetaxLoc = planEntry.getBigDecimal("planpricetaxloc");
                    planEntry.set("unplanlockamt", (Object)planPricetax);
                    planEntry.set("planlockedamt", (Object)BigDecimal.ZERO);
                    planEntry.set("unplansettleamt", (Object)planPricetax);
                    planEntry.set("plansettledamt", (Object)BigDecimal.ZERO);
                    planEntry.set("unplansettlelocamt", (Object)planPricetaxLoc);
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                }
            }
            SaveServiceHelper.save((DynamicObject[])needSaveZeroBills);
        }
    }

    private void executeUnWoff(DynamicObject[] entities) {
        List errList = null;
        Boolean woffServiceV2 = BusWoffHelper.woffServiceV2();
        logger.info("audit.woff.woffServiceV2:" + woffServiceV2);
        if (woffServiceV2.booleanValue()) {
            ArWoffService woffService = new ArWoffService();
            Set set = woffService.initUnWoffDetailInfo(entities);
            if (!ObjectUtils.isEmpty((Object)set)) {
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_busbill", (String)"woff", (Set)set);
            }
            errList = woffService.delWoffBill(entities, set);
        } else {
            HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(2);
            for (DynamicObject entity : entities) {
                billMap.put(entity.getLong("id"), entity);
            }
            BusPrepaidWoffFromFinAr busPrepaidWoffFromFinAr = new BusPrepaidWoffFromFinAr();
            BusWoffResult result = busPrepaidWoffFromFinAr.busUnWoffBills(billMap.keySet());
            for (Object doneBillId : result.getFinBillIds()) {
                billMap.remove(doneBillId);
            }
            BusBotpWoffFromFinar busBotpWoff = new BusBotpWoffFromFinar();
            result = busBotpWoff.busUnWoffBills(billMap.keySet());
            for (Iterator doneBillId : result.getFinBillIds()) {
                billMap.remove(doneBillId);
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusSameSourceWoffFromFinar busSameSourceWoff = new BusSameSourceWoffFromFinar();
                result = busSameSourceWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusGroupWoffFromFinar busGroupWoff = new BusGroupWoffFromFinar();
                result = busGroupWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusCoreBillWoffFromFinar busCoreBillWoff = new BusCoreBillWoffFromFinar();
                result = busCoreBillWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                ArWoffService woffService = new ArWoffService();
                DynamicObject[] historyEntities = billMap.values().toArray(new DynamicObject[0]);
                Set srcBusIds = woffService.initUnWoffDetailInfo(historyEntities);
                if (!ObjectUtils.isEmpty((Object)srcBusIds)) {
                    ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_busbill", (String)"woff", (Set)srcBusIds);
                }
                errList = woffService.delWoffBill(historyEntities, srcBusIds);
            }
        }
        if (errList != null) {
            ArrayList<Object> successPkIds = new ArrayList<Object>();
            for (DynamicObject info : entities) {
                boolean error = false;
                Object pk = info.getPkValue();
                for (ErrorInfo err : errList) {
                    if (!pk.equals(err.getPk())) continue;
                    OperateErrorInfo errorinfo = new OperateErrorInfo();
                    errorinfo.setPkValue(err.getPk());
                    errorinfo.setMessage(err.getMsg());
                    errorinfo.setErrorLevel(ErrorLevel.Error.name());
                    this.operationResult.addErrorInfo(errorinfo);
                    error = true;
                    break;
                }
                if (error) continue;
                successPkIds.add(pk);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setSuccessPkIds(successPkIds);
        }
    }

    private void executeBaddebt(DynamicObject[] entities) {
        ArrayList<Object> pks = new ArrayList<Object>(entities.length);
        for (DynamicObject entity : entities) {
            if (!EmptyUtils.isNotEmpty((Object)entity.getPkValue())) continue;
            pks.add(entity.getPkValue());
        }
        if (!pks.isEmpty()) {
            this.delBadDebtReserveBill(pks);
        }
    }

    private void delArRevWrittenOffVerifyRecords(DynamicObject[] finArBills) {
        HashSet<Long> srcFinBillIds = new HashSet<Long>(finArBills.length);
        for (DynamicObject finArBill : finArBills) {
            if (!finArBill.getBoolean("iswrittenoff")) continue;
            srcFinBillIds.add(Long.parseLong(finArBill.getString("sourcebillid")));
        }
        ArRevWrittenOffVerifyService arRevWrittenOffVerifyService = new ArRevWrittenOffVerifyService();
        arRevWrittenOffVerifyService.writtenOffUnVerify(srcFinBillIds);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("org");
        props.add("sourcebilltype");
        props.add("billtype");
        props.add("istransfer");
        props.add("recamount");
        props.add("asstacttype");
        props.add("asstact");
        props.add("currency");
        props.add("iswrittenoff");
        props.add("hadwrittenoff");
        props.add("sourcebillid");
        props.add("settlestatus");
        props.add("verifystatus");
        props.add("entry.e_srcid");
        props.add("entry.e_srcentryid");
        props.add("entry.e_recamount");
        props.add("entry.e_quantity");
        props.add("entry.e_isallverify");
        props.add("entry.corebillid");
        props.add("entry.corebillentryid");
        props.add("entry.e_corebilltype");
        props.add("entry.e_corebillno");
        props.add("entry.e_corebillentryseq");
        props.add("entry.groupnumber");
        props.add("entry.groupseq");
        props.add("entry.e_reclocalamt");
        props.add("paymode");
        props.add("payproperty");
        props.add("payproperty.isbasedonamt");
        props.add("bookdate");
        props.add("bizdate");
        props.add("writebackbill");
        props.add("ispremium");
        props.add("isperiod");
        props.add("e_conbillentity");
        props.add("e_conbillid");
        props.add("e_conbillentryid");
        props.add("e_baseunitqty");
        props.add("unverifyamount");
        props.add("amount");
        props.add("e_amount");
        props.add("e_verifiedqty");
        props.add("e_unverifyqty");
        props.add("e_verifiedamt");
        props.add("e_unverifyamt");
        props.add("billsrctype");
        props.add("entry.linetype");
        props.add("entry.e_expenseitem");
        props.addAll(FinArBillHandleHelper.getSelector());
        fieldKeys.addAll(props);
    }

    private void writeBackToScm(List<Map<String, Object>> paramList, boolean audit) {
        List salContractParamList;
        List salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
        if (salOrderParamList.size() > 0) {
            Settle4ScmcHelper.disposeArToSalOrder(salOrderParamList, (boolean)audit);
            Settle4ScmcHelper.disposeSaleCont(salOrderParamList, (boolean)audit);
        }
        if ((salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList())).size() > 0) {
            Settle4ScmcHelper.disposeSaleCont(salContractParamList, (boolean)audit);
        }
    }

    private void validBill(DynamicObject[] dataEntities) {
        Object[] pkIds = Arrays.stream(dataEntities).filter(entity -> entity.getBoolean("iswrittenoff")).filter(entity -> !entity.getBoolean("writebackbill")).map(entity -> Long.valueOf(entity.getString("sourcebillid"))).toArray();
        if (EmptyUtils.isEmpty((Object)pkIds)) {
            return;
        }
        ValidOperationServiceHelper.valid((String)"ar_finarbill", (Object[])pkIds);
    }

    private void deletePremiumBill(DynamicObject[] entites) {
        Set pks = Arrays.stream(entites).map(entity -> entity.getString("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("sourcebilltype", "=", (Object)"ar_finarbill");
        qf.and(new QFilter("sourcebillid", "in", pks));
        qf.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection finarColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)finarColl)) {
            List finarPks = ArApHelper.getPks((Object)finarColl);
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"noprotocoldelete", (String)"ar_finarbill", (Object[])finarPks.toArray(), (OperateOption)option);
        }
    }

    private void unAuditDeleteAutoRecBill(DynamicObject[] entities) {
        Map<Long, List<DynamicObject>> cashBillMap = Stream.of(entities).filter(finBill -> "CASH".equals(finBill.getString("paymode"))).collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
        ArrayList cashFinBills = new ArrayList(entities.length);
        for (Map.Entry<Long, List<DynamicObject>> entry : cashBillMap.entrySet()) {
            Long orgId = entry.getKey();
            if (!SystemParameterHelper.getARBooleanParam((long)orgId, (String)"ar_011")) continue;
            cashFinBills.addAll(cashBillMap.get(orgId));
        }
        Long[] cashFinBillIds = (Long[])cashFinBills.stream().map(bill -> bill.getLong("id")).toArray(Long[]::new);
        Map targetBills = BOTPHelper.findTargetBills((String)"ar_finarbill", (Long[])cashFinBillIds);
        HashSet recBillIds = (HashSet)targetBills.get("cas_recbill");
        if (EmptyUtils.isEmpty((Object)recBillIds)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)recBillIds);
        DynamicObjectCollection autoPushPayBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billstatus", (QFilter[])new QFilter[]{idFilter});
        Object[] autoPushRecBillIds = (Long[])autoPushPayBills.stream().filter(payBill -> "A".equals(payBill.getString("billstatus"))).map(payBill -> payBill.getLong("id")).toArray(Long[]::new);
        if (EmptyUtils.isNotEmpty((Object)autoPushRecBillIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationResult operate = OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])autoPushRecBillIds, (OperateOption)option);
            OperationHelper.assertResult((OperationResult)operate);
        }
    }

    public List<ErrorInfo> delWoffAndRevBillHandle(DynamicObject[] entities) {
        long start = System.currentTimeMillis();
        FinWoffService woffService = FinBillFactory.getWoffService((boolean)true);
        List errList = woffService.delWoffBill(entities);
        logger.info("---unaudit.delWoffBill---" + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        RevCfmBillSerivceHelper.getInstance().delRevCfmBill(entities);
        logger.info("---unaudit.delRevCfmBill---" + (System.currentTimeMillis() - start) + "ms");
        return errList;
    }

    private void delBadDebtReserveBill(List<Object> pks) {
    }

    private void delCoordintionBill(DynamicObject[] entities) {
        ArrayList<Object> pks = new ArrayList<Object>(entities.length);
        for (DynamicObject entity : entities) {
            if (!EmptyUtils.isNotEmpty((Object)entity.getPkValue())) continue;
            pks.add(entity.getPkValue());
        }
        if (!pks.isEmpty()) {
            ThreadPools.executeOnceIncludeRequestContext((String)"delete.coordintion", () -> {
                QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"ar_finarbill");
                qFilter.and(new QFilter("sourcebillid", "in", (Object)pks));
                DynamicObjectCollection finapColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!ObjectUtils.isEmpty((Object)finapColl)) {
                    List finapPks = ArApHelper.getPks((Object)finapColl);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isStrict", "false");
                    OperationServiceHelper.executeOperate((String)"noprotocoldelete", (String)"ap_finapbill", (Object[])finapPks.toArray(), (OperateOption)option);
                }
            });
        }
    }

    private void writeOff(long mainBillID, long asstBillID) {
        DynamicObject[] sourceDys;
        AbstractSettleTemplate service = SettleServiceFactory.getService((String)"arwriteoff");
        DynamicObject[] records = this.getSettleRecord(mainBillID);
        if (records != null && records.length > 0) {
            service.unSettle(records, false);
        }
        DynamicObject hadWrittenOffBill = BusinessDataServiceHelper.loadSingle((String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainBillID)});
        hadWrittenOffBill.set("hadwrittenoff", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hadWrittenOffBill});
        QFilter filter = new QFilter("mainbillid", "=", (Object)mainBillID);
        filter.and(new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("settlerelation", "=", (Object)"artranswar"));
        records = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{filter});
        if (records != null && records.length > 0) {
            SettleServiceFactory.getService((String)"artranswar").unSettle(records, true);
        }
        QFilter sourFilter = new QFilter("mainbillid", "=", (Object)mainBillID);
        sourFilter.and(new QFilter("settlerelation", "=", (Object)"artranswar"));
        for (DynamicObject sourceDy : sourceDys = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{sourFilter})) {
            sourceDy.set("hadwrittenoff", (Object)0);
            DynamicObjectCollection col = sourceDy.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : col) {
                dynamicObject.set("e_hadwrittenoff", (Object)0);
            }
        }
        if (sourceDys.length > 0) {
            SaveServiceHelper.save((DynamicObject[])sourceDys);
        }
    }

    private void writeOffBillsDelete(DynamicObject[] entities) {
        List<Long> writeOffBillIds = Stream.of(entities).filter(entity -> entity.getBoolean("iswrittenoff")).map(e -> e.getLong("id")).collect(Collectors.toList());
        if (writeOffBillIds.size() == 0) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"nocheckdelete", (String)"ar_finarbill", (Object[])writeOffBillIds.toArray(new Long[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)result);
        Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"ar_finarbill", (String)"nocheckdelete", writeOffBillIds, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
        logger.info("Voucher Delete White List result: " + isSuccess);
    }

    private DynamicObject[] getSettleRecord(long mainBillID) {
        QFilter filter = new QFilter("mainbillid", "=", (Object)mainBillID);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        return BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{filter});
    }
}

