/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.business.baddebt.impl.InitAsstactAdvancesAmtDetail;
import kd.fi.ar.business.baddebt.impl.InitAsstactBaddebtAmtDetail;
import kd.fi.ar.business.baddebt.impl.InitAsstactRecAmtDetail;
import kd.fi.ar.business.baddebt.info.InitAmtPair;
import kd.fi.ar.business.service.factory.InitFactory;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.init.InitReconcileService;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.IOpService;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.validator.InitBillValidator;
import kd.fi.arapcommon.validator.ReconcileBaseValidator;

public class InitCloseOp
extends AbstractOperationServicePlugIn {
    private IOpService iService = InitFactory.getCloseService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(this.iService.getSelector());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.buildEntry(info);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InitBillValidator());
        e.addValidator((AbstractValidator)new ReconcileBaseValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] inits = e.getDataEntities();
        InitReconcileService recService = new InitReconcileService(true);
        recService.rebuild(inits);
        Map<Long, DynamicObject> initMap = Stream.of(inits).collect(Collectors.toMap(i -> i.getLong("id"), i -> i));
        List orgIds = Stream.of(inits).map(i -> i.getLong("org.id")).collect(Collectors.toList());
        Map orgMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, orgIds, (String)"ar_008");
        List orgPks = orgMap.entrySet().stream().filter(es -> this.isReconcile(es.getValue())).map(es -> (Long)es.getKey()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(orgPks)) {
            List<DynamicObject> infos = Stream.of(inits).filter(i -> orgPks.contains(i.getLong("org.id"))).collect(Collectors.toList());
            OperationResult afResult = OperationServiceHelper.executeOperate((String)"aftersubmit", (String)this.billEntityType.getName(), (DynamicObject[])infos.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!afResult.isSuccess()) {
                List recOpErrors = afResult.getAllErrorOrValidateInfo();
                for (IOperateInfo errorInfo : recOpErrors) {
                    initMap.remove(errorInfo.getPkValue());
                    this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                }
                this.operationResult.setSuccess(false);
            } else {
                int size = this.operationResult.getBillCount();
                if (size == afResult.getSuccessPkIds().size()) {
                    String message = "";
                    if (size == 1) {
                        DynamicObject org = inits[0].getDynamicObject("org");
                        message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a", (String)"InitCloseOp_0", (String)"fi-ar-opplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                    }
                    message = String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\uff0c\u4e0e\u603b\u8d26\u5bf9\u8d26\u5e73\u8861\u3002", (String)"InitCloseOp_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), message);
                    this.operationResult.setMessage(message);
                }
            }
        }
        e.setDataEntities(initMap.values().toArray(new DynamicObject[0]));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        AdjExchService adjExchService = new AdjExchService("ar");
        List orgIds = adjExchService.getOrgIds(e.getDataEntities());
        Map orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        for (DynamicObject info : e.getDataEntities()) {
            this.iService.process(info);
            Long orgId = (Long)info.getDynamicObject("org").getPkValue();
            if (orgAndParamMap.get(orgId) != null && ((Boolean)orgAndParamMap.get(orgId)).booleanValue()) {
                adjExchService.insertAdjExchRecord(info, Boolean.TRUE);
            }
            Long exrateTableId = info.getDynamicObject("exratetable").getLong("id");
            DynamicObject curPeriod = info.getDynamicObject("curperiod");
            BadDebtAccrualHelper.insertNextPeriodBadDebtAccrue((Long)orgId, (Long)curPeriod.getLong("id"), (Long)0L, (Long)0L, (Boolean)Boolean.FALSE, (String)curPeriod.getString("name"), (Long)exrateTableId);
        }
    }

    private void buildEntry(DynamicObject info) {
        long orgPk = (Long)info.getDynamicObject("org").getPkValue();
        InitAsstactRecAmtDetail recAmtDetail = new InitAsstactRecAmtDetail("ar_finarbill", orgPk);
        InitAsstactRecAmtDetail bizAmtDetail = new InitAsstactRecAmtDetail("ar_busbill", orgPk);
        InitAsstactAdvancesAmtDetail advancesAmtDetail = new InitAsstactAdvancesAmtDetail(orgPk);
        InitAsstactBaddebtAmtDetail baddebtAmtDetail = new InitAsstactBaddebtAmtDetail(orgPk);
        List entries = BaddebtHelper.merge((List)recAmtDetail.getAsstDetail(), (List)advancesAmtDetail.getAsstDetail(), (List)baddebtAmtDetail.getAsstDetail(), (List)bizAmtDetail.getAsstDetail());
        if (!entries.isEmpty()) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (InitEntryInfo entryInfo : entries) {
                DynamicObject entry = new DynamicObject(entrys.getDynamicObjectType());
                MergeKey mergeKey = entryInfo.getMergeKey();
                entry.set("e_asstacttype", (Object)mergeKey.getAsstActType());
                entry.set("e_asstact", (Object)mergeKey.getAsst());
                entry.set("e_currency", (Object)mergeKey.getCurrency());
                InitAmtPair pair = (InitAmtPair)entryInfo.getAmtPair();
                entry.set("e_finrecamt", (Object)pair.getRecAmt());
                entry.set("e_recamt", (Object)pair.getAdvancesAmt());
                entry.set("businessamount", (Object)pair.getBizAmt());
                BigDecimal recAmt = ObjectUtils.isEmpty((Object)pair.getRecAmt()) ? BigDecimal.ZERO : pair.getRecAmt();
                BigDecimal bizAmt = ObjectUtils.isEmpty((Object)pair.getBizAmt()) ? BigDecimal.ZERO : pair.getBizAmt();
                BigDecimal advancesAmt = ObjectUtils.isEmpty((Object)pair.getAdvancesAmt()) ? BigDecimal.ZERO : pair.getAdvancesAmt();
                entry.set("e_balanceamt", (Object)recAmt.add(bizAmt).subtract(advancesAmt));
                entry.set("e_baddebtamt", (Object)pair.getBaddebtAmt());
                entrys.add((Object)entry);
            }
        }
    }

    private boolean isReconcile(Object param) {
        boolean ar008 = param == null ? false : (Boolean)param;
        return ar008;
    }
}

