/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.ArLiquWBFinBillServiceHelper;

public class LiquidationInvalidOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entryentity.sourcebillid");
        fieldKeys.add("entryentity.unsettleamt");
        fieldKeys.add("entryentity.amount");
        fieldKeys.add("entryentity.unsettleamt");
        fieldKeys.add("entryentity.sourceentryid");
        fieldKeys.add("createtime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Set<Long> sourceIds = this.getSourceIds(dataEntities);
        String sourceBillType = dataEntities[0].getString("sourcebilltype");
        if ("ar_finarbill".equals(sourceBillType)) {
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(sourceIds, (String)"ar_finarbill", (boolean)false);
        }
        if ("ar_finarbill".equals(sourceBillType)) {
            ArLiquWBFinBillServiceHelper.inverseWriteBack((DynamicObject[])dataEntities);
        }
    }

    private Set<Long> getSourceIds(DynamicObject[] entities) {
        HashSet<Long> ids = new HashSet<Long>(64);
        for (DynamicObject entity : entities) {
            DynamicObjectCollection entryCol = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryCol) {
                Long sourId = dynamicObject.getLong("sourcebillid");
                ids.add(sourId);
            }
        }
        return ids;
    }
}

