/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.mservice.LiquidationAutoSettleService;
import kd.fi.ar.mservice.RecClearingAutoSettleService;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.validator.LiquidationAuditValidator;

public class LiquidationSettleOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new LiquidationAuditValidator(Boolean.TRUE));
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        Set<Long> sourceIds = this.getSourceIds(entities);
        if (sourceIds.size() > 0) {
            Map<String, List<DynamicObject>> groupMap = this.groupBySourceType(entities);
            LiquidationAutoSettleService arapSettle = new LiquidationAutoSettleService();
            RecClearingAutoSettleService recSettle = new RecClearingAutoSettleService();
            for (Map.Entry<String, List<DynamicObject>> value : groupMap.entrySet()) {
                String key = value.getKey();
                List<DynamicObject> groupBillList = value.getValue();
                if ("cas_recbill".equals(key) || "ar_receivedbill".equals(key)) {
                    recSettle.batchAutoSettle(groupBillList.toArray(new DynamicObject[0]), false);
                    continue;
                }
                arapSettle.batchAutoSettle(groupBillList.toArray(new DynamicObject[0]), false);
            }
            for (DynamicObject bill : e.getDataEntities()) {
                bill.set("issettled", (Object)Boolean.TRUE);
            }
        }
    }

    private Set<Long> getSourceIds(DynamicObject[] entities) {
        HashSet<Long> ids = new HashSet<Long>(64);
        for (DynamicObject entity : entities) {
            DynamicObjectCollection entryCol = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryCol) {
                Long sourId = dynamicObject.getLong("sourcebillid");
                ids.add(sourId);
            }
        }
        return ids;
    }

    private Map<String, List<DynamicObject>> groupBySourceType(DynamicObject[] entities) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(8);
        for (DynamicObject bill : entities) {
            ArrayList<DynamicObject> billList;
            String sourceBillType = bill.getString("sourcebilltype");
            if (map.get(sourceBillType) == null) {
                billList = new ArrayList<DynamicObject>(entities.length);
                billList.add(bill);
                map.put(sourceBillType, billList);
                continue;
            }
            billList = (ArrayList<DynamicObject>)map.get(sourceBillType);
            billList.add(bill);
            map.put(sourceBillType, billList);
        }
        return map;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(20);
        selectors.add("liquidationdate");
        selectors.add("org");
        selectors.add("currency");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("issettled");
        selectors.add("quotation");
        selectors.add("exchangerate");
        selectors.add("sourcebillno");
        selectors.add("sourcebilldate");
        selectors.add("itemtype");
        selectors.add("item");
        selectors.add("amount");
        selectors.add("unsettleamt");
        selectors.add("sourcebillid");
        selectors.add("sourceentryid");
        selectors.add("e_payproperty");
        selectors.add("basecurrency");
        selectors.add("entryentity");
        selectors.add("billno");
        selectors.add("sourcebilltype");
        selectors.add("entryentity.seq");
        selectors.add("billstatus");
        List keys = SettleExtDataLoader.loadSettleRecordExtListKeys((String)"ar_liquidation");
        keys.forEach(v -> selectors.add(v.getBillKey()));
        return selectors;
    }
}

