/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.validator.VerifyLiquidationValidator;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.ArLiquWBFinBillServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.validator.AllEntriesIsDrawValidator;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public class LiquidationSubmitOp
extends ArapBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
        e.addValidator((AbstractValidator)new AllEntriesIsDrawValidator());
        e.addValidator((AbstractValidator)new VerifyLiquidationValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        this.setDefaultLiqDate(datas);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<String, Set<Long>> srcTypeToSrcBillIdsMap = this.getsrcTypeToSrcBillIdsMap(dataEntities);
        for (Map.Entry<String, Set<Long>> entry : srcTypeToSrcBillIdsMap.entrySet()) {
            DynamicObject[] sourceBillType = entry.getKey();
            Set<Long> sourceIds = entry.getValue();
            if (!"ar_finarbill".equals(sourceBillType) && !"cas_recbill".equals(sourceBillType) && !"ar_receivedbill".equals(sourceBillType)) continue;
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(sourceIds, (String)sourceBillType, (boolean)false);
        }
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<DynamicObject> srcTypeIsFinArEntities = new ArrayList<DynamicObject>(entities.length);
        for (DynamicObject entity : entities) {
            String sourceBillType = entity.getString("sourcebilltype");
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            srcTypeIsFinArEntities.add(entity);
        }
        if (srcTypeIsFinArEntities.size() > 0) {
            Map sourceMap;
            ArLiquWBFinBillServiceHelper.directWriteBack((DynamicObject[])srcTypeIsFinArEntities.toArray(new DynamicObject[0]));
            Map variables = this.getOption().getVariables();
            String isAuto = (String)variables.get("isauto");
            if ("true".equals(isAuto)) {
                return;
            }
            Set<Long> sourceIds = this.getSourceIds(srcTypeIsFinArEntities);
            HashSet needPushLiquFinApIds = new HashSet(8);
            Map targetMap = BFTrackerServiceHelper.findTargetBills((String)"ar_finarbill", (Long[])sourceIds.toArray(new Long[0]));
            if (targetMap.get("ap_finapbill") != null) {
                needPushLiquFinApIds.addAll((Collection)targetMap.get("ap_finapbill"));
            }
            if ((sourceMap = BFTrackerServiceHelper.findSourceBills((String)"ar_finarbill", (Long[])sourceIds.toArray(new Long[0]))).get("ap_finapbill") != null) {
                needPushLiquFinApIds.addAll((Collection)sourceMap.get("ap_finapbill"));
            }
            if (needPushLiquFinApIds.size() > 0) {
                DynamicObjectCollection nonAuditBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billstatus,relationpay", (QFilter[])new QFilter[]{new QFilter("id", "in", needPushLiquFinApIds)});
                for (DynamicObject nonAuditBill : nonAuditBills) {
                    String billStatus = nonAuditBill.getString("billstatus");
                    boolean isrelationpay = nonAuditBill.getBoolean("relationpay");
                    if (isrelationpay && "C".equals(billStatus)) continue;
                    needPushLiquFinApIds.remove(nonAuditBill.getLong("id"));
                }
                if (ObjectUtils.isEmpty(needPushLiquFinApIds)) {
                    return;
                }
                OperateOption op = OperateOption.create();
                op.setVariableValue("isauto", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"pushandsaveliqu", (String)"ap_finapbill", (Object[])needPushLiquFinApIds.toArray(), (OperateOption)op);
                OperationHelper.assertResult((OperationResult)result);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("unsettleamt");
        fieldKeys.add("entryentity.amount");
        fieldKeys.add("entryentity.unsettleamt");
        fieldKeys.add("entryentity.sourceentryid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("asstacttype");
        fieldKeys.add("asstact");
        fieldKeys.add("exratetable");
        fieldKeys.add("exchangerate");
        fieldKeys.add("createtime");
        fieldKeys.add("liquidationdate");
        fieldKeys.add("org");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entryentity.seq");
    }

    private Set<Long> getSourceIds(List<DynamicObject> entities) {
        HashSet<Long> ids = new HashSet<Long>(64);
        for (DynamicObject entity : entities) {
            DynamicObjectCollection entryCol = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryCol) {
                Long sourId = dynamicObject.getLong("sourcebillid");
                ids.add(sourId);
            }
        }
        return ids;
    }

    private Map<String, Set<Long>> getsrcTypeToSrcBillIdsMap(DynamicObject[] entities) {
        HashMap<String, Set<Long>> srcTypeToSrcBillIdsMap = new HashMap<String, Set<Long>>(64);
        for (DynamicObject entity : entities) {
            String sourceBillType = entity.getString("sourcebilltype");
            DynamicObjectCollection entryCol = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryCol) {
                HashSet<Long> ids = (HashSet<Long>)srcTypeToSrcBillIdsMap.get(sourceBillType);
                Long sourId = dynamicObject.getLong("sourcebillid");
                if (ObjectUtils.isEmpty((Object)ids)) {
                    ids = new HashSet<Long>(64);
                    ids.add(sourId);
                } else {
                    ids.add(sourId);
                }
                srcTypeToSrcBillIdsMap.put(sourceBillType, ids);
            }
        }
        return srcTypeToSrcBillIdsMap;
    }

    private void setDefaultLiqDate(DynamicObject[] datas) {
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (DynamicObject data : datas) {
            DynamicObject org = data.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            orgIds.add(org.getLong("id"));
        }
        DynamicObjectCollection ap_closeaccount = QueryServiceHelper.query((String)"ar_closeaccount", (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds)});
        HashMap<Long, Date> orgDateMap = new HashMap<Long, Date>(2);
        for (DynamicObject dynamicObject : ap_closeaccount) {
            Long orgId = dynamicObject.getLong("org");
            Date date = dynamicObject.getDate("currentdate");
            orgDateMap.put(orgId, date);
        }
        for (DynamicObject data : datas) {
            String liqDate = data.getString("liquidationdate");
            if (!StringUtils.isEmpty((CharSequence)liqDate)) continue;
            Date nowDate = new Date();
            DynamicObject org = data.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            Long orgId = org.getLong("id");
            Date currentDate = (Date)orgDateMap.get(orgId);
            Date tempDate = currentDate != null && DateUtils.compareTo((Date)currentDate, (Date)nowDate) == 1 ? currentDate : nowDate;
            data.set("liquidationdate", (Object)tempDate);
        }
    }
}

