/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.mservice.LiquidationAutoSettleService;
import kd.fi.ar.mservice.RecClearingAutoSettleService;
import kd.fi.ar.validator.LiquidationUnSettleValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class LiquidationUnSettleOp
extends ArapBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new LiquidationUnSettleValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        RecClearingAutoSettleService unSettleService;
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<DynamicObject> needExecuteUnSettleRecBills = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> needExecuteUnSettleArBills = new ArrayList<DynamicObject>(entities.length);
        for (DynamicObject entity : entities) {
            String sourcebilltype = entity.getString("sourcebilltype");
            if ("cas_recbill".equals(sourcebilltype) || "ar_receivedbill".equals(sourcebilltype)) {
                needExecuteUnSettleRecBills.add(entity);
            } else {
                needExecuteUnSettleArBills.add(entity);
            }
            entity.set("issettled", (Object)Boolean.FALSE);
        }
        if (needExecuteUnSettleRecBills.size() > 0) {
            unSettleService = new RecClearingAutoSettleService();
            unSettleService.unAutoSettle(needExecuteUnSettleRecBills.toArray(new DynamicObject[0]));
        }
        if (needExecuteUnSettleArBills.size() > 0) {
            unSettleService = new LiquidationAutoSettleService();
            unSettleService.unAutoSettle(needExecuteUnSettleArBills.toArray(new DynamicObject[0]));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("issettled");
        selectors.add("sourcebilltype");
        selectors.add("billsrctype");
        return selectors;
    }
}

