/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.validator.RevCfmBillImportValidator;
import kd.fi.ar.validator.RevcfmBillWriteOffValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.service.RevCfmChargeAgainstService;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.SupplierandMaterial4VmiValidator;

public class RevCfmBillSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(RevCfmBillSaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"amount", "localamt", "confirmamt", "confirmlocamt", "unverifyamt", "tax", "taxlocamt", "pricetaxtotal", "pricetaxtotalbase"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selectors = e.getFieldKeys();
        selectors.add("sourcebilltype");
        selectors.add("e_unitprice");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("biztype");
        selectors.add("amount");
        selectors.add("localamt");
        selectors.add("confirmamt");
        selectors.add("confirmlocamt");
        selectors.add("org");
        selectors.add("basecurrency");
        selectors.add("exchangerate");
        selectors.add("e_material");
        selectors.add("paymentcustomerid");
        selectors.add("unverifyamt");
        selectors.add("tax");
        selectors.add("taxlocamt");
        selectors.add("pricetaxtotal");
        selectors.add("pricetaxtotalbase");
        selectors.add("iswrittenoff");
        selectors.add("sourcebillid");
        selectors.add("entry.e_quantity");
        selectors.add("entry.e_baseunitqty");
        selectors.add("entry.e_confirmqty");
        selectors.add("entry.e_confirmbaseqty");
        selectors.add("entry.e_amount");
        selectors.add("entry.e_localamt");
        selectors.add("entry.e_confirmamt");
        selectors.add("entry.e_verifiedqty");
        selectors.add("entry.e_unverifyqty");
        selectors.add("entry.e_verifybaseqty");
        selectors.add("entry.e_unverifybaseqty");
        selectors.add("entry.e_verifiedamt");
        selectors.add("entry.e_unverifyamt");
        selectors.add("entry.e_delivercustomerid");
        selectors.add("entry.e_invoicecustomerid");
        selectors.add("entry.e_unrecqty");
        selectors.add("entry.e_unrecbaseqty");
        selectors.add("entry.e_recqty");
        selectors.add("entry.e_recbaseqty");
        selectors.add("entry.e_unrecamt");
        selectors.add("entry.e_recamt");
        selectors.add("billsrctype");
        selectors.add("entry.e_ispresent");
        selectors.add("bizDate");
        selectors.add("bookdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        String isExcelImport = (String)paramMap.get("importtag_of_datasource");
        String isApiImport = (String)paramMap.get("webapitag_of_datasource");
        if ("true".equals(isExcelImport) || "true".equals(isApiImport)) {
            e.addValidator((AbstractValidator)new RevCfmBillImportValidator());
        }
        e.addValidator((AbstractValidator)new SupplierandMaterial4VmiValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new RevcfmBillWriteOffValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("RevCfmBillSaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(dataEntities);
        logger.info("RevCfmBillSaveOp.beginOperationTransaction appendHeadAmt end");
        ArApDataRepairHelper.repairRevCfmBillAmtField((DynamicObject[])e.getDataEntities());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] entities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject data : entities = e.getDataEntities()) {
            if (!StringUtils.isEmpty((String)data.getString("billsrctype")) || !StringUtils.isNotEmpty((String)data.getString("sourcebilltype"))) continue;
            data.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
        }
        BookDateHelper.billSavesetBookDate((DynamicObject[])entities, (boolean)true);
        List customerBills = Arrays.stream(entities).filter(s -> "1".equals(s.getString("billsrctype")) && "bd_customer".equals(s.getString("asstacttype"))).collect(Collectors.toList());
        if (customerBills != null && customerBills.size() > 0) {
            FinArBillHelper.setImptCustomers(customerBills);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.invalidBill(e.getDataEntities());
    }

    private void writetenOffBillSubmitAndAudit(DynamicObject[] dataEntities) {
        ArrayList<Long> manualConfirmIds = new ArrayList<Long>(16);
        ArrayList<DynamicObject> writtenBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill : dataEntities) {
            if (!bill.getBoolean("iswrittenoff")) continue;
            manualConfirmIds.add(bill.getLong("id"));
            writtenBills.add(bill);
        }
        if (manualConfirmIds.size() == 0) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])manualConfirmIds.toArray(), (OperateOption)option);
        OperationHelper.assertResult((String)"ar_revcfmbill", (OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])manualConfirmIds.toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)auditResult);
        RevCfmChargeAgainstService againstService = new RevCfmChargeAgainstService();
        againstService.executeSourceBillDispose(writtenBills);
    }

    private void invalidBill(DynamicObject[] dataEntities) {
        Object[] pkIds = Arrays.stream(dataEntities).filter(entity -> entity.getBoolean("iswrittenoff")).map(entity -> Long.valueOf(entity.getString("sourcebillid"))).toArray();
        if (EmptyUtils.isEmpty((Object)pkIds)) {
            return;
        }
        ValidOperationServiceHelper.invalid((String)"ar_revcfmbill", (Object[])pkIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.writetenOffBillSubmitAndAudit(e.getDataEntities());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }
}

