/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.validator.RevCfmBillSubmitAmountValidator;
import kd.fi.ar.validator.RevCfmBillSubmitValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.MtoValidator;

public class RevCfmBillSubmitOp
extends ArapBaseOp {
    private static final int rowCountOneBatch = 2000;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selectors = e.getFieldKeys();
        selectors.add("e_unitprice");
        selectors.add("e_ispresent");
        selectors.add("payproperty");
        selectors.add("linetype");
        selectors.add("bookdate");
        selectors.add("entry.seq");
        selectors.add("sourcebillid");
        selectors.add("sourcebilltype");
        selectors.add("e_material");
        selectors.add("configuredcode");
        selectors.add("tracknumber");
        if (SystemParameterHelper.isForceValidateAmt()) {
            selectors.addAll(RevCfmBillSubmitAmountValidator.getRequiredFields());
        }
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        selectors.add("e_baseunitid");
        selectors.add("exchangerate");
        selectors.add("amount");
        selectors.add("localamt");
        selectors.add("org");
        selectors.add("confirmamt");
        selectors.add("confirmlocamt");
        selectors.add("e_corebilltype");
        selectors.add("e_corebillno");
        selectors.add("e_corebillentryseq");
        selectors.add("e_corebillid");
        selectors.add("e_corebillentryid");
        selectors.add("e_unitcoefficient");
        selectors.add("e_baseunitqty");
        selectors.add("e_quantity");
        selectors.add("e_measureunit");
        selectors.add("e_material");
        selectors.add("unverifyamt");
        selectors.add("basecurrency");
        selectors.add("entry.e_amount");
        selectors.add("entry.e_localamt");
        selectors.add("entry.e_confirmamt");
        selectors.add("entry.e_confirmqty");
        selectors.add("entry.e_confirmbaseqty");
        selectors.add("entry.e_verifiedqty");
        selectors.add("entry.e_unverifyqty");
        selectors.add("entry.e_verifybaseqty");
        selectors.add("entry.e_unverifybaseqty");
        selectors.add("entry.e_verifiedamt");
        selectors.add("entry.e_unverifyamt");
        selectors.add("currency");
        selectors.add("payproperty");
        selectors.add("exratetable");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("confirmway");
        selectors.add("confirmrate");
        selectors.add("entry.e_unrecqty");
        selectors.add("entry.e_unrecbaseqty");
        selectors.add("entry.e_recqty");
        selectors.add("entry.e_recbaseqty");
        selectors.add("entry.e_unrecamt");
        selectors.add("entry.e_recamt");
        selectors.add("entry.e_tax");
        selectors.add("entry.e_discountamount");
        selectors.add("entry.e_pricetaxtotal");
        selectors.add("confirmrate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillPriceValidator());
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new RevCfmBillSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new MtoValidator());
        e.addValidator((AbstractValidator)new RevCfmBillSubmitValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        BookDateHelper.setBookDate((DynamicObject[])entities, (boolean)true);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArApDataRepairHelper.repairRevCfmBillAmtField((DynamicObject[])e.getDataEntities());
        ArApHelper.baseUnitQtyCorrection((DynamicObject[])e.getDataEntities(), (String)"ar_revcfmbill");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.removeCache(e.getDataEntities());
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }
}

