/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class RevCfmBillWriteBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RevCfmBillWriteBackOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("modifytime");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("e_sourcebillid");
        fieldKeys.add("e_sourcebillentryid");
        fieldKeys.add("e_confirmqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.processWriteBackData(dataEntities);
    }

    private void processWriteBackData(DynamicObject[] dataEntities) {
        DynamicObject[] finBills;
        Date upgradeDate = this.getUpgradeData();
        if (EmptyUtils.isEmpty((Object)upgradeDate)) {
            return;
        }
        List recEntries = Stream.of(dataEntities).filter(v -> "ar_finarbill".equals(v.getString("sourcebilltype")) && v.getDate("modifytime").before(upgradeDate)).map(v -> v.getDynamicObjectCollection("entry")).flatMap(Collection::stream).collect(Collectors.toList());
        List srcEntryIds = recEntries.stream().map(v -> v.getLong("e_sourcebillentryid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entry.id", "in", srcEntryIds);
        for (DynamicObject finBill : finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"payproperty.isbasedonamt,entry.e_amount,entry.e_confirmedqty,entry.e_unconfirmqty,entry.e_quantity", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection entries = finBill.getDynamicObjectCollection("entry");
            boolean isbasedonamt = finBill.getBoolean("payproperty.isbasedonamt");
            for (DynamicObject entry : entries) {
                if (!srcEntryIds.contains(entry.getLong("id")) || isbasedonamt && entry.getBigDecimal("e_amount").compareTo(BigDecimal.ZERO) != 0) continue;
                List refEntries = recEntries.stream().filter(v -> v.getLong("e_sourcebillentryid") == entry.getLong("id")).collect(Collectors.toList());
                BigDecimal confirmQty = refEntries.stream().map(v -> v.getBigDecimal("e_confirmqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                entry.set("e_confirmedqty", (Object)entry.getBigDecimal("e_confirmedqty").subtract(confirmQty));
                entry.set("e_unconfirmqty", (Object)entry.getBigDecimal("e_quantity").subtract(entry.getBigDecimal("e_confirmedqty")));
            }
        }
        SaveServiceHelper.update((DynamicObject[])finBills);
    }

    private Date getUpgradeData() {
        String upgradeDateStr = StdConfig.get((String)"confirmQtyUpgradeDate");
        if (EmptyUtils.isNotEmpty((Object)upgradeDateStr)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(upgradeDateStr);
            }
            catch (ParseException e) {
                logger.info(e.getMessage());
            }
        }
        return null;
    }
}

