/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SalPushArSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entry.e_srcbillid");
        e.getFieldKeys().add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"SalPushArSaveOp", (String)"beginOperationTransaction");){
            this.salOutPushCheck(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salOutPushCheck(BeginOperationTransactionArgs e) {
        boolean isAgPush;
        IAppCache iAppCache;
        HashMap<String, String> cacheMap;
        block22: {
            DynamicObject[] arBills = e.getDataEntities();
            if (arBills == null || arBills.length == 0) {
                return;
            }
            boolean isFromDataBase = arBills[0].getDataEntityState().getFromDatabase();
            String srcBillType = arBills[0].getString("sourcebilltype");
            if (!"im_saloutbill".equals(srcBillType) || isFromDataBase) {
                return;
            }
            cacheMap = new HashMap<String, String>(arBills.length);
            for (DynamicObject bill : arBills) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                Object pkValue = bill.getPkValue();
                for (DynamicObject entry : entrys) {
                    Long srcId = entry.getLong("e_srcbillid");
                    if (srcId == 0L || pkValue == null || pkValue.equals(0L)) continue;
                    String cacheKey = String.join((CharSequence)"_", "srcbillid", srcId.toString());
                    cacheMap.put(cacheKey, pkValue.toString());
                }
            }
            iAppCache = AppCache.get((String)"ar_push");
            isAgPush = false;
            String lockKey = "ar_push_srcbillid";
            try (DLock lock = DLock.create((String)lockKey);){
                if (!lock.tryLock()) break block22;
                try {
                    for (Map.Entry entry : cacheMap.entrySet()) {
                        String cacheKey = (String)entry.getKey();
                        String pkValue = (String)entry.getValue();
                        String cacheBillId = (String)iAppCache.get(cacheKey, String.class);
                        if (StringUtils.isBlank((CharSequence)cacheBillId)) {
                            iAppCache.put(cacheKey, (Object)pkValue);
                            continue;
                        }
                        isAgPush = true;
                        break;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onRollbacked() {
                SalPushArSaveOp.this.removeCache(iAppCache, cacheMap);
            }
        });
        if (isAgPush) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u660e\u7ec6\u884c\u5b58\u5728\u9500\u552e\u51fa\u5e93\u5355\u91cd\u590d\u4e0b\u63a8\u573a\u666f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"SalPushArSaveOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void removeCache(IAppCache iAppCache, Map<String, String> cacheMap) {
        for (Map.Entry<String, String> entry : cacheMap.entrySet()) {
            String cacheBillId;
            String cacheKey = entry.getKey();
            String pkValue = entry.getValue();
            if (!pkValue.equals(cacheBillId = (String)iAppCache.get(cacheKey, String.class))) continue;
            iAppCache.remove(cacheKey);
        }
    }
}

