/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.ar.validator.UnSettleValidator;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.UnSettleParam;

public class SettleRecordUnSettleOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        UnSettleValidator validator = new UnSettleValidator();
        e.addValidator((AbstractValidator)validator);
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("totalsettleamt");
        e.getFieldKeys().add("localtotalsettleamt");
        e.getFieldKeys().add("settlerelation");
        e.getFieldKeys().add("settletype");
        e.getFieldKeys().add("mainbilltype");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("settledate");
        e.getFieldKeys().add("corebillid");
        e.getFieldKeys().add("corebillentryid");
        e.getFieldKeys().add("settleentry");
        e.getFieldKeys().add("billentity");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("isvoucher");
        e.getFieldKeys().add("entry.billtype");
        e.getFieldKeys().add("entry.currency");
        e.getFieldKeys().add("entry.settleamt");
        e.getFieldKeys().add("entry.billid");
        e.getFieldKeys().add("entry.billentryid");
        e.getFieldKeys().add("entry.e_exchangerate");
        e.getFieldKeys().add("entry.billnum");
        e.getFieldKeys().add("e_settleentry");
        e.getFieldKeys().add("iswrittenoff");
        e.getFieldKeys().add("hadwrittenoff");
        e.getFieldKeys().add("e_hadwrittenoff");
        e.getFieldKeys().add("e_billentity");
        e.getFieldKeys().add("settleseq");
        e.getFieldKeys().add("mainpayableamt");
        e.getFieldKeys().add("entry.payableamt");
        e.getFieldKeys().add("entry.localsettleamt");
        e.getFieldKeys().add("autosettletype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<DynamicObject> deleteEntities = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> writeoffEntities = new ArrayList<DynamicObject>(entities.length);
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>();
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        if (redAllSettleRecord) {
            Collections.addAll(writeoffEntities, entities);
        } else {
            for (DynamicObject entity : entities) {
                long orgId = entity.getLong("org.id");
                Date currentDate = null;
                Date target = (Date)currentDateMap.get(orgId);
                if (target != null) {
                    currentDate = target;
                } else {
                    InitHelper init = new InitHelper(orgId, "ar_init");
                    currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                    currentDateMap.put(orgId, currentDate);
                }
                if ((entity.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)entity.getDate("settledate"), (Date)currentDate) > 0) && entity.getString("billstatus").equals(BillStatusEnum.AUDIT.getValue())) {
                    writeoffEntities.add(entity);
                    continue;
                }
                deleteEntities.add(entity);
            }
        }
        if (!deleteEntities.isEmpty()) {
            List<Long> sourceBillIds = this.getSourceBillIds(deleteEntities);
            Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])deleteEntities.toArray(new DynamicObject[0]));
            for (Map.Entry entry : map.entrySet()) {
                String settleRelation = (String)entry.getKey();
                List settleRecordList = (List)entry.getValue();
                AbstractSettleTemplate service = SettleServiceFactory.getService((String)settleRelation);
                if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
                    Map settleRecordGroup = SettleRecordOpHelper.classfySettleRecordBySettleModel((List)settleRecordList);
                    for (Map.Entry entry2 : settleRecordGroup.entrySet()) {
                        List groupSettleRecordLsit = (List)entry2.getValue();
                        service.unSettle(groupSettleRecordLsit.toArray(new DynamicObject[0]), true);
                    }
                    continue;
                }
                service.unSettle(settleRecordList.toArray(new DynamicObject[0]), true);
            }
            if (sourceBillIds.size() > 0) {
                SettleRecordOpHelper.updateWriteoffClose((Long[])sourceBillIds.toArray(new Long[0]));
            }
        }
        if (!writeoffEntities.isEmpty()) {
            DynamicObject[] entityArr = writeoffEntities.toArray(new DynamicObject[0]);
            List resultIds = writeoffEntities.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
            String arSettleRecordRedRuleId = "750450292776019968";
            List redSettleRecords = BOTPHelper.push((String)"ar_settlerecord", (String)"ar_settlerecord", (String)arSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u5e94\u6536\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"SettleRecordUnSettleOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)submitResult);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)auditResult);
            if (auditResult.isSuccess()) {
                SettleRecordOpHelper.updateWriteoffOpen((DynamicObject[])entityArr);
                UnSettleParam param = new UnSettleParam();
                param.setUnSettleByListOP(true);
                param.setRedSettleRecord(true);
                Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])entityArr);
                for (Map.Entry entry : map.entrySet()) {
                    String settleRelation = (String)entry.getKey();
                    List settleRecordList = (List)entry.getValue();
                    AbstractSettleTemplate service = SettleServiceFactory.getService((String)settleRelation);
                    if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
                        Map settleRecordGroup = SettleRecordOpHelper.classfySettleRecordBySettleModel((List)settleRecordList);
                        for (Map.Entry entryGroup : settleRecordGroup.entrySet()) {
                            List groupSettleRecordLsit = (List)entryGroup.getValue();
                            service.unSettle(groupSettleRecordLsit.toArray(new DynamicObject[0]), param);
                        }
                        continue;
                    }
                    service.unSettle(settleRecordList.toArray(new DynamicObject[0]), param);
                }
            }
        }
    }

    private List<Long> getSourceBillIds(List<DynamicObject> settleRecords) {
        ArrayList<Long> tarBillIds = new ArrayList<Long>(settleRecords.size());
        ArrayList<Long> tarBillEntryIds = new ArrayList<Long>(settleRecords.size());
        for (DynamicObject settleRecord : settleRecords) {
            tarBillIds.add((Long)settleRecord.getPkValue());
            DynamicObjectCollection entryColl = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                tarBillEntryIds.add(entry.getLong("id"));
            }
        }
        String recordEntity = "ap_settlerecord";
        Map settleRecordIds = BOTPHelper.loadNearUpBillIds((String)recordEntity, (String)"entry", (Long[])tarBillIds.toArray(new Long[0]), (Long[])tarBillEntryIds.toArray(new Long[0]), (String)recordEntity);
        if (settleRecordIds.size() < 1) {
            recordEntity = "ar_settlerecord";
            settleRecordIds = BOTPHelper.loadNearUpBillIds((String)recordEntity, (String)"entry", (Long[])tarBillIds.toArray(new Long[0]), (Long[])tarBillEntryIds.toArray(new Long[0]), (String)recordEntity);
        }
        ArrayList<Long> sourceIds = new ArrayList<Long>(10);
        if (settleRecordIds.size() < 1) {
            return sourceIds;
        }
        for (Long tarBillId : tarBillIds) {
            sourceIds.addAll((Collection)settleRecordIds.get(tarBillId));
        }
        return sourceIds;
    }
}

