/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.VerifyServiceFactory;
import kd.fi.ar.validator.VerifyRecordUnVerifyValidator;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.opplugin.VerifyRecordBaseUnVerifyOp;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.util.EmptyUtils;

public class VerifyRecordUnverifyOp
extends VerifyRecordBaseUnVerifyOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        VerifyRecordUnVerifyValidator validator = new VerifyRecordUnVerifyValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public List<String> preparePropertys() {
        List selector = super.preparePropertys();
        selector.add("verifytaxamount");
        selector.add("e_verifytaxamount");
        return selector;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = this.getAllData(e.getDataEntities());
        Map map = VerifyServiceHelper.classfyByRelation((DynamicObject[])entities);
        for (Map.Entry entry : map.entrySet()) {
            AbstractVerifyTemplate service = VerifyServiceFactory.getService((String)((String)entry.getKey()));
            service.unVerify(((List)entry.getValue()).toArray(new DynamicObject[0]));
        }
        this.clearRevcfmBillInventoryCost(e.getDataEntities());
    }

    private void clearRevcfmBillInventoryCost(DynamicObject[] verifyBillList) {
        DynamicObject[] revcfmBillList = this.listRevcfmBill(verifyBillList);
        if (EmptyUtils.isEmpty((Object)revcfmBillList)) {
            return;
        }
        for (DynamicObject entity : revcfmBillList) {
            entity.set("inventorycost", (Object)BigDecimal.ZERO);
            this.clearRevcfmBillEntryInventoryCost(entity);
        }
        SaveServiceHelper.update((DynamicObject[])revcfmBillList);
    }

    private void clearRevcfmBillEntryInventoryCost(DynamicObject rowEntity) {
        DynamicObjectCollection entryEntityList = rowEntity.getDynamicObjectCollection("entry");
        for (DynamicObject entity : entryEntityList) {
            entity.set("e_inventorycost", (Object)BigDecimal.ZERO);
        }
    }

    private DynamicObject[] listRevcfmBill(DynamicObject[] verifyBillList) {
        ArrayList salRevcfmEntryList = new ArrayList(16);
        List<String> verifyRelationList = Arrays.asList(VerifyRelationEnum.ARSALOUT.getValue(), VerifyRelationEnum.ARSALRETURN.getValue());
        for (DynamicObject entity2 : verifyBillList) {
            String verifyRelation = entity2.getString("verifyrelation");
            if (!verifyRelationList.contains(verifyRelation)) continue;
            DynamicObjectCollection entryList = entity2.getDynamicObjectCollection("entry");
            salRevcfmEntryList.addAll(entryList);
        }
        List revcfmIds = salRevcfmEntryList.stream().map(entity -> entity.getLong("e_billid")).distinct().collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,inventorycost,entry.e_inventorycost", (QFilter[])new QFilter[]{new QFilter("id", "in", revcfmIds)});
    }
}

