/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.adjexch;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.opplugin.ArBaseOp;

public class ArAdjExchOp
extends ArBaseOp {
    protected static final Log logger = LogFactory.getLog(ArAdjExchOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("currentdate");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!"genadjexch".equals(e.getOperationKey())) {
            return;
        }
        Map<Long, DynamicObject> initData = this.closeAccountDateValidator(e.getDataEntities());
        this.arAdjExch(initData);
    }

    private void arAdjExch(Map<Long, DynamicObject> initArr) {
    }

    private Map<Long, DynamicObject> closeAccountDateValidator(DynamicObject[] closeAccountDataEntity) {
        Date currentDate;
        HashMap<Long, Date> closeAccountDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject rowData : closeAccountDataEntity) {
            Long orgId = (Long)rowData.getDynamicObject("org").getPkValue();
            currentDate = rowData.getDate("currentdate");
            closeAccountDateMap.put(orgId, currentDate);
        }
        Set orgIds = closeAccountDateMap.keySet();
        QFilter orgFilter = new QFilter("org", "in", orgIds).and(new QFilter("isfinishinit", "=", (Object)Boolean.TRUE));
        DynamicObject[] initArr = BusinessDataServiceHelper.load((String)"ar_init", (String)"id,org,startperiod,curperiod,standardcurrency,settlemodel", (QFilter[])orgFilter.toArray());
        HashMap<Long, DynamicObject> initData = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject periodData : initArr) {
            Date periodStartDate;
            Long currentOrg = (Long)periodData.getDynamicObject("org").getPkValue();
            currentDate = (Date)closeAccountDateMap.get(currentOrg);
            if (currentDate.compareTo(periodStartDate = periodData.getDynamicObject("curperiod").getDate("begindate")) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u201c%s\u201d\uff0c\u5173\u8d26\u65e5\u671f\u5c0f\u4e8e\u8c03\u6c47\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"ArAdjExchOp_2", (String)"fi-ar-opplugin", (Object[])new Object[]{periodData.getString("org.name")}));
            }
            initData.put(currentOrg, periodData);
        }
        return initData;
    }
}

