/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.baddebtnew;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.business.service.baddebtnew.BadDebtAccrualService;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.ar.opplugin.baddebtnew.BadDebtAccrualOpValidator;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.AccrualRateRow;
import kd.fi.ar.vo.baddebtnew.AccrualResult;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.arapcommon.util.DateUtils;

public class BadDebtAccrualOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> list = new ArrayList<String>();
        list.add("org");
        list.add("accrualscheme");
        list.add("listperiod");
        list.add("preperiod");
        list.add("accrualstatus");
        list.add("period");
        list.add("isperiod");
        list.add("exratetable");
        list.add("exratedate");
        e.getFieldKeys().addAll(list);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BadDebtAccrualOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            orgIds.add(org.getLong("id"));
        }
        DynamicObject[] initDatas = BusinessDataServiceHelper.load((String)"ar_init", (String)"org,startperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        Map<Long, DynamicObject> initDataMap = Arrays.stream(initDatas).collect(Collectors.toMap(data -> data.getLong("org.id"), data -> data));
        for (DynamicObject accrualRecord : e.getDataEntities()) {
            BadDebtAccrualService badDebtAccrualService;
            AccrualResult accrualResult;
            DynamicObject org = accrualRecord.getDynamicObject("org");
            DynamicObject exchangeRateTable = accrualRecord.getDynamicObject("exratetable");
            Long exrateTableId = exchangeRateTable.getLong("id");
            boolean isPeriod = accrualRecord.getBoolean("isperiod");
            Long orgId = org.getLong("id");
            Long periodId = 0L;
            DynamicObject period = accrualRecord.getDynamicObject("period");
            DynamicObject initData = initDataMap.get(orgId);
            Date exchangeRateDate = isPeriod ? DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)initData.getDynamicObject("startperiod").getDate("begindate"), (int)1), (boolean)false) : period.getDate("enddate");
            if (period != null) {
                periodId = period.getLong("id");
            }
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection schemesIds = BaseDataServiceHelper.queryBaseData((String)"ar_baddebtaccrualplan", (Long)orgId, (QFilter)qFilter, (String)"id");
            if (schemesIds == null || schemesIds.size() < 1) {
                this.operationResult.setSuccess(false);
                OperateErrorInfo error = new OperateErrorInfo();
                error.setErrorLevel(ErrorLevel.Error.toString());
                error.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\uff0c\u8bf7\u914d\u7f6e\u3002", (String)"BadDebtAccrualOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                error.setPkValue(accrualRecord.getPkValue());
                this.operationResult.getAllErrorInfo().add(error);
                return;
            }
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"ar_baddebtaccrualplan", (String)"id,accrualfrequency,ruleentry.c_offset,ruleentry.c_offset_tag,ruleentry.c_includeperiod,ruleentry.c_accrualrate_tag,ruleentry.c_accrualentityobj,ruleentry.c_condition_tag,ruleentry.c_agingstartdate", (QFilter[])new QFilter[]{new QFilter("id", "in", schemesIds.stream().map(scheme -> scheme.getLong("id")).collect(Collectors.toSet()))});
            DynamicObject prePeriod = accrualRecord.getDynamicObject("preperiod");
            Long prePeriodId = 0L;
            if (prePeriod != null) {
                prePeriodId = prePeriod.getLong("id");
            }
            ArrayList<AccrualScheme> schemeList = new ArrayList<AccrualScheme>(8);
            String accrualFrequency = null;
            for (DynamicObject scheme2 : schemes) {
                if (accrualFrequency == null) {
                    accrualFrequency = scheme2.getString("accrualfrequency");
                    continue;
                }
                if (accrualFrequency.equals(scheme2.getString("accrualfrequency"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\uff0c\u5206\u7ec4\u8ba4\u5b9a\u9875\u7b7e\u4e2d\u5b58\u5728\u8ba1\u63d0\u9891\u7387\u4e0d\u540c\u7684\u8ba1\u63d0\u65b9\u6848\uff0c\u65e0\u6cd5\u540c\u65f6\u8ba1\u63d0", (String)"BadDebtAccrualOp_1", (String)"fi-ar-opplugin", (Object[])new Object[]{org.getString("name")}));
            }
            for (DynamicObject scheme2 : schemes) {
                DynamicObjectCollection cardEntries = scheme2.getDynamicObjectCollection("ruleentry");
                for (DynamicObject cardEntry : cardEntries) {
                    DynamicObject accrualObject;
                    boolean isOffset;
                    AccrualScheme groupScheme = new AccrualScheme();
                    HashMap<Integer, String> agingRange = new HashMap<Integer, String>(8);
                    HashMap<Integer, BigDecimal> accrualPercentForScheme = new HashMap<Integer, BigDecimal>(8);
                    String offsetRule = cardEntry.getString("c_offset");
                    boolean bl = isOffset = !"".equals(offsetRule);
                    if (isOffset) {
                        String offsetRuleJson = cardEntry.getString("c_offset_tag");
                        List accrualOffsetVos = SerializationUtils.fromJsonStringToList((String)offsetRuleJson, AccrualOffsetVo.class);
                        if (accrualOffsetVos == null || accrualOffsetVos.size() == 0) {
                            isOffset = false;
                        } else {
                            ArrayList<String> offsetFieldForReceivedBill = new ArrayList<String>(8);
                            ArrayList offsetFieldForRecBill = new ArrayList(8);
                            ArrayList<String> offsetedField = new ArrayList<String>(8);
                            boolean includePeriod = cardEntry.getBoolean("c_includeperiod");
                            for (AccrualOffsetVo vo : accrualOffsetVos) {
                                if (includePeriod) {
                                    offsetFieldForReceivedBill.add(vo.getReceivedfield());
                                }
                                offsetFieldForRecBill.add(vo.getRecbillfield());
                                offsetedField.add(vo.getOffsetbillfield());
                            }
                            String offsetedBillEntity = "ar_revcfmbill";
                            if ("1".equals(offsetRule)) {
                                offsetedBillEntity = "ar_busbill";
                            }
                            groupScheme.setOffsetVoList(accrualOffsetVos);
                            groupScheme.setOffsetFieldForReceivedBill(offsetFieldForReceivedBill);
                            groupScheme.setOffsetFieldForRecBill(offsetFieldForRecBill);
                            groupScheme.setOffsetedField(offsetedField);
                            groupScheme.setIncludePeriod(includePeriod);
                            groupScheme.setOffsetBillEntity(offsetedBillEntity);
                        }
                    }
                    int agingStartDay = Integer.MAX_VALUE;
                    String accrualRateJson = cardEntry.getString("c_accrualrate_tag");
                    List accrualRateRows = SerializationUtils.fromJsonStringToList((String)accrualRateJson, AccrualRateRow.class);
                    for (AccrualRateRow row : accrualRateRows) {
                        int startdays = row.getStartdays();
                        if (startdays < agingStartDay) {
                            agingStartDay = startdays;
                        }
                        if (row.isDaymore()) {
                            agingRange.put(Integer.MAX_VALUE, row.getSection());
                            accrualPercentForScheme.put(Integer.MAX_VALUE, row.getAccrualrate());
                            break;
                        }
                        agingRange.put(row.getEnddays(), row.getSection());
                        accrualPercentForScheme.put(row.getEnddays(), row.getAccrualrate());
                    }
                    if ((accrualObject = cardEntry.getDynamicObject("c_accrualentityobj")) == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u4e2d\u5b58\u5728\u8ba1\u63d0\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8ba1\u63d0\u65b9\u6848", (String)"BadDebtAccrualOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    }
                    String accrualObjectName = accrualObject.getString("entityobject");
                    String condition = cardEntry.getString("c_condition_tag");
                    CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
                    FilterCondition filterCondition = formula.getFilterCondition();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)accrualObjectName);
                    FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
                    filterBuilder.buildFilter(false);
                    QFilter accrualFilter = filterBuilder.getQFilter();
                    groupScheme.setEntityKey(accrualObjectName);
                    groupScheme.setAccrualObjId(Long.valueOf(accrualObject.getLong("id")));
                    groupScheme.setAccrualType("2");
                    groupScheme.setCondition(accrualFilter);
                    groupScheme.setIndividual(false);
                    groupScheme.setAccrualPercentForScheme(accrualPercentForScheme);
                    groupScheme.setAccrualSchemeId(Long.valueOf(scheme2.getLong("id")));
                    groupScheme.setAccrualFrequency(scheme2.getString("accrualfrequency"));
                    groupScheme.setAgingRange(agingRange);
                    groupScheme.setAgingStartDay(agingStartDay);
                    groupScheme.setOffset(isOffset);
                    groupScheme.setAgingDateEntity(cardEntry.getString("c_agingstartdate"));
                    schemeList.add(groupScheme);
                }
            }
            Long nextPeriodId = 0L;
            String nextPeriodName = null;
            if (!isPeriod) {
                DynamicObject nextPeriod = BadDebtAccrualHelper.getNextAccrualPeriod((Long)periodId, (String)schemes[0].getString("accrualfrequency"));
                if (nextPeriod == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u574f\u8d26\u8ba1\u63d0\uff1a\u83b7\u53d6\u4e0b\u4e00\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u914d\u7f6e\u3002", (String)"BadDebtAccrualOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                nextPeriodId = nextPeriod.getLong("id");
                nextPeriodName = nextPeriod.getString("name");
            }
            if ((accrualResult = (badDebtAccrualService = new BadDebtAccrualService(orgId, periodId)).badDebtAccrual(prePeriodId, schemeList, isPeriod, exrateTableId, exchangeRateDate)).isSuccess()) {
                if (!isPeriod) {
                    BadDebtAccrualHelper.insertNextPeriodBadDebtAccrue((Long)orgId, (Long)nextPeriodId, (Long)periodId, (Long)0L, (Boolean)Boolean.FALSE, (String)nextPeriodName, (Long)exrateTableId);
                }
                this.updateAccrualRecord(orgId, periodId, isPeriod);
                continue;
            }
            this.operationResult.setSuccess(false);
            OperateErrorInfo error = new OperateErrorInfo();
            error.setErrorLevel(ErrorLevel.Error.toString());
            error.setMessage(ResManager.loadKDString((String)"\u8ba1\u63d0\u5931\u8d25\uff1a%s", (String)"BadDebtAccrualOp_4", (String)"fi-ap-opplugin", (Object[])new Object[]{accrualResult.getErrorMsg()}));
            error.setPkValue(accrualRecord.getPkValue());
            this.operationResult.getAllErrorInfo().add(error);
        }
    }

    private void updateAccrualRecord(Long orgId, Long periodId, boolean isPeriod) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("period", "=", (Object)periodId));
        if (isPeriod) {
            filter.and(new QFilter("isperiod", "=", (Object)isPeriod));
        }
        DynamicObject accrualRecord = BusinessDataServiceHelper.loadSingle((String)"ar_baddebtaccrue", (String)"id,accrualstatus,accrualscheme", (QFilter[])filter.toArray());
        accrualRecord.set("accrualstatus", (Object)"1");
        OperationServiceHelper.executeOperate((String)"save", (String)"ar_baddebtaccrue", (DynamicObject[])new DynamicObject[]{accrualRecord}, (OperateOption)OperateOption.create());
    }
}

