/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.baddebtnew;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.opplugin.baddebtnew.CancelAccrualValidator;
import kd.fi.arapcommon.helper.OperationHelper;

public class CancelAccrualOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org");
        list.add("period");
        list.add("accrualstatus");
        list.add("accrualscheme");
        list.add("listperiod");
        list.add("preperiod");
        list.add("isperiod");
        e.getFieldKeys().addAll(list);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CancelAccrualValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject accrualRecord : e.getDataEntities()) {
            DynamicObject org = accrualRecord.getDynamicObject("org");
            Long periodId = 0L;
            DynamicObject period = accrualRecord.getDynamicObject("period");
            if (period != null) {
                periodId = period.getLong("id");
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
            DeleteServiceHelper.delete((String)"ar_baddebtpreparebill", (QFilter[])new QFilter[]{orgFilter, periodFilter});
        }
        this.updateAccrualRecord(e.getDataEntities());
        this.deleteNextPeriodRecord(e.getDataEntities());
    }

    private void deleteNextPeriodRecord(DynamicObject[] accrualRecords) {
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (DynamicObject accrualRecord : accrualRecords) {
            boolean isperiod = accrualRecord.getBoolean("isperiod");
            if (isperiod) {
                return;
            }
            DynamicObject org = accrualRecord.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            orgIds.add(org.getLong("id"));
        }
        DynamicObject[] lastPeriods = BusinessDataServiceHelper.load((String)"ar_baddebtaccrue", (String)"org,period", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)}, (String)"period desc", (int)1);
        HashMap<Long, List> lastPeriodMap = new HashMap<Long, List>(2);
        for (DynamicObject period : lastPeriods) {
            long orgId = period.getLong("org.id");
            List periodList = (List)lastPeriodMap.get(orgId);
            if (periodList == null) {
                ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(1);
                tempList.add(period);
                lastPeriodMap.put(orgId, tempList);
                continue;
            }
            periodList.add(period);
            lastPeriodMap.put(orgId, periodList);
        }
        for (DynamicObject accrualRecord : accrualRecords) {
            boolean isperiod = accrualRecord.getBoolean("isperiod");
            if (isperiod) {
                return;
            }
            DynamicObject org = accrualRecord.getDynamicObject("org");
            Long orgId = org.getLong("id");
            List lastPeriod = (List)lastPeriodMap.get(orgId);
            if (lastPeriod == null || lastPeriod.size() <= 0) continue;
            long baddebtAccrueId = ((DynamicObject)lastPeriod.get(0)).getLong("id");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_baddebtaccrue", (Object[])new Long[]{baddebtAccrueId}, (OperateOption)option);
            if (deleteResult.isSuccess()) continue;
            OperationHelper.assertResult((OperationResult)deleteResult);
        }
    }

    private void updateAccrualRecord(DynamicObject[] accrualRecords) {
        for (DynamicObject accrualRecord : accrualRecords) {
            accrualRecord.set("accrualstatus", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject[])accrualRecords);
    }
}

