/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.baddebtnew;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class CancelAccrualValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject data = entity.getDataEntity();
            DynamicObject org = data.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            orgIds.add(org.getLong("id"));
        }
        DynamicObject[] lastPeriods = BusinessDataServiceHelper.load((String)"ar_baddebtaccrue", (String)"org,period", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("accrualstatus", "=", (Object)"1")}, (String)"period desc", (int)1);
        HashMap<Long, List> lastPeriodMap = new HashMap<Long, List>(2);
        for (DynamicObject period : lastPeriods) {
            long orgId = period.getLong("org.id");
            List periodList = (List)lastPeriodMap.get(orgId);
            if (periodList == null) {
                ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(1);
                tempList.add(period);
                lastPeriodMap.put(orgId, tempList);
                continue;
            }
            periodList.add(period);
            lastPeriodMap.put(orgId, periodList);
        }
        DynamicObject[] initDatas = BusinessDataServiceHelper.load((String)"ar_init", (String)this.getSelectors(), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        Map<Long, DynamicObject> initDataMap = Arrays.stream(initDatas).collect(Collectors.toMap(e -> e.getLong("org.id"), e -> e));
        for (ExtendedDataEntity entity : dataEntities) {
            String accrualstatus;
            QFilter isVoucherFilter;
            boolean isVoucherAdjExchBillTap;
            boolean hasData;
            ArrayList<String> errorMessageList = new ArrayList<String>(8);
            DynamicObject data = entity.getDataEntity();
            DynamicObject org = data.getDynamicObject("org");
            Long periodId = 0L;
            String periodName = ResManager.loadKDString((String)"\u671f\u521d", (String)"CancelAccrualValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]);
            DynamicObject period = data.getDynamicObject("period");
            if (period != null) {
                periodId = period.getLong("id");
                periodName = period.getString("name");
            }
            long orgId = org.getLong("id");
            boolean isPeriod = data.getBoolean("isperiod");
            QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
            DynamicObject initData = initDataMap.get(orgId);
            List lastPeriod = (List)lastPeriodMap.get(orgId);
            boolean bl = hasData = !EmptyUtils.isEmpty((Object)lastPeriod);
            if (isPeriod) {
                if (hasData && EmptyUtils.isNotEmpty((Object)((DynamicObject)lastPeriod.get(0)).getDynamicObject("period"))) {
                    errorMessageList.add(ResManager.loadKDString((String)"\u5b58\u5728\u5176\u4ed6\u671f\u95f4\u5df2\u8ba1\u63d0\u8bb0\u5f55\u65f6\uff0c\u4e0d\u80fd\u53d6\u6d88\u671f\u521d\u8ba1\u63d0\u3002", (String)"CancelAccrualValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            } else if (hasData) {
                Boolean isAfterCurrentPeriod = PeriodHelper.before((DynamicObject)period, (DynamicObject)initData.getDynamicObject("curperiod"));
                if (isAfterCurrentPeriod.booleanValue()) {
                    errorMessageList.add(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26\u671f\u95f4\u4e0b\u7684\u574f\u8d26\u51c6\u5907\u5355\u4e0d\u53ef\u53d6\u6d88\u3002", (String)"CancelAccrualValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (!PeriodHelper.afterEquals((DynamicObject)period, (DynamicObject)((DynamicObject)lastPeriod.get(0)).getDynamicObject("period"))) {
                    errorMessageList.add(ResManager.loadKDString((String)"\u53cd\u8ba1\u63d0\u8981\u6309\u671f\u95f4\u4ece\u540e\u5f80\u524d\u4f9d\u6b21\u53d6\u6d88\u3002", (String)"CancelAccrualValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
            if (isVoucherAdjExchBillTap = QueryServiceHelper.exists((String)"ar_baddebtpreparebill", (QFilter[])new QFilter[]{orgFilter, periodFilter, isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE)})) {
                errorMessageList.add(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u574f\u8d26\u51c6\u5907\u5355\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8bd5\u3002", (String)"CancelAccrualValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if ("0".equals(accrualstatus = data.getString("accrualstatus"))) {
                errorMessageList.clear();
                errorMessageList.add(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u8ba1\u63d0\u7684\u6570\u636e\u624d\u5141\u8bb8\u53cd\u8ba1\u63d0\u3002", (String)"CancelAccrualValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (!EmptyUtils.isNotEmpty(errorMessageList)) continue;
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\u3002", (String)"CancelAccrualValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), org.getString("name"), periodName));
            for (String errorMessage : errorMessageList) {
                errorInfo.append(errorMessage);
            }
            this.addErrorMessage(entity, errorInfo.toString());
        }
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("isfinishinit");
        selectors.add("startperiod");
        selectors.add("curperiod");
        selectors.add("org");
        return String.join((CharSequence)",", selectors);
    }
}

