/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.checkitem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.util.DateUtils;

public class InventoryCostCheckPlugin
implements IClosePeriodCheckPlugin {
    private static Log logger = LogFactory.getLog(InventoryCostCheckPlugin.class);

    public CheckResult execute(CheckContext checkContext) throws Throwable {
        logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u6536\u5165\u786e\u8ba4\u5355\u5b58\u8d27\u6210\u672c\u68c0\u67e5\u5f00\u59cb");
        Long orgId = checkContext.getOrgId();
        Date periodStartDate = checkContext.getPeriodStartDate();
        Date periodEndDate = checkContext.getPeriodEndDate();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter startDateFilter = new QFilter("bookdate", ">=", (Object)DateUtils.getDataFormat((Date)periodStartDate, (boolean)true));
        QFilter endDateFilter = new QFilter("bookdate", "<=", (Object)DateUtils.getDataFormat((Date)periodEndDate, (boolean)false));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter verifyStatusFilter = new QFilter("verifystatus", "=", (Object)"verified");
        QFilter isWrittenOffFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
        QFilter hadWrittenOffFilter = new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DataSet revCfmBills = QueryServiceHelper.queryDataSet((String)"InventoryCostCheckPlugin.queryRevCfmBill", (String)"ar_revcfmbill", (String)"id,billno,inventorycost", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter, billStatusFilter, verifyStatusFilter, isWrittenOffFilter, hadWrittenOffFilter}, null);
        HashMap<Long, BigDecimal> billInventoryCostMap = new HashMap<Long, BigDecimal>(8);
        for (Row revCfmBill : revCfmBills) {
            billInventoryCostMap.put(revCfmBill.getLong("id"), revCfmBill.getBigDecimal("inventorycost"));
        }
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        if (ObjectUtils.isEmpty(billInventoryCostMap)) {
            logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u6536\u5165\u786e\u8ba4\u5355\u5b58\u8d27\u6210\u672c\u68c0\u67e5-\u65e0\u6536\u5165\u786e\u8ba4\u5355\uff0c\u68c0\u67e5\u901a\u8fc7");
            return checkResult;
        }
        Set revCfmBillIds = billInventoryCostMap.keySet();
        logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u6536\u5165\u786e\u8ba4\u5355\u5b58\u8d27\u6210\u672c\u68c0\u67e5-\u7b26\u5408\u68c0\u67e5\u6761\u4ef6\u7684\u6536\u5165\u786e\u8ba4\u5355ids==>{}", revCfmBillIds);
        Map<Long, BigDecimal> actualCost = this.getActualCost(new ArrayList<Long>(revCfmBillIds));
        if (ObjectUtils.isEmpty(actualCost)) {
            logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u6536\u5165\u786e\u8ba4\u5355\u5b58\u8d27\u6210\u672c\u68c0\u67e5-\u65e0\u5b58\u8d27\u6838\u7b97\u5b9e\u9645\u6210\u672c\uff0c\u68c0\u67e5\u901a\u8fc7");
            return checkResult;
        }
        ArrayList<Long> mismatchingBillIds = new ArrayList<Long>(10);
        for (Map.Entry billInventoryEntry : billInventoryCostMap.entrySet()) {
            Long billId = (Long)billInventoryEntry.getKey();
            BigDecimal billInventoryCost = (BigDecimal)billInventoryEntry.getValue();
            BigDecimal actualInventoryCost = actualCost.get(billId);
            if (actualInventoryCost == null || billInventoryCost.compareTo(actualInventoryCost) == 0) continue;
            mismatchingBillIds.add(billId);
        }
        if (!ObjectUtils.isEmpty(mismatchingBillIds)) {
            logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u6536\u5165\u786e\u8ba4\u5355\u5b58\u8d27\u6210\u672c\u68c0\u67e5-\u6536\u5165\u786e\u8ba4\u5355\u7684\u5b58\u8d27\u6210\u672c\u4e0e\u5b58\u8d27\u6838\u7b97\u7684\u5b9e\u9645\u6210\u672c\u4e0d\u4e00\u81f4\uff0c\u68c0\u67e5\u5931\u8d25\uff0c\u6536\u5165\u786e\u8ba4\u5355ids==>{}", mismatchingBillIds);
            checkResult.setIsSuccess(false);
            checkResult.setOnlineViewId("ar_revcfmbill");
            QFilter idFilter = new QFilter("id", "in", mismatchingBillIds);
            checkResult.setOnlineQueryParams(idFilter.toSerializedString());
        }
        return checkResult;
    }

    private Map<Long, BigDecimal> getActualCost(List<Long> revCfmIds) {
        HashMap<Long, BigDecimal> revCfmCostMap = new HashMap<Long, BigDecimal>(8);
        if (ObjectUtils.isEmpty(revCfmIds)) {
            return revCfmCostMap;
        }
        QFilter revCfmIdFilter = new QFilter("entry.e_billid", "in", revCfmIds);
        QFilter asstBillTypeFilter = new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill");
        QFilter billTypeFilter = new QFilter("billtype", "=", (Object)"im_saloutbill");
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revCfmIds.toArray(new Long[0]), (boolean)true);
        DataSet verifyRecords = QueryServiceHelper.queryDataSet((String)"InventoryCostCheckPlugin.queryVerifyRecord", (String)"ar_verifyrecord", (String)"id,billid,entry.e_billid", (QFilter[])new QFilter[]{revCfmIdFilter, asstBillTypeFilter, billTypeFilter, commonFilter}, null);
        HashMap<Long, Long> revCfmMap = new HashMap<Long, Long>(8);
        ArrayList<Long> mainBillIds = new ArrayList<Long>(8);
        for (Row verifyRecord : verifyRecords) {
            mainBillIds.add(verifyRecord.getLong("billid"));
            revCfmMap.put(verifyRecord.getLong("id"), verifyRecord.getLong("entry.e_billid"));
        }
        ArrayList verifyRecordIds = new ArrayList(revCfmMap.keySet());
        Map verifyRecordActualCost = VerifyServiceHelper.getCostRecordActualCost(verifyRecordIds, mainBillIds);
        for (Map.Entry entry : revCfmMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            Map costMap = (Map)verifyRecordActualCost.get(key);
            if (costMap == null) continue;
            BigDecimal actualCost = (BigDecimal)costMap.get("actualCost");
            BigDecimal totalcost = (BigDecimal)revCfmCostMap.get(value);
            if (totalcost == null) {
                totalcost = BigDecimal.ZERO;
            }
            revCfmCostMap.put(value, totalcost.add(actualCost));
        }
        return revCfmCostMap;
    }
}

