/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.ar.business.invoice.InvoiceCloudCallBackService;
import kd.fi.ar.business.invoice.InvoiceData;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;

public class ArInvoiceAbandonOp
extends ArBaseOp {
    private List<Long> failedPks = new ArrayList<Long>();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        InvoiceCloudCallBackService service = new InvoiceCloudCallBackService();
        for (DynamicObject invoice : e.getDataEntities()) {
            InvoiceData invoiceData;
            String taxNo = invoice.getString("sellertin");
            InvoiceResult invoiceResult = invoiceFacade.invalid(taxNo, invoiceData = new InvoiceData(invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            if (!invoiceResult.isSuccess()) {
                this.failedPks.add(invoice.getLong("id"));
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo(invoiceResult.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
                operateErrorInfo.setMessage(invoiceResult.getMessgae() + "(" + invoiceResult.getErrorCode() + ")");
                this.operationResult.addErrorInfo(operateErrorInfo);
                continue;
            }
            service.invalidCallBack(invoice);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.failedPks.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sellertin");
        fieldKeys.add("invoicecode");
        fieldKeys.add("invoiceno");
        fieldKeys.add("billno");
        fieldKeys.add("redinvoice");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entry");
        fieldKeys.add("e_quantity");
        fieldKeys.add("e_recamount");
        fieldKeys.add("recamount");
        fieldKeys.add("associatedamt");
        fieldKeys.add("e_associatedamt");
    }
}

