/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.ar.validator.Invoice2BusQtyAndAmtToleranceValidator;

public class ArInvoiceAuditOp
extends ArBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Invoice2BusQtyAndAmtToleranceValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebilltype");
        e.getFieldKeys().add("associatedamt");
        e.getFieldKeys().add("e_associatedamt");
        e.getFieldKeys().add("e_recamount");
        e.getFieldKeys().add("e_sourcebillid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject invoice : e.getDataEntities()) {
            BigDecimal invoiceAssociateAmt = BigDecimal.ZERO;
            String sourceBillType = invoice.getString("sourcebilltype");
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                long rowSourceBillId = row.getLong("e_sourcebillid");
                if (rowSourceBillId <= 0L) continue;
                BigDecimal invoiceRowAmount = row.getBigDecimal("e_recamount");
                row.set("e_associatedamt", (Object)invoiceRowAmount);
                invoiceAssociateAmt = invoiceAssociateAmt.add(invoiceRowAmount);
                invoice.set("associatedamt", (Object)invoiceAssociateAmt);
            }
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }
}

