/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceVoConverter;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;
import kd.fi.arapcommon.invoice.vo.Invoice;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ArInvoiceIssueOp
extends ArBaseOp {
    private List<Long> failedPks = new ArrayList<Long>();

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map<String, List<DynamicObject>> groupedInvoices = Arrays.stream(e.getDataEntities()).collect(Collectors.groupingBy(invoice -> invoice.getString("sellertin")));
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        for (List<DynamicObject> invoiceList : groupedInvoices.values()) {
            DynamicObject[] invoices = invoiceList.toArray(new DynamicObject[0]);
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    this.issue(invoiceFacade, invoices);
                }
                catch (Exception exc) {
                    tx.markRollback();
                    throw exc;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private void issue(InvoiceFacade invoiceFacade, DynamicObject[] invoices) {
        InvoiceVoConverter invoiceVoConverter = new InvoiceVoConverter();
        Invoice[] invoiceVos = invoiceVoConverter.convertInvoiceVo(invoices, true);
        OpLogServiceHelper.addLog((String)"IssueRequest", (Object)invoiceVos, (DynamicObject[])invoices, (boolean)false);
        InvoiceResult result = invoiceFacade.issue(invoiceVos);
        this.handleResult(result, invoices);
        SaveServiceHelper.save((DynamicObject[])invoices);
    }

    private void handleResult(InvoiceResult result, DynamicObject[] invoices) {
        Map datas;
        Map originalResult = result.getOriginalResult();
        if (originalResult.get("data") != null && StringUtils.isEmpty((String)originalResult.get("data").toString())) {
            originalResult.put("data", null);
        }
        if ((datas = (Map)originalResult.get("data")) == null) {
            for (DynamicObject invoice : invoices) {
                OperateErrorInfo operateErrorInfo;
                if (result.isSuccess()) {
                    invoice.set("invoicestatus", (Object)"2");
                    continue;
                }
                if ("1779".equals(result.getErrorCode())) {
                    invoice.set("invoicestatus", (Object)"2");
                    this.failedPks.add(invoice.getLong("id"));
                    operateErrorInfo = new OperateErrorInfo(result.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
                    operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u8d85\u8fc7\u9650\u989d\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u7ba1\u7406\u754c\u9762\u8fdb\u884c\u62c6\u7968\u3002", (String)"ArInvoiceIssueOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    this.operationResult.addErrorInfo(operateErrorInfo);
                    continue;
                }
                this.failedPks.add(invoice.getLong("id"));
                operateErrorInfo = new OperateErrorInfo(result.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
                operateErrorInfo.setMessage(result.getMessgae() + "(" + result.getErrorCode() + ")");
                this.operationResult.addErrorInfo(operateErrorInfo);
            }
        } else {
            for (DynamicObject invoice : invoices) {
                Map matchedResult = (Map)datas.get(invoice.getString("billno"));
                if (matchedResult == null) continue;
                String errorCode = (String)matchedResult.get("errcode");
                String message = (String)matchedResult.get("description");
                if ("0000".equals(errorCode)) {
                    List invoiceArray = (List)matchedResult.get("invoiceArray");
                    if (invoiceArray == null || invoiceArray.isEmpty()) continue;
                    Map invoiceData = (Map)invoiceArray.get(0);
                    invoice.set("invoicestatus", (Object)"1");
                    invoice.set("invoicecode", invoiceData.get("invoiceCode"));
                    invoice.set("invoiceno", invoiceData.get("invoiceNo"));
                    Date issueDate = this.parseDate(invoiceData.get("invoiceDate"));
                    if (issueDate != null) {
                        invoice.set("bizdate", (Object)issueDate);
                    }
                    invoice.set("pdfurl", invoiceData.get("pdfurl"));
                    continue;
                }
                if (!("1008".equals(errorCode) || "1009".equals(errorCode) || "1004".equals(errorCode))) {
                    invoice.set("invoicestatus", (Object)"2");
                }
                this.failedPks.add(invoice.getLong("id"));
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo(errorCode, ErrorLevel.Error, invoice.getPkValue());
                operateErrorInfo.setMessage(message + "(" + errorCode + ")");
                this.operationResult.addErrorInfo(operateErrorInfo);
            }
        }
    }

    private Date parseDate(Object rawDate) {
        if (rawDate == null) {
            return null;
        }
        if (rawDate instanceof Long) {
            return new Date((Long)rawDate);
        }
        if (rawDate instanceof String) {
            if ("".equals(((String)rawDate).trim())) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return simpleDateFormat.parse((String)rawDate);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (rawDate instanceof Date) {
            return (Date)rawDate;
        }
        return null;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.failedPks.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("e_invresult");
        fieldKeys.add("applydate");
        fieldKeys.add("invoicecode");
        fieldKeys.add("billno");
        fieldKeys.add("blueinvoicecode");
        fieldKeys.add("blueinvoiceno");
        fieldKeys.add("invoicetype");
        fieldKeys.add("redinvoice");
        fieldKeys.add("selleracct");
        fieldKeys.add("selleraddr");
        fieldKeys.add("seller");
        fieldKeys.add("sellertel");
        fieldKeys.add("sellertin");
        fieldKeys.add("buyeracct");
        fieldKeys.add("buyeraddr");
        fieldKeys.add("email");
        fieldKeys.add("buyertel");
        fieldKeys.add("buyer");
        fieldKeys.add("buyertin");
        fieldKeys.add("currency");
        fieldKeys.add("exratedate");
        fieldKeys.add("exchangerate");
        fieldKeys.add("amount");
        fieldKeys.add("recamount");
        fieldKeys.add("tax");
        fieldKeys.add("e_ispresent");
        fieldKeys.add("e_measureunit");
        fieldKeys.add("e_spectype");
        fieldKeys.add("e_taxclass");
        fieldKeys.add("e_actunitprice");
        fieldKeys.add("e_quantity");
        fieldKeys.add("e_amount");
        fieldKeys.add("e_taxrate");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_discountmode");
        fieldKeys.add("asstact");
        fieldKeys.add("duedate");
        fieldKeys.add("asstacttype");
        fieldKeys.add("paymode");
        fieldKeys.add("paycond");
        fieldKeys.add("recorg");
        fieldKeys.add("salesgroup");
        fieldKeys.add("salesman");
        fieldKeys.add("salesorg");
        fieldKeys.add("drawer");
        fieldKeys.add("payer");
        fieldKeys.add("checker");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("invoiceno");
        fieldKeys.add("inventoryflag");
        fieldKeys.add("serialno");
        fieldKeys.add("remark");
        fieldKeys.add("e_remark");
        fieldKeys.add("e_unitprice");
        fieldKeys.add("e_acttaxunitprice");
        fieldKeys.add("e_material");
        fieldKeys.add("e_expenseitem");
        fieldKeys.add("e_discountamount");
        fieldKeys.add("e_recamount");
        fieldKeys.add("pdfurl");
        fieldKeys.add("elepreviewurl");
        fieldKeys.add("bizdate");
        fieldKeys.add("e_taxunitprice");
        fieldKeys.add("sellername");
        fieldKeys.add("buyerbank");
        fieldKeys.add("sellerbank");
        fieldKeys.add("org");
        fieldKeys.add("e_itemname");
        fieldKeys.add("splitormergeflag");
        fieldKeys.add("buyername");
        fieldKeys.add("e_rowtype");
        fieldKeys.add("e_invspectype");
        fieldKeys.add("e_invoiceunit");
        fieldKeys.add("deduction");
        fieldKeys.add("taxationstyle");
    }
}

