/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.PrintParam;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.invoice.InvoiceResult;

public class ArInvoicePrintOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ArInvoicePrintOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Map<String, List<DynamicObject>> groupedInvoices = Arrays.stream(e.getDataEntities()).collect(Collectors.groupingBy(invoice -> invoice.getString("sellertin")));
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        for (List<DynamicObject> invoiceList : groupedInvoices.values()) {
            DynamicObject[] invoices = invoiceList.toArray(new DynamicObject[0]);
            this.print(invoiceFacade, invoices);
        }
    }

    private void print(InvoiceFacade invoiceFacade, DynamicObject[] invoices) {
        ArrayList<PrintParam> paramList = new ArrayList<PrintParam>(invoices.length);
        for (DynamicObject invoice : invoices) {
            logger.info(invoice.getString("invoiceno"));
            PrintParam param = new PrintParam(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
            String type = invoice.getString("invoicetype");
            if (InvoiceType.SP.getValue().equals(type)) {
                param.setKpzl("0");
            }
            paramList.add(param);
        }
        InvoiceResult result = invoiceFacade.print(invoices[0].getString("sellertin"), this.invoiceNoSorter(paramList));
        if (!result.isSuccess()) {
            throw new KDBizException(result.getMessgae() + "(" + result.getErrorCode() + ")");
        }
    }

    private ArrayList<PrintParam> invoiceNoSorter(ArrayList<PrintParam> paramList) {
        if (1 == paramList.size()) {
            return paramList;
        }
        HashMap<Long, PrintParam> sortMap = new HashMap<Long, PrintParam>();
        Long maxNo = 0L;
        Long minNo = Long.valueOf(paramList.get(0).getFphm());
        for (PrintParam printParam : paramList) {
            Long key = Long.valueOf(printParam.getFphm());
            if (maxNo < key) {
                maxNo = key;
            }
            if (minNo > key) {
                minNo = key;
            }
            sortMap.put(key, printParam);
        }
        if (maxNo - minNo + 1L == (long)paramList.size()) {
            paramList.clear();
            Long key = minNo;
            while (key < maxNo + 1L) {
                paramList.add((PrintParam)sortMap.get(key));
                Long l = key;
                Long l2 = key = Long.valueOf(key + 1L);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u5b58\u5728\u8df3\u53f7\uff0c\u4e0d\u80fd\u6279\u91cf\u6253\u5370\u3002", (String)"ArInvoicePrintOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        return paramList;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("invoiceno");
        fieldKeys.add("invoicecode");
        fieldKeys.add("invoicetype");
        fieldKeys.add("sellertin");
    }
}

