/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceVoConverter;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;
import kd.fi.arapcommon.invoice.vo.Invoice;

public class ArInvoiceSubmitCloudOp
extends ArBaseOp {
    private List<Long> failedPks = new ArrayList<Long>();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map<String, List<DynamicObject>> groupedInvoices = Arrays.stream(e.getDataEntities()).collect(Collectors.groupingBy(invoice -> invoice.getString("sellertin")));
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        for (List<DynamicObject> invoiceList : groupedInvoices.values()) {
            DynamicObject[] invoices = invoiceList.toArray(new DynamicObject[0]);
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    this.submitCloud(invoiceFacade, invoices);
                }
                catch (Exception exc) {
                    tx.markRollback();
                    throw exc;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private void submitCloud(InvoiceFacade invoiceFacade, DynamicObject[] invoices) {
        InvoiceVoConverter invoiceVoConverter = new InvoiceVoConverter();
        Invoice[] invoiceVos = invoiceVoConverter.convertInvoiceVo(invoices, false);
        InvoiceResult result = invoiceFacade.issue(invoiceVos);
        this.handleResult(result, invoices);
        SaveServiceHelper.save((DynamicObject[])invoices);
    }

    private void handleResult(InvoiceResult result, DynamicObject[] invoices) {
        for (DynamicObject invoice : invoices) {
            if (result.isSuccess()) {
                invoice.set("invoicestatus", (Object)"2");
                continue;
            }
            this.failedPks.add(invoice.getLong("id"));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo(result.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
            operateErrorInfo.setMessage(result.getMessgae() + "(" + result.getErrorCode() + ")");
            this.operationResult.addErrorInfo(operateErrorInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.failedPks.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("e_invresult");
        fieldKeys.add("applydate");
        fieldKeys.add("invoicecode");
        fieldKeys.add("billno");
        fieldKeys.add("blueinvoicecode");
        fieldKeys.add("blueinvoiceno");
        fieldKeys.add("invoicetype");
        fieldKeys.add("redinvoice");
        fieldKeys.add("selleracct");
        fieldKeys.add("selleraddr");
        fieldKeys.add("seller");
        fieldKeys.add("sellertel");
        fieldKeys.add("sellertin");
        fieldKeys.add("buyeracct");
        fieldKeys.add("buyeraddr");
        fieldKeys.add("email");
        fieldKeys.add("buyertel");
        fieldKeys.add("buyer");
        fieldKeys.add("buyertin");
        fieldKeys.add("currency");
        fieldKeys.add("exratedate");
        fieldKeys.add("exchangerate");
        fieldKeys.add("amount");
        fieldKeys.add("recamount");
        fieldKeys.add("tax");
        fieldKeys.add("e_ispresent");
        fieldKeys.add("e_measureunit");
        fieldKeys.add("e_spectype");
        fieldKeys.add("e_taxclass");
        fieldKeys.add("e_actunitprice");
        fieldKeys.add("e_quantity");
        fieldKeys.add("e_amount");
        fieldKeys.add("e_taxrate");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_discountmode");
        fieldKeys.add("asstact");
        fieldKeys.add("duedate");
        fieldKeys.add("asstacttype");
        fieldKeys.add("paymode");
        fieldKeys.add("paycond");
        fieldKeys.add("recorg");
        fieldKeys.add("salesgroup");
        fieldKeys.add("salesman");
        fieldKeys.add("salesorg");
        fieldKeys.add("drawer");
        fieldKeys.add("payer");
        fieldKeys.add("checker");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("invoiceno");
        fieldKeys.add("inventoryflag");
        fieldKeys.add("serialno");
        fieldKeys.add("remark");
        fieldKeys.add("e_remark");
        fieldKeys.add("e_unitprice");
        fieldKeys.add("e_acttaxunitprice");
        fieldKeys.add("e_material");
        fieldKeys.add("e_expenseitem");
        fieldKeys.add("e_discountamount");
        fieldKeys.add("e_recamount");
        fieldKeys.add("pdfurl");
        fieldKeys.add("elepreviewurl");
        fieldKeys.add("bizdate");
        fieldKeys.add("e_taxunitprice");
        fieldKeys.add("sellername");
        fieldKeys.add("buyerbank");
        fieldKeys.add("sellerbank");
        fieldKeys.add("org");
        fieldKeys.add("e_itemname");
        fieldKeys.add("splitormergeflag");
        fieldKeys.add("buyername");
        fieldKeys.add("e_rowtype");
        fieldKeys.add("e_invspectype");
        fieldKeys.add("e_invoiceunit");
        fieldKeys.add("deduction");
        fieldKeys.add("taxationstyle");
    }
}

