/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.WriteoffParam;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;

public class ArInvoiceWriteoffOp
extends AbstractOperationServicePlugIn {
    private List<Long> failedPks = new ArrayList<Long>();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        for (DynamicObject invoice : e.getDataEntities()) {
            String taxNo = invoice.getString("sellertin");
            WriteoffParam writeoffParam = new WriteoffParam();
            writeoffParam.setBillNo(invoice.getString("billno"));
            writeoffParam.addInvoiceData(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
            InvoiceResult invoiceResult = invoiceFacade.writeoff(taxNo, writeoffParam);
            if (invoiceResult.isSuccess()) continue;
            this.failedPks.add(invoice.getLong("id"));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo(invoiceResult.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
            operateErrorInfo.setMessage(invoiceResult.getMessgae());
            this.operationResult.addErrorInfo(operateErrorInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.failedPks.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sellertin");
        fieldKeys.add("invoicecode");
        fieldKeys.add("invoiceno");
        fieldKeys.add("billno");
    }
}

