/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.business.piaozone.SerialNoGenerator;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.ar.validator.InvoiceArBillImportValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.validator.paysecurity.ArInvoiceExcessBusValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;

public class InvoiceSaveOp
extends ArBaseOp {
    private static final Log logger = LogFactory.getLog(InvoiceSaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"recamount", "reclocalamt", "amount", "localamt", "tax", "associatedamt"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("billno");
        keys.add("imageno");
        keys.add("creator");
        keys.add("modifier");
        keys.add("createtime");
        keys.add("modifytime");
        keys.add("serialno");
        keys.add("invoicetype");
        keys.add("isincludetax");
        keys.add("e_unitprice");
        keys.add("e_ispresent");
        keys.add("entry.e_invspectype");
        keys.add("billsrctype");
        keys.add("recamount");
        keys.add("expense");
        keys.add("sellername");
        keys.add("sellertin");
        keys.add("buyername");
        keys.add("selleraddr");
        keys.add("selleracct");
        keys.add("basecurrency");
        keys.add("buyeraddr");
        keys.add("buyertin");
        keys.add("associatedamt");
        keys.add("entry.e_associatedamt");
        keys.add("recamount");
        keys.add("tax");
        keys.add("amount");
        keys.add("entry.e_amount");
        keys.add("entry.e_tax");
        keys.add("entry.e_recamount");
        keys.add("asstact");
        keys.add("duedate");
        keys.add("bizdate");
        keys.add("entry.e_taxrate");
        keys.add("asstacttype");
        keys.add("invoicetypef7");
        keys.add("sourcebilltype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("InvoiceSaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(dataEntities);
        logger.info("InvoiceSaveOp.beginOperationTransaction appendHeadAmt end");
        for (DynamicObject elem : dataEntities) {
            if (elem.getString("serialno").trim().length() > 0) continue;
            elem.set("serialno", (Object)SerialNoGenerator.genSerialNo());
        }
        ArApDataRepairHelper.repairArInvoiceAmtField((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (!"true".equals(StdConfig.get((String)"busPaysecurityUseTolerance"))) {
            DynamicObject[] entities = e.getDataEntities();
            ArrayList<Long> billIds = new ArrayList<Long>(16);
            for (DynamicObject bill : entities) {
                String sourceBillType = bill.getString("sourcebilltype");
                if (StringUtils.isEmpty((String)sourceBillType)) continue;
                billIds.add(bill.getLong("id"));
            }
            if (billIds.size() == 0) {
                return;
            }
            ArInvoiceExcessBusValidator validator = new ArInvoiceExcessBusValidator();
            List results = validator.validate(billIds, "save");
            ArrayList<String> errMessage = new ArrayList<String>(16);
            for (BusValidatorResult result : results) {
                String message = result.getMessage();
                errMessage.add(message);
            }
            if (errMessage.size() > 0) {
                throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InvoiceArBillImportValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }
}

