/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.ar.business.piaozone.SerialNoGenerator;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.ar.validator.InvoiceSubmitValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.BillAppStatusValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.validator.paysecurity.ArInvoiceExcessBusValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;

public class InvoiceSubmitOp
extends ArBaseOp {
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        InvoiceSubmitValidator v = new InvoiceSubmitValidator();
        v.setEntityKey("ar_invoice");
        e.addValidator((AbstractValidator)v);
        e.addValidator((AbstractValidator)new BillAppStatusValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("bizdate");
        list.add("biztype");
        list.add("invoicetype");
        list.add("invoicetypef7");
        list.add("recamount");
        list.add("amount");
        list.add("localamt");
        list.add("tax");
        list.add("expense");
        list.add("sourcebillid");
        list.add("sourcebilltype");
        list.add("org");
        list.add("billno");
        list.add("imageno");
        list.add("creator");
        list.add("modifier");
        list.add("createtime");
        list.add("modifytime");
        list.add("buyer");
        list.add("buyername");
        list.add("buyeracct");
        list.add("buyertin");
        list.add("buyeraddr");
        list.add("buyertel");
        list.add("seller");
        list.add("sellertel");
        list.add("sellertin");
        list.add("sellername");
        list.add("selleraddr");
        list.add("selleracct");
        list.add("serialno");
        list.add("email");
        list.add("entry");
        list.add("e_material");
        list.add("e_measureunit");
        list.add("e_expenseitem");
        list.add("e_taxclass");
        list.add("e_tax");
        list.add("e_amount");
        list.add("e_localamt");
        list.add("e_recamount");
        list.add("e_taxrate");
        list.add("isincludetax");
        list.add("e_unitprice");
        list.add("e_ispresent");
        list.add("e_rowtype");
        list.add("e_itemname");
        list.add("entry.e_invspectype");
        list.add("entry.e_quantity");
        list.add("entry.e_discountamount");
        list.add("e_corebillno");
        list.add("e_corebillentryseq");
        list.add("corebillid");
        list.add("corebillentryid");
        list.add("associatedamt");
        list.add("basecurrency");
        list.add("entry.e_associatedamt");
        list.add("exratetable");
        list.add("currency");
        list.add("exchangerate");
        list.add("asstacttype");
        list.add("asstact");
        list.add("invoicetypef7");
        list.add("e_corebilltype");
        list.add("corebillid");
        list.add("corebillentryid");
        list.add("e_baseunit");
        list.add("e_baseunitqty");
        list.add("entry.seq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject elem : dataEntities = e.getDataEntities()) {
            if (elem.getString("serialno").trim().length() > 0) continue;
            elem.set("serialno", (Object)SerialNoGenerator.genSerialNo());
        }
        ArApDataRepairHelper.repairArInvoiceAmtField((DynamicObject[])dataEntities);
        Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
        for (DynamicObject inv : dataEntities) {
            Object invoicetype = inv.get("invoicetypef7");
            if (invoicetype == null || invoicetype.equals(0L)) {
                String invoicetypeStr = inv.getString("invoicetype");
                Long pk = invoiceTypePKMap.computeIfAbsent(InvoiceType.getTypeNo((String)invoicetypeStr), v -> 0L);
                inv.set("invoicetypef7", (Object)pk);
                continue;
            }
            if (!(invoicetype instanceof DynamicObject)) continue;
            String number = ((DynamicObject)invoicetype).getString("number");
            String value = InvoiceType.getValue((String)number);
            if (value == null) {
                value = number;
            }
            inv.set("invoicetype", (Object)value);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (DynamicObject bill : entities) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourceBillType)) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() == 0) {
            return;
        }
        ArInvoiceExcessBusValidator validator = new ArInvoiceExcessBusValidator();
        List results = validator.validate(billIds, "submit");
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (BusValidatorResult result : results) {
            String message = result.getMessage();
            errMessage.add(message);
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.removeCache(e.getDataEntities());
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }
}

