/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.validator.SaleInvoiceAuditValidator;
import kd.fi.arapcommon.helper.OperationHelper;

public class SaleInvoiceAuditOp
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        Map<Long, List<DynamicObject>> orgGroupInvoices = Arrays.stream(entities).collect(Collectors.groupingBy(invoice -> invoice.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : orgGroupInvoices.entrySet()) {
            boolean autopush = SystemParameterHelper.getParameterBoolean((long)entry.getKey(), (String)"ar_001");
            if (!autopush) continue;
            for (DynamicObject invoice2 : entry.getValue()) {
                String sourceBillType = invoice2.getString("sourcebilltype");
                if ("ar_finarbill".equals(sourceBillType) || "ar_invoice".equals(sourceBillType)) continue;
                OperateOption option = OperateOption.create();
                option.setVariableValue("mutex_writeback", "false");
                OperationResult pushFinBillResult = OperationServiceHelper.executeOperate((String)"pushfinbill", (String)"ar_invoice", (Object[])new Long[]{invoice2.getLong("id")}, (OperateOption)option);
                OperationHelper.assertResult((OperationResult)pushFinBillResult);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        SaleInvoiceAuditValidator v = new SaleInvoiceAuditValidator();
        v.setEntityKey("ar_invoice");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebilltype");
        e.getFieldKeys().add("org");
    }
}

