/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.invoice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.opplugin.ArBaseOp;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;
import kd.fi.arapcommon.util.StringUtils;

public class SyncInvoiceOp
extends ArBaseOp {
    private List<Long> failedPks = new ArrayList<Long>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> invoicesToUpdate = new ArrayList<DynamicObject>();
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        for (DynamicObject invoice : e.getDataEntities()) {
            InvoiceResult invoiceResult;
            String taxRegNum = invoice.getString("sellertin");
            String billNo = invoice.getString("billno");
            if (StringUtils.isNotEmpty((String)invoice.getString("srcbillno")) && !invoice.getBoolean("isabandonreissue")) {
                billNo = invoice.getString("srcbillno");
            }
            if ((invoiceResult = invoiceFacade.query(taxRegNum, billNo)).isSuccess()) {
                List invoiceDatas = (List)invoiceResult.getOriginalResult().get("data");
                Map invoiceData = null;
                if (invoiceDatas.size() == 1) {
                    invoiceData = (Map)invoiceDatas.get(0);
                } else if (StringUtils.isNotEmpty((String)invoice.getString("srcbillno"))) {
                    for (Map data : invoiceDatas) {
                        Object no = data.get("invoiceNo");
                        Object code = data.get("invoiceCode");
                        if (!no.equals(invoice.get("invoiceno")) || !code.equals(invoice.get("invoicecode"))) continue;
                        invoiceData = data;
                        invoiceData.put("isPartErr", Boolean.FALSE);
                        invoiceData.put("billNo", invoice.getString("billno"));
                    }
                } else {
                    if ("9".equals(invoice.get("invoicestatus"))) return;
                    invoiceFacade.issueCallBack(invoiceDatas);
                    return;
                }
                if (invoiceData != null) {
                    String currentInvoiceStatus;
                    Object originalStatus = invoiceData.get("invoiceStatus");
                    String string = currentInvoiceStatus = originalStatus == null ? null : originalStatus.toString();
                    if ("0".equals(currentInvoiceStatus)) {
                        ArrayList<Map> list = new ArrayList<Map>();
                        list.add(invoiceData);
                        invoiceFacade.issueCallBack(list);
                    } else if ("1".equals(currentInvoiceStatus)) {
                        invoice.set("invoicestatus", (Object)"5");
                    } else if ("2".equals(currentInvoiceStatus)) {
                        if (!invoiceData.get("billNo").equals(invoice.getString("billno"))) {
                            invoiceData.put("billNo", invoice.getString("billno"));
                        }
                        invoiceFacade.abandonCallBack(invoiceData);
                    } else if ("3".equals(currentInvoiceStatus)) {
                        invoiceFacade.writeoffCallBack(invoiceData);
                    } else {
                        if (!"4".equals(currentInvoiceStatus)) throw new IllegalArgumentException("Unknown Invoice Status : " + currentInvoiceStatus);
                        invoice.set("invoicestatus", (Object)"6");
                    }
                }
            } else {
                String errorCode = invoiceResult.getErrorCode();
                if ("0579".equals(errorCode)) {
                    invoice.set("invoicestatus", (Object)"0");
                    invoicesToUpdate.add(invoice);
                } else if ("0580".equals(errorCode)) {
                    invoice.set("invoicestatus", (Object)"2");
                    invoicesToUpdate.add(invoice);
                }
                this.failedPks.add(invoice.getLong("id"));
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo(invoiceResult.getErrorCode(), ErrorLevel.Error, invoice.getPkValue());
                operateErrorInfo.setMessage(invoiceResult.getMessgae() + "(" + invoiceResult.getErrorCode() + ")");
                this.operationResult.addErrorInfo(operateErrorInfo);
            }
            SaveServiceHelper.save((DynamicObject[])invoicesToUpdate.toArray(new DynamicObject[0]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.failedPks.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.getSuccessPkIds().removeAll(this.failedPks);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sellertin");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("srcbillno");
        e.getFieldKeys().add("isabandonreissue");
        e.getFieldKeys().add("invoicestatus");
        e.getFieldKeys().add("invoiceno");
        e.getFieldKeys().add("invoicecode");
    }
}

