/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin.repair;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.price.IPriceCalculate;

public class RevcfmDataRepairOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("exchangerate");
        lst.add("quotation");
        lst.add("sourcebilltype");
        lst.add("basecurrency");
        lst.add("entry.id");
        lst.add("entry.e_sourcebillentryid");
        lst.add("entry.taxrateid");
        lst.add("entry.e_taxrate");
        lst.add("entry.e_confirmamt");
        lst.add("entry.e_confirmlocamt");
        lst.add("entry.e_confirmtax");
        lst.add("entry.e_confirmloctax");
        lst.add("entry.e_cfmpricetax");
        lst.add("entry.e_cfmpricetaxbase");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> srcFinArEntryIds = new HashSet<Long>(8);
        HashSet<Long> srcBusArEntryIds = new HashSet<Long>(8);
        HashSet<Long> srcSalOrderEntryIds = new HashSet<Long>(8);
        block10: for (DynamicObject bill : dataEntities) {
            String srcBillType = bill.getString("sourcebilltype");
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entry");
            switch (srcBillType) {
                case "ar_finarbill": {
                    srcFinArEntryIds.addAll(entryCol.stream().map(entry -> entry.getLong("e_sourcebillentryid")).collect(Collectors.toSet()));
                    continue block10;
                }
                case "ar_busbill": {
                    srcBusArEntryIds.addAll(entryCol.stream().map(entry -> entry.getLong("e_sourcebillentryid")).collect(Collectors.toSet()));
                    continue block10;
                }
                case "sm_salorder": {
                    srcSalOrderEntryIds.addAll(entryCol.stream().map(entry -> entry.getLong("e_sourcebillentryid")).collect(Collectors.toSet()));
                    continue block10;
                }
            }
        }
        HashMap<Long, RevcfmUpParam> map = new HashMap<Long, RevcfmUpParam>(8);
        if (srcFinArEntryIds.size() > 0) {
            this.fidFinArParam(map, srcFinArEntryIds);
        }
        if (srcBusArEntryIds.size() > 0) {
            this.fidBusArParam(map, srcBusArEntryIds);
        }
        if (srcSalOrderEntryIds.size() > 0) {
            this.fidSalOrderParam(map, srcSalOrderEntryIds);
        }
        if (!map.isEmpty()) {
            for (DynamicObject bill : dataEntities) {
                String quotation = bill.getString("quotation");
                BigDecimal exchangerate = bill.getBigDecimal("exchangerate");
                DynamicObject bascur = bill.getDynamicObject("basecurrency");
                int baseprecision = bascur.getInt("amtprecision");
                DynamicObjectCollection busArEntryCol = bill.getDynamicObjectCollection("entry");
                for (DynamicObject busArEntryInfo : busArEntryCol) {
                    Long srcEntryId = busArEntryInfo.getLong("e_sourcebillentryid");
                    RevcfmUpParam revcfmUpParam = (RevcfmUpParam)map.get(srcEntryId);
                    if (revcfmUpParam.isEmpty()) continue;
                    Long taxrateid = revcfmUpParam.getTaxrateid();
                    BigDecimal taxrate = revcfmUpParam.getTaxrate();
                    busArEntryInfo.set("taxrateid", (Object)taxrateid);
                    busArEntryInfo.set("e_taxrate", (Object)taxrate);
                    BigDecimal confirmamt = busArEntryInfo.getBigDecimal("e_confirmamt");
                    BigDecimal confirmlocamt = busArEntryInfo.getBigDecimal("e_confirmlocamt");
                    confirmLocalCalculator calculator = new confirmLocalCalculator(confirmamt, confirmlocamt, taxrate, exchangerate, baseprecision, quotation);
                    calculator.calculate();
                    busArEntryInfo.set("e_confirmtax", (Object)calculator.getConfirmtax());
                    busArEntryInfo.set("e_confirmloctax", (Object)calculator.getConfirmloctax());
                    busArEntryInfo.set("e_cfmpricetax", (Object)calculator.getCfmpricetax());
                    busArEntryInfo.set("e_cfmpricetaxbase", (Object)calculator.getCfmpricetaxbase());
                }
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    private void fidFinArParam(Map<Long, RevcfmUpParam> map, Set<Long> srcFinArEntryIds) {
        QFilter filter = new QFilter("entry.id", "in", srcFinArEntryIds);
        DynamicObjectCollection finArCol = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.id,entry.taxrateid,entry.e_taxrate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject finArInfo : finArCol) {
            Long entryId = finArInfo.getLong("entry.id");
            Long taxrateid = finArInfo.getLong("entry.taxrateid");
            BigDecimal taxrate = finArInfo.getBigDecimal("entry.e_taxrate");
            RevcfmUpParam param = new RevcfmUpParam(taxrateid, taxrate);
            map.put(entryId, param);
        }
    }

    private void fidBusArParam(Map<Long, RevcfmUpParam> map, Set<Long> srcBusArEntryIds) {
        QFilter filter = new QFilter("entry.id", "in", srcBusArEntryIds);
        DynamicObjectCollection busArCol = QueryServiceHelper.query((String)"ar_busbill", (String)"entry.id,entry.taxrateid,entry.e_taxrate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject busArInfo : busArCol) {
            Long entryId = busArInfo.getLong("entry.id");
            Long taxrateid = busArInfo.getLong("entry.taxrateid");
            BigDecimal taxrate = busArInfo.getBigDecimal("entry.e_taxrate");
            RevcfmUpParam param = new RevcfmUpParam(taxrateid, taxrate);
            map.put(entryId, param);
        }
    }

    private void fidSalOrderParam(Map<Long, RevcfmUpParam> map, Set<Long> srcSalOrderEntryIds) {
        QFilter filter = new QFilter("billentry.id", "in", srcSalOrderEntryIds);
        DynamicObjectCollection salOrderCol = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.id,billentry.taxrateid,billentry.taxrate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject salOrderInfo : salOrderCol) {
            Long entryId = salOrderInfo.getLong("billentry.id");
            Long taxrateid = salOrderInfo.getLong("billentry.taxrateid");
            BigDecimal taxrate = salOrderInfo.getBigDecimal("billentry.taxrate");
            RevcfmUpParam param = new RevcfmUpParam(taxrateid, taxrate);
            map.put(entryId, param);
        }
    }

    static class confirmLocalCalculator
    implements IPriceCalculate {
        private static String quotation;
        private static BigDecimal taxrate;
        private static BigDecimal confirmtax;
        private static BigDecimal confirmloctax;
        private static BigDecimal exchangerate;
        private static BigDecimal cfmpricetax;
        private static BigDecimal cfmpricetaxbase;
        private static BigDecimal confirmamt;
        private static BigDecimal confirmlocamt;
        private static int localCurrencyPrecison;

        public confirmLocalCalculator(BigDecimal confirmamt, BigDecimal confirmlocamt, BigDecimal taxrate, BigDecimal exchangerate, int localCurrencyPrecison, String quotation) {
            confirmLocalCalculator.confirmamt = confirmamt;
            confirmLocalCalculator.confirmlocamt = confirmlocamt;
            confirmLocalCalculator.taxrate = taxrate;
            confirmLocalCalculator.exchangerate = exchangerate;
            confirmLocalCalculator.localCurrencyPrecison = localCurrencyPrecison;
            confirmLocalCalculator.quotation = quotation;
        }

        public void calculate() {
            confirmtax = confirmamt.multiply(taxrate).divide(BigDecimal.valueOf(100L), localCurrencyPrecison, RoundingMode.HALF_UP);
            confirmloctax = "1".equals(quotation) ? confirmtax.divide(exchangerate, localCurrencyPrecison, RoundingMode.HALF_UP) : confirmtax.multiply(exchangerate).setScale(localCurrencyPrecison, RoundingMode.HALF_UP);
            cfmpricetax = confirmamt.add(confirmtax);
            cfmpricetaxbase = confirmloctax.add(confirmlocamt);
        }

        public BigDecimal getConfirmtax() {
            return confirmtax;
        }

        public BigDecimal getConfirmloctax() {
            return confirmloctax;
        }

        public BigDecimal getCfmpricetax() {
            return cfmpricetax;
        }

        public BigDecimal getCfmpricetaxbase() {
            return cfmpricetaxbase;
        }

        static {
            taxrate = BigDecimal.ZERO;
            confirmtax = BigDecimal.ZERO;
            confirmloctax = BigDecimal.ZERO;
            exchangerate = BigDecimal.ZERO;
            cfmpricetax = BigDecimal.ZERO;
            cfmpricetaxbase = BigDecimal.ZERO;
            confirmamt = BigDecimal.ZERO;
            confirmlocamt = BigDecimal.ZERO;
            localCurrencyPrecison = 0;
        }
    }

    static class RevcfmUpParam {
        Long taxrateid;
        BigDecimal taxrate;

        public RevcfmUpParam(Long taxrateid, BigDecimal taxrate) {
            this.taxrateid = taxrateid;
            this.taxrate = taxrate;
        }

        public Long getTaxrateid() {
            return this.taxrateid;
        }

        public BigDecimal getTaxrate() {
            return this.taxrate;
        }

        public boolean isEmpty() {
            return ObjectUtils.isEmpty((Object)this.taxrateid) || ObjectUtils.isEmpty((Object)this.taxrate);
        }
    }
}

