/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.enums.AccrualMethodEnum;
import kd.fi.ar.validator.info.AccrualSchemeEntry;
import kd.fi.ar.validator.info.ComposeKey;
import kd.fi.ar.validator.info.IntervalComparator;
import kd.fi.ar.validator.info.IntervalInfo;
import org.apache.commons.collections.ListUtils;

public class AccrualSchemeUniqueValidator
extends AbstractValidator {
    public static final String RANGE_ALL = "whole";

    public static final String RANGE_DAY() {
        return ResManager.loadKDString((String)"\u5929", (String)"AccrualSchemeUniqueValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]);
    }

    public static final String RANGE_OVER() {
        return ResManager.loadKDString((String)"\u5929\u4ee5\u4e0a", (String)"AccrualSchemeUniqueValidator_13", (String)"fi-ar-opplugin", (Object[])new Object[0]);
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String dynMsg;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection policyentrys = info.getDynamicObjectCollection("policyentry");
            if (ObjectUtils.isEmpty((Object)policyentrys)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u201c\u9002\u7528\u5e94\u6536\u653f\u7b56\u201d\u3002", (String)"AccrualSchemeUniqueValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection mapEntrys = info.getDynamicObjectCollection("fieldmapentry");
            String method = info.getString("accrualmethod");
            if (ObjectUtils.isEmpty((Object)entrys)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u201c\u8ba1\u63d0\u65b9\u6848\u201d\u3002", (String)"AccrualSchemeUniqueValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            } else if (AccrualMethodEnum.acctAgeAnalysis.name().equals(method)) {
                for (DynamicObject entry : entrys) {
                    int days = entry.getInt("days");
                    int enddays = entry.getInt("enddays");
                    if (entry.getBoolean("isabove") || days != enddays) continue;
                    String v = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u7b2c%s\u884c\u201c\u8d77\u59cb\u5929\u6570\u201d\u5b57\u6bb5\u3002", (String)"AccrualSchemeUniqueValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getInt("seq"));
                    this.addMessage(dataEntity, v);
                }
                int count = entrys.size();
                if (count > 1) {
                    for (int i = 0; i < count - 1; ++i) {
                        DynamicObject current = (DynamicObject)entrys.get(i);
                        current.getInt("enddays");
                        for (int j = i + 1; j < count; ++j) {
                            DynamicObject next = (DynamicObject)entrys.get(j);
                            if ((current.getInt("enddays") == 0 || current.getInt("enddays") != next.getInt("days")) && (current.getInt("days") == 0 || current.getInt("days") != next.getInt("enddays"))) continue;
                            List<AccrualSchemeEntry> entryInfos = this.convertEntryInfo(method, entrys, mapEntrys);
                            List<Map<IntervalInfo, List<AccrualSchemeEntry>>> dupList = this.getAcctAgeDupList(entryInfos);
                            if (!ObjectUtils.isEmpty((Object)mapEntrys)) continue;
                            this.chkSourceType(dataEntity, dupList);
                            if (this.validateResult.getAllErrorInfo().isEmpty()) continue;
                            this.validateResult.getAllErrorInfo().clear();
                            int days = current.getInt("days") == next.getInt("enddays") ? current.getInt("days") : current.getInt("enddays");
                            String v = String.format(ResManager.loadKDString((String)"\u201c\u533a\u95f4\u201d\u8fb9\u754c\u503c\u91cd\u590d\uff1a\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\uff0c\u91cd\u590d\u503c\u662f\uff1a%3$s", (String)"AccrualSchemeUniqueValidator_14", (String)"fi-ar-opplugin", (Object[])new Object[0]), current.getInt("seq"), next.getInt("seq"), days);
                            this.addMessage(dataEntity, v);
                        }
                    }
                }
            }
            if (!this.validateResult.getAllErrorInfo().isEmpty()) {
                return;
            }
            if (entrys.size() <= 1) continue;
            List<AccrualSchemeEntry> entryInfos = this.convertEntryInfo(method, entrys, mapEntrys);
            if (!AccrualMethodEnum.acctAgeAnalysis.name().equals(method)) {
                List<AccrualSchemeEntry> maybeDupRows = this.getMaybeDupRows(entryInfos);
                if (maybeDupRows == null || maybeDupRows.isEmpty()) continue;
                Map<String, List<AccrualSchemeEntry>> rangeMap = this.getRangeMap(maybeDupRows);
                if (ObjectUtils.isEmpty((Object)mapEntrys)) {
                    this.chkSourceType(dataEntity, rangeMap);
                    continue;
                }
                Map<ComposeKey, List<AccrualSchemeEntry>> composeMap = this.getComposeMap(rangeMap);
                dynMsg = this.chkDynColumn(dataEntity, composeMap, false);
                if (ObjectUtils.isEmpty((Object)dynMsg) && mapEntrys.size() <= 1) continue;
            }
            List<Map<IntervalInfo, List<AccrualSchemeEntry>>> dupList = this.getAcctAgeDupList(entryInfos);
            if (ObjectUtils.isEmpty(dupList)) continue;
            if (ObjectUtils.isEmpty((Object)mapEntrys)) {
                this.chkSourceType(dataEntity, dupList);
                continue;
            }
            Map<String, List<AccrualSchemeEntry>> rangeMap = this.getIntervalRangeMap(dupList);
            Map<ComposeKey, List<AccrualSchemeEntry>> composeMap = this.getComposeMap(rangeMap);
            dynMsg = this.chkDynColumn(dataEntity, composeMap, false);
            if (ObjectUtils.isEmpty((Object)dynMsg) && mapEntrys.size() <= 1) continue;
        }
    }

    private Map<ComposeKey, List<AccrualSchemeEntry>> getComposeMap(Map<String, List<AccrualSchemeEntry>> rangeMap) {
        LinkedHashMap<ComposeKey, List<AccrualSchemeEntry>> composeMap = new LinkedHashMap<ComposeKey, List<AccrualSchemeEntry>>(64);
        for (Map.Entry<String, List<AccrualSchemeEntry>> entry : rangeMap.entrySet()) {
            List<Long> mergePks;
            List<AccrualSchemeEntry> rangeList = entry.getValue();
            ComposeKey composeKey = null;
            composeKey = rangeList.size() > 1 ? ((mergePks = this.getMergeSourceType(rangeList)).isEmpty() ? new ComposeKey(entry.getKey(), mergePks, !this.containEmpty(rangeList)) : new ComposeKey(entry.getKey(), mergePks, false)) : new ComposeKey(entry.getKey(), rangeList.get(0).getSourceType(), false);
            ArrayList<AccrualSchemeEntry> rowList = (ArrayList<AccrualSchemeEntry>)composeMap.get(composeKey);
            if (rowList == null) {
                rowList = new ArrayList<AccrualSchemeEntry>();
            }
            rowList.addAll(rangeList);
            composeMap.put(composeKey, rowList);
        }
        return composeMap;
    }

    private boolean containEmpty(List<AccrualSchemeEntry> rangeList) {
        boolean containEmpty = false;
        List<List<Long>> distinct = this.getDistinctSourceType(rangeList);
        for (List<Long> pks : distinct) {
            if (!pks.isEmpty()) continue;
            containEmpty = true;
            break;
        }
        return containEmpty;
    }

    private List<Long> getMergeSourceType(List<AccrualSchemeEntry> rangeList) {
        List<List<Long>> distinct = this.getDistinctSourceType(rangeList);
        Collections.sort(distinct, new Comparator<List<Long>>(){

            @Override
            public int compare(List<Long> o1, List<Long> o2) {
                if (o1.size() < o2.size()) {
                    return 1;
                }
                if (o1.size() == o2.size()) {
                    return 0;
                }
                return -1;
            }
        });
        List mergePks = distinct.get(0);
        if (distinct.size() > 1) {
            for (int i = 1; i < distinct.size(); ++i) {
                List<Long> nextPks = distinct.get(i);
                if (nextPks.isEmpty()) continue;
                mergePks = ListUtils.intersection(mergePks, nextPks);
            }
        }
        return mergePks;
    }

    private List<List<Long>> getDistinctSourceType(List<AccrualSchemeEntry> rangeList) {
        ArrayList<List<Long>> distinct = new ArrayList<List<Long>>();
        for (AccrualSchemeEntry row : rangeList) {
            List<Long> st = row.getSourceType();
            if (distinct.contains(st)) continue;
            distinct.add(st);
        }
        return distinct;
    }

    private void chkSourceType(ExtendedDataEntity dataEntity, Map<String, List<AccrualSchemeEntry>> rangeMap) {
        StringBuffer sb = new StringBuffer();
        LinkedHashMap<String, List<AccrualSchemeEntry>> singleRangeMap = new LinkedHashMap<String, List<AccrualSchemeEntry>>();
        boolean isAll = false;
        for (Map.Entry<String, List<AccrualSchemeEntry>> entry : rangeMap.entrySet()) {
            List<AccrualSchemeEntry> dulList;
            if (RANGE_ALL.equals(entry.getKey())) {
                isAll = true;
            }
            if ((dulList = entry.getValue()).size() > 1) {
                sb = this.dupColumn(dataEntity, dulList, entry.getKey(), sb);
                continue;
            }
            if (RANGE_ALL.equals(entry.getKey())) continue;
            singleRangeMap.put(entry.getKey(), dulList);
        }
        if (ObjectUtils.isEmpty((Object)sb) && isAll && !singleRangeMap.isEmpty()) {
            List<AccrualSchemeEntry> wholeList = rangeMap.get(RANGE_ALL);
            for (Map.Entry entry : singleRangeMap.entrySet()) {
                ArrayList<AccrualSchemeEntry> dulList = new ArrayList<AccrualSchemeEntry>();
                dulList.addAll(wholeList);
                dulList.addAll((Collection)entry.getValue());
                this.dupColumn(dataEntity, dulList, (String)entry.getKey(), sb);
            }
        }
    }

    private String chkDynColumn(ExtendedDataEntity dataEntity, Map<ComposeKey, List<AccrualSchemeEntry>> composeMap, boolean isUnion) {
        StringBuffer sb = new StringBuffer();
        LinkedHashMap<ComposeKey, List<AccrualSchemeEntry>> singleRangeMap = new LinkedHashMap<ComposeKey, List<AccrualSchemeEntry>>();
        ComposeKey wholeKey = null;
        for (Map.Entry<ComposeKey, List<AccrualSchemeEntry>> entry : composeMap.entrySet()) {
            List<AccrualSchemeEntry> dulList = composeMap.get(entry.getKey());
            if (RANGE_ALL.equals(entry.getKey().getRange())) {
                wholeKey = entry.getKey();
            }
            if (dulList.size() > 1) {
                if (isUnion) {
                    sb = this.dupUnion(dataEntity, dulList, entry.getKey(), sb);
                    continue;
                }
                sb = this.dupDynColumn(dataEntity, dulList, entry.getKey(), sb);
                continue;
            }
            if (RANGE_ALL.equals(entry.getKey().getRange())) continue;
            singleRangeMap.put(entry.getKey(), dulList);
        }
        if (ObjectUtils.isEmpty((Object)sb) && wholeKey != null && !singleRangeMap.isEmpty()) {
            List<AccrualSchemeEntry> wholeList = composeMap.get(wholeKey);
            for (Map.Entry entry : singleRangeMap.entrySet()) {
                List<Long> singlePks = ((ComposeKey)entry.getKey()).getSourceType();
                for (AccrualSchemeEntry wholeRow : wholeList) {
                    List<Long> wholePks = wholeRow.getSourceType();
                    List<Long> mergePks = null;
                    mergePks = !wholePks.isEmpty() && singlePks.isEmpty() || wholePks.isEmpty() && !singlePks.isEmpty() ? (wholePks.isEmpty() ? singlePks : wholePks) : ListUtils.intersection(wholePks, singlePks);
                    ArrayList<AccrualSchemeEntry> dulList = new ArrayList<AccrualSchemeEntry>();
                    dulList.add(wholeRow);
                    dulList.addAll((Collection)singleRangeMap.get(entry.getKey()));
                    ComposeKey unionKey = null;
                    unionKey = mergePks.isEmpty() ? new ComposeKey(((ComposeKey)entry.getKey()).getRange(), mergePks, !this.containEmpty(dulList)) : new ComposeKey(((ComposeKey)entry.getKey()).getRange(), mergePks, false);
                    if (isUnion) {
                        sb = this.dupUnion(dataEntity, dulList, unionKey, sb);
                        continue;
                    }
                    sb = this.dupDynColumn(dataEntity, dulList, unionKey, sb);
                }
            }
        }
        return sb != null ? sb.toString() : null;
    }

    private Map<String, List<AccrualSchemeEntry>> getRangeMap(List<AccrualSchemeEntry> maybeDupRows) {
        LinkedHashMap<String, List<AccrualSchemeEntry>> dulMap = new LinkedHashMap<String, List<AccrualSchemeEntry>>(maybeDupRows.size());
        for (AccrualSchemeEntry dupRow : maybeDupRows) {
            String key = dupRow.getRange();
            ArrayList<AccrualSchemeEntry> dulList = (ArrayList<AccrualSchemeEntry>)dulMap.get(key);
            if (dulList == null) {
                dulList = new ArrayList<AccrualSchemeEntry>();
            }
            dulList.add(dupRow);
            dulMap.put(key, dulList);
        }
        return dulMap;
    }

    private StringBuffer dupColumn(ExtendedDataEntity dataEntity, List<AccrualSchemeEntry> dulList, String range, StringBuffer sb) {
        for (int i = 0; i < dulList.size() - 1; ++i) {
            AccrualSchemeEntry temp = dulList.get(i);
            for (int j = i + 1; j < dulList.size(); ++j) {
                AccrualSchemeEntry entryInfo = dulList.get(j);
                sb = this.dul4SourceType(dataEntity, range, temp, entryInfo, sb);
            }
        }
        return sb;
    }

    private StringBuffer dupDynColumn(ExtendedDataEntity dataEntity, List<AccrualSchemeEntry> dulList, ComposeKey composeKey, StringBuffer sb) {
        boolean flag = false;
        if (composeKey.getSourceType().isEmpty() && !composeKey.isMutex()) {
            ArrayList<AccrualSchemeEntry> blankList = new ArrayList<AccrualSchemeEntry>();
            ArrayList<AccrualSchemeEntry> mutexList = new ArrayList<AccrualSchemeEntry>();
            for (AccrualSchemeEntry dulRow : dulList) {
                if (dulRow.getSourceType().isEmpty()) {
                    blankList.add(dulRow);
                    continue;
                }
                mutexList.add(dulRow);
            }
            if (mutexList.isEmpty()) {
                flag = true;
            } else {
                for (AccrualSchemeEntry blankRow : blankList) {
                    for (AccrualSchemeEntry mutexRow : mutexList) {
                        ComposeKey newKey = new ComposeKey(composeKey.getRange(), mutexRow.getSourceType(), false);
                        sb = this.dul4DynColumn(dataEntity, newKey, blankRow, mutexRow, sb);
                    }
                }
            }
        } else {
            flag = true;
        }
        if (flag) {
            for (int i = 0; i < dulList.size() - 1; ++i) {
                AccrualSchemeEntry temp = dulList.get(i);
                for (int j = i + 1; j < dulList.size(); ++j) {
                    AccrualSchemeEntry next = dulList.get(j);
                    if (temp.getDynList() == null || next.getDynList() == null || composeKey.isMutex()) continue;
                    sb = this.dul4DynColumn(dataEntity, composeKey, temp, next, sb);
                }
            }
        }
        return sb;
    }

    private StringBuffer dul4DynColumn(ExtendedDataEntity dataEntity, ComposeKey composeKey, AccrualSchemeEntry temp, AccrualSchemeEntry next, StringBuffer sb) {
        List subtract = ListUtils.subtract(temp.getUnionList(), next.getUnionList());
        for (Map<String, List<Long>> tmpMap : temp.getDynList()) {
            for (Map.Entry<String, List<Long>> entry : tmpMap.entrySet()) {
                List<Long> tmpPks = tmpMap.get(entry.getKey());
                for (Map<String, List<Long>> nextMap : next.getDynList()) {
                    List commonList;
                    List<Long> nextPks = nextMap.get(entry.getKey());
                    if (nextPks == null) continue;
                    if (tmpPks.isEmpty() && nextPks.isEmpty() && subtract.isEmpty()) {
                        String msg = this.getComposeMsg(composeKey, entry.getKey(), temp.getSeqNo(), next.getSeqNo(), "");
                        sb.append(msg).append('\n');
                        this.addMessage(dataEntity, msg);
                    }
                    if (tmpPks.isEmpty() || nextPks.isEmpty() || (commonList = ListUtils.intersection(tmpPks, nextPks)).isEmpty()) continue;
                    String value = this.getBasedataName(entry.getKey(), commonList);
                    String msg = this.getComposeMsg(composeKey, entry.getKey(), temp.getSeqNo(), next.getSeqNo(), value);
                    sb.append(msg).append('\n');
                    this.addMessage(dataEntity, msg);
                }
            }
        }
        return sb;
    }

    private StringBuffer dupUnion(ExtendedDataEntity dataEntity, List<AccrualSchemeEntry> dulList, ComposeKey composeKey, StringBuffer sb) {
        for (int i = 0; i < dulList.size() - 1; ++i) {
            AccrualSchemeEntry temp = dulList.get(i);
            for (int j = i + 1; j < dulList.size(); ++j) {
                AccrualSchemeEntry next = dulList.get(j);
                if (temp.getDynList() == null || composeKey.isMutex()) continue;
                sb = this.dulUnionColumn(dataEntity, composeKey, temp, next, sb);
            }
        }
        return sb;
    }

    private StringBuffer dulUnionColumn(ExtendedDataEntity dataEntity, ComposeKey composeKey, AccrualSchemeEntry temp, AccrualSchemeEntry entryInfo, StringBuffer sb) {
        for (Map<String, List<Long>> nextMap : entryInfo.getDynList()) {
            for (Map.Entry<String, List<Long>> entry : nextMap.entrySet()) {
                List<Long> nextPks = entry.getValue();
                if (nextPks == null || temp.getUnionList().isEmpty() || entryInfo.getUnionList().isEmpty()) continue;
                List commonList = null;
                if ("bd_customer".equals(entry.getKey())) {
                    commonList = ListUtils.intersection(nextPks, temp.getUnionList());
                } else {
                    List<Long> custPks = this.getCustomerPks(nextPks);
                    commonList = ListUtils.intersection(custPks, temp.getUnionList());
                }
                if (commonList.isEmpty()) continue;
                String value = this.getBasedataName("bd_customer", commonList);
                String msg = this.getComposeMsg(composeKey, entry.getKey(), temp.getSeqNo(), entryInfo.getSeqNo(), value);
                sb.append(msg).append('\n');
                this.addMessage(dataEntity, msg);
            }
        }
        return sb;
    }

    private StringBuffer dul4SourceType(ExtendedDataEntity dataEntity, String range, AccrualSchemeEntry temp, AccrualSchemeEntry entryInfo, StringBuffer sb) {
        List commonList;
        String msg;
        String value;
        if (temp.getSourceType().isEmpty() && entryInfo.getSourceType().isEmpty()) {
            String msg2 = this.getMessage(range, "ar_sourcetype", temp.getSeqNo(), entryInfo.getSeqNo(), "");
            sb.append(msg2).append('\n');
            this.addMessage(dataEntity, msg2);
        }
        if (!temp.getSourceType().isEmpty() && entryInfo.getSourceType().isEmpty()) {
            value = this.getBasedataName("ar_sourcetype", temp.getSourceType());
            msg = this.getMessage(range, "ar_sourcetype", temp.getSeqNo(), entryInfo.getSeqNo(), value);
            sb.append(msg).append('\n');
            this.addMessage(dataEntity, msg);
        }
        if (temp.getSourceType().isEmpty() && !entryInfo.getSourceType().isEmpty()) {
            value = this.getBasedataName("ar_sourcetype", entryInfo.getSourceType());
            msg = this.getMessage(range, "ar_sourcetype", temp.getSeqNo(), entryInfo.getSeqNo(), value);
            sb.append(msg).append('\n');
            this.addMessage(dataEntity, msg);
        }
        if (!(temp.getSourceType().isEmpty() || entryInfo.getSourceType().isEmpty() || (commonList = ListUtils.intersection(temp.getSourceType(), entryInfo.getSourceType())).isEmpty())) {
            String value2 = this.getBasedataName("ar_sourcetype", commonList);
            String msg3 = this.getMessage(range, "ar_sourcetype", temp.getSeqNo(), entryInfo.getSeqNo(), value2);
            sb.append(msg3).append('\n');
            this.addMessage(dataEntity, msg3);
        }
        return sb;
    }

    private String getMessage(String range, String entityKey, int row1, int row2, String dupValue) {
        String entityName = null;
        entityName = "ar_sourcetype".equals(entityKey) ? ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b", (String)"AccrualSchemeUniqueValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]) : ("bd_customer".equals(entityKey) ? ResManager.loadKDString((String)"\u5ba2\u6237", (String)"AccrualSchemeUniqueValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7ec4", (String)"AccrualSchemeUniqueValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        dupValue = ObjectUtils.isEmpty((Object)dupValue) ? ResManager.loadKDString((String)"\u7a7a", (String)"AccrualSchemeUniqueValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]) : dupValue;
        String msg = String.format(ResManager.loadKDString((String)"\u201c\u533a\u95f4\u201d\u503c\u4e3a\u201c%1$s\u201d\u7684%2$s\u503c\u91cd\u590d\uff1a\u7b2c%3$s\u884c\u548c\u7b2c%4$s\u884c\uff0c\u91cd\u590d\u503c\u662f\uff1a%5$s\u3002", (String)"AccrualSchemeUniqueValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]), BaddebtHelper.getRangeValue((String)range), entityName, row1, row2, dupValue);
        return msg;
    }

    private String getComposeMsg(ComposeKey composeKey, String entityKey, int row1, int row2, String dupValue) {
        String entityName = null;
        entityName = "bd_customer".equals(entityKey) ? ResManager.loadKDString((String)"\u5ba2\u6237", (String)"AccrualSchemeUniqueValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7ec4", (String)"AccrualSchemeUniqueValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]);
        dupValue = ObjectUtils.isEmpty((Object)dupValue) ? ResManager.loadKDString((String)"\u7a7a", (String)"AccrualSchemeUniqueValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]) : dupValue;
        List<Long> sourceTypePks = composeKey.getSourceType();
        String stValue = null;
        stValue = sourceTypePks.isEmpty() ? ResManager.loadKDString((String)"\u7a7a", (String)"AccrualSchemeUniqueValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]) : this.getBasedataName("ar_sourcetype", sourceTypePks);
        String msg = String.format(ResManager.loadKDString((String)"\u201c\u533a\u95f4\u201d\u503c\u4e3a\u201c%1$s\u201d\u4e14\u201c\u6765\u6e90\u7c7b\u578b\u201d\u4e3a\u201c%2$s\u201d\u7684%3$s\u503c\u91cd\u590d\uff1a\u7b2c%4$s\u884c\u548c\u7b2c%5$s\u884c\uff0c\u91cd\u590d\u503c\u662f\uff1a%6$s\u3002", (String)"AccrualSchemeUniqueValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]), BaddebtHelper.getRangeValue((String)composeKey.getRange()), stValue, entityName, row1, row2, dupValue);
        return msg;
    }

    private String getBasedataName(String entityKey, List<Long> pks) {
        StringBuilder sb = new StringBuilder();
        Object[] objs = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityKey));
        if (!ObjectUtils.isEmpty((Object[])objs)) {
            if (objs.length == 1) {
                sb.append(objs[0].getLocaleString("name").getLocaleValue());
            } else {
                for (int i = 0; i < objs.length; ++i) {
                    Object obj = objs[i];
                    sb.append(obj.getLocaleString("name").getLocaleValue());
                    if (i >= objs.length - 1) continue;
                    sb.append(", ");
                }
            }
        }
        return sb.toString();
    }

    private List<AccrualSchemeEntry> convertEntryInfo(String method, DynamicObjectCollection entrys, DynamicObjectCollection mapEntrys) {
        ArrayList<AccrualSchemeEntry> entryInfoList = new ArrayList<AccrualSchemeEntry>();
        for (DynamicObject entry : entrys) {
            AccrualSchemeEntry entryInfo = new AccrualSchemeEntry();
            int seqNo = entry.getInt("seq");
            entryInfo.setSeqNo(seqNo);
            entryInfo.setRange(entry.getString("range"));
            ArrayList<Long> sourceTypef7 = new ArrayList<Long>();
            DynamicObjectCollection sourceTypeColl = entry.getDynamicObjectCollection("mulbdfactor2");
            for (DynamicObject mulbd : sourceTypeColl) {
                sourceTypef7.add(mulbd.getLong("fbasedataid_id"));
            }
            entryInfo.setSourceType(sourceTypef7);
            if (!mapEntrys.isEmpty()) {
                ArrayList<Map<String, List<Long>>> dynList = new ArrayList<Map<String, List<Long>>>(mapEntrys.size());
                Iterator iterator = mapEntrys.iterator();
                while (iterator.hasNext()) {
                    TreeMap map = new TreeMap();
                    DynamicObject mapEntry = (DynamicObject)iterator.next();
                    String key = mapEntry.getString("entityid");
                    ArrayList<Long> mulPks = (ArrayList<Long>)map.get(key);
                    if (mulPks == null) {
                        mulPks = new ArrayList<Long>();
                    }
                    String fieldKey = mapEntry.getString("fieldkey");
                    DynamicObjectCollection mulbds = entry.getDynamicObjectCollection(fieldKey);
                    for (DynamicObject mulbd : mulbds) {
                        mulPks.add(mulbd.getLong("fbasedataid_id"));
                    }
                    map.put(key, mulPks);
                    dynList.add(map);
                }
                entryInfo.setDynList(dynList);
                entryInfo.setUnionList(this.getUnionList(dynList));
            }
            entryInfoList.add(entryInfo);
            if (!AccrualMethodEnum.acctAgeAnalysis.name().equals(method)) continue;
            entryInfo.setDays(entry.getInt("days"));
            entryInfo.setAbove(entry.getBoolean("isabove"));
            if (entry.getBoolean("isabove")) continue;
            entryInfo.setEndDays(entry.getInt("enddays"));
        }
        return entryInfoList;
    }

    private List<Long> getUnionList(List<Map<String, List<Long>>> dynList) {
        ArrayList<Long> unionPks = new ArrayList<Long>(64);
        ArrayList<Long> groupPks = new ArrayList<Long>(64);
        for (Map<String, List<Long>> map : dynList) {
            for (Map.Entry<String, List<Long>> entry : map.entrySet()) {
                groupPks.clear();
                List<Long> mulPks = entry.getValue();
                if (mulPks != null && mulPks.size() > 0) {
                    if ("bd_customer".equals(entry.getKey())) {
                        unionPks.addAll(mulPks);
                        continue;
                    }
                    unionPks.addAll(this.getCustomerPks(mulPks));
                    continue;
                }
                if ("bd_customer".equals(entry.getKey())) {
                    Map customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id", null);
                    for (Map.Entry keySet : customerMap.entrySet()) {
                        DynamicObject customer = (DynamicObject)keySet.getValue();
                        unionPks.add(customer.getLong("id"));
                    }
                    continue;
                }
                Map groupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroup", (String)"id", null);
                for (Map.Entry keySet : groupMap.entrySet()) {
                    DynamicObject group = (DynamicObject)keySet.getValue();
                    groupPks.add(group.getLong("id"));
                }
                if (groupPks.size() <= 0) continue;
                unionPks.addAll(this.getCustomerPks(mulPks));
            }
        }
        return unionPks;
    }

    private List<Long> getCustomerPks(List<Long> groupPks) {
        QFilter qFilter = new QFilter("group", "in", groupPks);
        Map customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> custPks = new ArrayList<Long>(customerMap.size());
        for (Map.Entry keySet : customerMap.entrySet()) {
            DynamicObject customer = (DynamicObject)keySet.getValue();
            custPks.add(customer.getLong("id"));
        }
        return custPks;
    }

    private List<AccrualSchemeEntry> getMaybeDupRows(List<AccrualSchemeEntry> entryInfos) {
        String range;
        ArrayList<AccrualSchemeEntry> maybeDupRows = null;
        HashSet<String> rangeSet = new HashSet<String>(entryInfos.size());
        ArrayList<String> rangeList = new ArrayList<String>(entryInfos.size());
        for (AccrualSchemeEntry entryInfo : entryInfos) {
            range = entryInfo.getRange();
            if (rangeSet.add(range) || rangeList.contains(range)) continue;
            rangeList.add(range);
        }
        if (rangeSet.size() > 1) {
            if (rangeList.contains(RANGE_ALL)) {
                rangeSet.remove(RANGE_ALL);
            }
            for (String range2 : rangeSet) {
                if (rangeList.contains(range2)) continue;
                rangeList.add(range2);
            }
        }
        if (!rangeList.isEmpty()) {
            maybeDupRows = new ArrayList<AccrualSchemeEntry>();
            for (AccrualSchemeEntry entryInfo : entryInfos) {
                range = entryInfo.getRange();
                for (String dupRange : rangeList) {
                    if (!range.equals(dupRange)) continue;
                    maybeDupRows.add(entryInfo);
                }
            }
        }
        return maybeDupRows;
    }

    private List<Map<IntervalInfo, List<AccrualSchemeEntry>>> getAcctAgeDupList(List<AccrualSchemeEntry> entryInfos) {
        ArrayList dupList = null;
        ArrayList<IntervalInfo> entries = new ArrayList<IntervalInfo>(entryInfos.size());
        for (AccrualSchemeEntry entryInfo : entryInfos) {
            IntervalInfo c = new IntervalInfo(entryInfo.getDays(), entryInfo.getEndDays(), entryInfo.isAbove());
            entries.add(c);
        }
        ArrayList<IntervalInfo> intersections = new ArrayList<IntervalInfo>();
        IntervalComparator.getIntersection(entries, intersections);
        if (!intersections.isEmpty()) {
            dupList = new ArrayList();
            for (IntervalInfo intersection : intersections) {
                ArrayList<AccrualSchemeEntry> dupRows = null;
                for (AccrualSchemeEntry entryInfo : entryInfos) {
                    IntervalInfo interval = new IntervalInfo(entryInfo.getDays(), entryInfo.getEndDays(), entryInfo.isAbove());
                    if (!IntervalComparator.contain(interval, intersection)) continue;
                    if (dupRows == null) {
                        dupRows = new ArrayList<AccrualSchemeEntry>();
                    }
                    dupRows.add(entryInfo);
                }
                if (dupRows == null) continue;
                HashMap intersectMap = new HashMap();
                intersectMap.put(intersection, dupRows);
                dupList.add(intersectMap);
            }
        }
        return dupList;
    }

    private void chkSourceType(ExtendedDataEntity dataEntity, List<Map<IntervalInfo, List<AccrualSchemeEntry>>> dupList) {
        StringBuffer sb = new StringBuffer();
        for (Map<IntervalInfo, List<AccrualSchemeEntry>> intersectMap : dupList) {
            for (Map.Entry<IntervalInfo, List<AccrualSchemeEntry>> entry : intersectMap.entrySet()) {
                List<AccrualSchemeEntry> dulRows = entry.getValue();
                String range = entry.getKey().isIsabove() ? entry.getKey().getStart() + AccrualSchemeUniqueValidator.RANGE_OVER() : entry.getKey().getStart() + "-" + entry.getKey().getEnd() + AccrualSchemeUniqueValidator.RANGE_DAY();
                this.dupColumn(dataEntity, dulRows, range, sb);
            }
        }
    }

    private Map<String, List<AccrualSchemeEntry>> getIntervalRangeMap(List<Map<IntervalInfo, List<AccrualSchemeEntry>>> dupList) {
        LinkedHashMap<String, List<AccrualSchemeEntry>> rangeMap = new LinkedHashMap<String, List<AccrualSchemeEntry>>();
        for (Map<IntervalInfo, List<AccrualSchemeEntry>> intersectMap : dupList) {
            for (Map.Entry<IntervalInfo, List<AccrualSchemeEntry>> entry : intersectMap.entrySet()) {
                List<AccrualSchemeEntry> dulRows = entry.getValue();
                String key = entry.getKey().isIsabove() ? entry.getKey().getStart() + AccrualSchemeUniqueValidator.RANGE_OVER() : entry.getKey().getStart() + "-" + entry.getKey().getEnd() + AccrualSchemeUniqueValidator.RANGE_DAY();
                rangeMap.put(key, dulRows);
            }
        }
        return rangeMap;
    }
}

