/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AccrualSchemeValidator
extends AbstractValidator {
    private static final String Entry = "entryentity";
    private static final String FIELDMAPENTRY = "fieldmapentry";
    private static final String DAYS = "days";
    private static final String SEQ = "seq";
    private static final String ENDDAYS = "enddays";
    private static final String ISABOVE = "isabove";
    private static final String textFilterPrefix = "filtertextfield";
    private static final String baseDataFilterPrefix = "mulbdfactor";
    private List<String> conflictKeys = new ArrayList<String>(0);

    public static final String RANGE_DAY() {
        return ResManager.loadKDString((String)"\u5929", (String)"AccrualSchemeUniqueValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]);
    }

    public static final String RANGE_OVER() {
        return ResManager.loadKDString((String)"\u5929\u4ee5\u4e0a", (String)"AccrualSchemeUniqueValidator_13", (String)"fi-ar-opplugin", (Object[])new Object[0]);
    }

    public static final String ALL() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"AccrualSchemeUniqueValidator_16", (String)"fi-ar-opplugin", (Object[])new Object[0]);
    }

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.validateMustInput(extendedDataEntity);
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection(Entry);
            Map<Integer, DynamicObject> entryMap = entryentity.stream().collect(Collectors.toMap(e -> e.getInt(SEQ), e -> e));
            Map<Tuple<Integer, Integer>, Tuple<Integer, Integer>> conflicts = this.validateDaysConflict(dataEntity);
            if (!EmptyUtils.isNotEmpty(conflicts)) continue;
            Set<Map.Entry<Tuple<Integer, Integer>, Tuple<Integer, Integer>>> entrySet = conflicts.entrySet();
            for (Map.Entry<Tuple<Integer, Integer>, Tuple<Integer, Integer>> kv : entrySet) {
                Map<String, List<String>> entryConflicts;
                DynamicObject entry2;
                Integer rowIndex1 = (Integer)kv.getKey().item1;
                Integer rowIndex2 = (Integer)kv.getKey().item2;
                DynamicObject entry1 = entryMap.get(rowIndex1);
                List<String> sourceConflicts = this.checkBaseDataConflict(entry1, entry2 = entryMap.get(rowIndex2), "accrualsource");
                if (sourceConflicts == null || (entryConflicts = this.checkConflict(entry1, entry2, dataEntity)).size() != this.conflictKeys.size()) continue;
                String message = ResManager.loadKDString((String)"\u201c\u533a\u95f4\u201d\u4e3a\u201c%1$s\u201d\u4e14\u201c\u6765\u6e90\u7c7b\u578b\u201d\u4e3a\u201c%2$s\u201d\u7684%3$s\u503c\u91cd\u590d\uff1a\u7b2c%4$s\u884c\u548c\u7b2c%5$s\u884c\uff0c\u91cd\u590d\u503c\uff1a%6$s\uff1b", (String)"AccrualSchemeValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]);
                String range = kv.getValue().item2 == null ? kv.getValue().item1 + AccrualSchemeValidator.RANGE_OVER() : kv.getValue().item1 + "-" + kv.getValue().item2 + AccrualSchemeValidator.RANGE_DAY();
                for (Map.Entry<String, List<String>> conflictKV : entryConflicts.entrySet()) {
                    this.addMessage(extendedDataEntity, String.format(message, range, EmptyUtils.isEmpty(sourceConflicts) ? AccrualSchemeValidator.ALL() : String.join((CharSequence)",", sourceConflicts), conflictKV.getKey(), kv.getKey().item1, kv.getKey().item2, EmptyUtils.isEmpty(conflictKV.getValue()) ? AccrualSchemeValidator.ALL() : String.join((CharSequence)",", (Iterable<? extends CharSequence>)conflictKV.getValue())));
                }
            }
        }
    }

    private void validateMustInput(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(Entry);
        if (ObjectUtils.isEmpty((Object)entrys)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u201c\u8ba1\u63d0\u65b9\u6848\u201d\u3002", (String)"AccrualSchemeUniqueValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject entry : entrys) {
            int days = entry.getInt(DAYS);
            int enddays = entry.getInt(ENDDAYS);
            if (entry.getBoolean(ISABOVE) || days != enddays) continue;
            String v = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u7b2c%s\u884c\u201c\u8d77\u59cb\u5929\u6570\u201d\u5b57\u6bb5\u3002", (String)"AccrualSchemeUniqueValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getInt(SEQ));
            this.addMessage(extendedDataEntity, v);
        }
    }

    private Map<String, List<String>> checkConflict(DynamicObject entry1, DynamicObject entry2, DynamicObject dataEntity) {
        HashMap<String, List<String>> conflicts = new HashMap<String, List<String>>(64);
        DynamicObjectCollection fieldMapEntry = dataEntity.getDynamicObjectCollection(FIELDMAPENTRY);
        for (DynamicObject fieldEntry : fieldMapEntry) {
            String fieldKey = fieldEntry.getString("fieldkey");
            String fieldName = fieldEntry.getString("fieldname");
            if (fieldKey.contains(baseDataFilterPrefix)) {
                List<String> baseDataConflicts = this.checkBaseDataConflict(entry1, entry2, fieldKey);
                if (baseDataConflicts != null) {
                    conflicts.put(fieldName, baseDataConflicts);
                }
                this.conflictKeys.add(fieldKey);
            }
            if (!fieldKey.contains(textFilterPrefix)) continue;
            Collection<String> textConflicts = this.checkTextConflict(entry1, entry2, fieldKey);
            if (textConflicts != null) {
                conflicts.put(fieldName, new ArrayList<String>(textConflicts));
            }
            this.conflictKeys.add(fieldKey);
        }
        return conflicts;
    }

    private Collection<String> checkTextConflict(DynamicObject entry1, DynamicObject entry2, String fieldKey) {
        String entry1Value = entry1.getString(fieldKey);
        String entry2Value = entry2.getString(fieldKey);
        List<Object> entry1List = EmptyUtils.isEmpty((Object)entry1Value) ? new ArrayList(0) : Arrays.asList(entry1Value.split(","));
        List<Object> entry2List = EmptyUtils.isEmpty((Object)entry2Value) ? new ArrayList(0) : Arrays.asList(entry2Value.split(","));
        Collection intersection = CollectionUtils.intersection(entry1List, entry2List);
        if (EmptyUtils.isEmpty((Object)entry1Value) || EmptyUtils.isEmpty((Object)entry2Value)) {
            return CollectionUtils.union(entry1List, entry2List);
        }
        return EmptyUtils.isEmpty((Object)intersection) ? null : intersection;
    }

    private List<String> checkBaseDataConflict(DynamicObject entry1, DynamicObject entry2, String fieldKey) {
        DynamicObjectCollection entry1Value = entry1.getDynamicObjectCollection(fieldKey);
        DynamicObjectCollection entry2Value = entry2.getDynamicObjectCollection(fieldKey);
        List conflictName = null;
        List idList1 = DynamicObjectHelper.getIdList4MultiBase((DynamicObjectCollection)entry1Value);
        List idList2 = DynamicObjectHelper.getIdList4MultiBase((DynamicObjectCollection)entry2Value);
        Collection intersection = CollectionUtils.intersection((Iterable)idList1, (Iterable)idList2);
        if (EmptyUtils.isEmpty((Object)entry1Value) || EmptyUtils.isEmpty((Object)entry2Value)) {
            Collection union = CollectionUtils.union((Iterable)entry1Value, (Iterable)entry2Value);
            List<String> collect = union.stream().map(e -> e.getDynamicObject("fbasedataid").getString("name")).distinct().collect(Collectors.toList());
            return collect;
        }
        if (EmptyUtils.isNotEmpty((Object)intersection)) {
            conflictName = Stream.concat(entry1Value.stream(), entry2Value.stream()).filter(e -> intersection.contains(e.getDynamicObject("fbasedataid").getPkValue())).map(e -> e.getDynamicObject("fbasedataid").getString("name")).distinct().collect(Collectors.toList());
        }
        return conflictName;
    }

    private Map<Tuple<Integer, Integer>, Tuple<Integer, Integer>> validateDaysConflict(DynamicObject dataEntity) {
        HashMap<Tuple<Integer, Integer>, Tuple<Integer, Integer>> conflicts = new HashMap<Tuple<Integer, Integer>, Tuple<Integer, Integer>>(64);
        DynamicObjectCollection entityentry = dataEntity.getDynamicObjectCollection(Entry);
        Map<Integer, DynamicObject> seqMap = entityentry.stream().collect(Collectors.toMap(e -> e.getInt(SEQ), e -> e));
        int size = entityentry.size();
        for (int i = 1; i <= size; ++i) {
            for (int j = i + 1; j <= size; ++j) {
                DynamicObject iObj = seqMap.get(i);
                DynamicObject jObj = seqMap.get(j);
                boolean iIsabove = iObj.getBoolean(ISABOVE);
                boolean jIsabove = jObj.getBoolean(ISABOVE);
                int iDays = iObj.getInt(DAYS);
                int iEnddays = iObj.getInt(ENDDAYS);
                int jDays = jObj.getInt(DAYS);
                int jEnddays = jObj.getInt(ENDDAYS);
                int maxDays = Math.max(iDays, jDays);
                int minEnddays = Math.min(iEnddays, jEnddays);
                if (iIsabove || jIsabove) {
                    Tuple value = null;
                    int maxEnddays = Math.max(iEnddays, jEnddays);
                    if (maxEnddays == 0) {
                        value = Tuple.create((Object)maxDays, null);
                    } else if (maxDays <= maxEnddays) {
                        value = Tuple.create((Object)maxDays, (Object)maxEnddays);
                    }
                    if (value == null) continue;
                    conflicts.put((Tuple<Integer, Integer>)Tuple.create((Object)i, (Object)j), (Tuple<Integer, Integer>)value);
                    continue;
                }
                if (minEnddays < maxDays) continue;
                conflicts.put((Tuple<Integer, Integer>)Tuple.create((Object)i, (Object)j), (Tuple<Integer, Integer>)Tuple.create((Object)maxDays, (Object)minEnddays));
            }
        }
        return conflicts;
    }
}

