/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.validator.validatorService.ArValidatorService;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.ArRevUnVerifyValidatorHelper;

public class ArRevcfmUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        ArrayList<Long> billPks = new ArrayList<Long>(datas.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            billPks.add(bill.getLong("id"));
        }
        QFilter mainFilter = new QFilter("billid", "in", billPks);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", billPks);
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        mainFilter.and(isVoucherFilter);
        asstFilter.and(isVoucherFilter);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])billPks.toArray(), (boolean)true);
        asstFilter.and(commonFilter);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"FinApBillUnAuditValidator", (String)"ar_verifyrecord", (String)"billid,entry.e_billid", (QFilter[])new QFilter[]{mainFilter}, null);
        DataSet asstDataSet = QueryServiceHelper.queryDataSet((String)"FinApBillUnAuditValidator", (String)"ar_verifyrecord", (String)"billid,entry.e_billid", (QFilter[])new QFilter[]{asstFilter}, null);
        DataSet recordDataSet = mainDataSet.union(asstDataSet);
        HashSet<Long> billPksWithRecordsVouchered = new HashSet<Long>();
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>();
        for (Row record : recordDataSet) {
            billPksWithRecordsVouchered.add(record.getLong("billid"));
            billPksWithRecordsVouchered.add(record.getLong("entry.e_billid"));
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject revcfmBill = data.getDataEntity();
            Long billPkId = (Long)data.getBillPkId();
            String sourceBillType = revcfmBill.getString("sourcebilltype");
            long orgPk = revcfmBill.getDynamicObject("org").getLong("id");
            boolean ar005 = false;
            if (!orgMap.containsKey(orgPk)) {
                ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
                orgMap.put(orgPk, ar005);
            } else {
                ar005 = (Boolean)orgMap.get(orgPk);
            }
            if (BillSrcTypeEnum.PARAM.getValue().equals(revcfmBill.getString("billsrctype"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u6536\u5165\u786e\u8ba4\u5355\u3002\u82e5\u9700\u53d6\u6d88\u6536\u5165\u786e\u8ba4\uff0c\u8bf7\u5c06\u4e0a\u6e38\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            } else if (ar005 && "ar_finarbill".equals(sourceBillType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u6536\u5165\u786e\u8ba4\u5355\u3002\u82e5\u9700\u53d6\u6d88\u6536\u5165\u786e\u8ba4\uff0c\u8bf7\u5c06\u4e0a\u6e38\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (!billPksWithRecordsVouchered.contains(billPkId)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        ArValidatorService validatorService = new ArValidatorService();
        for (ExtendedDataEntity bill : this.dataEntities) {
            String errorMessageOther = validatorService.closeAccountValidate(bill, "ar_revcfmbill", "bookdate");
            if ("".equals(errorMessageOther)) continue;
            this.addErrorMessage(bill, errorMessageOther);
        }
        this.arRevUnVerifyValidator(datas, billPks);
        this.writtenOffBillUnAuditValidator(datas);
    }

    private void writtenOffBillUnAuditValidator(ExtendedDataEntity[] datas) {
        Set<String> verifyRelations;
        long billId;
        ArrayList<Long> srcRevBillIds = new ArrayList<Long>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        ArrayList<String> billNos = new ArrayList<String>(16);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            String billsrctype = bill.getString("billsrctype");
            boolean isWrittenOff = bill.getBoolean("iswrittenoff");
            if (!isWrittenOff) continue;
            if (BillSrcTypeEnum.VERIFY.getValue().equals(billsrctype)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e94\u6536\u6536\u5165\u6838\u9500\u81ea\u52a8\u751f\u6210\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            long srcBillId = bill.getLong("sourcebillid");
            if (srcBillId == 0L) continue;
            srcRevBillIds.add(srcBillId);
            orgIds.add(bill.getLong("org.id"));
            billNos.add(bill.getString("billno"));
        }
        if (srcRevBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection revcVrs = QueryServiceHelper.query((String)"ar_revcrm_verifyrecord", (String)"entry.assbillid", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", srcRevBillIds)});
        ArrayList<Long> srcRevToHadWFArBillIds = new ArrayList<Long>(16);
        DynamicObjectCollection srcRevBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", srcRevBillIds), new QFilter("sourcebilltype", "=", (Object)"ar_finarbill")});
        if (srcRevBills.size() > 0) {
            Map<Long, Long> srcRevToFinArIdMap = srcRevBills.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("sourcebillid")));
            Set srcFinArBillIds = srcRevBills.stream().map(v -> v.getLong("sourcebillid")).collect(Collectors.toSet());
            DynamicObjectCollection writtenOffArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinArBillIds), new QFilter("hadwrittenoff", "=", (Object)Boolean.TRUE)});
            if (writtenOffArBills.size() > 0) {
                List wfFinArBillIds = writtenOffArBills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                for (Map.Entry<Long, Long> entrySet : srcRevToFinArIdMap.entrySet()) {
                    Long finArId = entrySet.getValue();
                    if (!wfFinArBillIds.contains(finArId)) continue;
                    srcRevToHadWFArBillIds.add(entrySet.getKey());
                }
            }
        }
        List<Object> sourceArNos = new ArrayList(16);
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
        sourceArNos = finArBills.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        QFilter filterByMain = new QFilter("org", "in", orgIds);
        filterByMain.and(new QFilter("billid", "in", srcRevBillIds));
        DynamicObjectCollection verifyRecordsByMain = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"verifyrelation,billid", (QFilter[])filterByMain.toArray());
        QFilter filterByAsst = new QFilter("org", "in", orgIds);
        filterByAsst.and(new QFilter("entry.e_billid", "in", srcRevBillIds));
        DynamicObjectCollection verifyRecordsByAsst = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"verifyrelation,entry.e_billid", (QFilter[])filterByAsst.toArray());
        HashMap<Long, HashSet<String>> verifyRelationMap = new HashMap<Long, HashSet<String>>();
        if (ObjectUtils.isEmpty((Object)verifyRecordsByMain) && ObjectUtils.isEmpty((Object)verifyRecordsByAsst) && ObjectUtils.isEmpty((Object)revcVrs)) {
            return;
        }
        for (DynamicObject verifyRecord : verifyRecordsByMain) {
            billId = verifyRecord.getLong("billid");
            verifyRelations = (HashSet<String>)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty((Object)verifyRelations)) {
                verifyRelations = new HashSet<String>(16);
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        for (DynamicObject verifyRecord : verifyRecordsByAsst) {
            billId = verifyRecord.getLong("entry.e_billid");
            verifyRelations = (Set)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty(verifyRelations)) {
                verifyRelations = new HashSet(16);
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        Set existArRevVrIds = revcVrs.stream().map(e -> e.getLong("entry.assbillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            long srcBillId = bill.getLong("sourcebillid");
            if (srcBillId == 0L) continue;
            boolean isWrittenOff = bill.getBoolean("iswrittenoff");
            String billNo = bill.getString("billno");
            if (!isWrittenOff) continue;
            if (sourceArNos.contains(billNo)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e94\u6536\u5355\u53d1\u8d77\u7684\u51b2\u9500\uff0c\u8bf7\u5728\u5e94\u6536\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (srcRevToHadWFArBillIds.contains(srcBillId)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u6e38\u5e94\u6536\u5355\u5df2\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            Set verifyRelation = (Set)verifyRelationMap.get(srcBillId);
            if (!ObjectUtils.isEmpty((Object)verifyRelation) && verifyRelation.size() > 1) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u5355\u636e\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (!existArRevVrIds.contains(srcBillId)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u4e0e\u5e94\u6536\u6536\u5165\u6838\u9500\u5355\u636e\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmUnAuditValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void arRevUnVerifyValidator(ExtendedDataEntity[] datas, List<Long> billPks) {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,isvoucher,entry.assbillid,entry.revbillid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", billPks)});
        HashSet<Long> errBillIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            if (ArRevUnVerifyValidatorHelper.unVerifyValidator((DynamicObject)record)) continue;
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                errBillIds.add(entry.getLong("assbillid"));
            }
        }
        String errMessage = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u5185\u5bb9\uff1a1.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u672a\u751f\u6210\u51ed\u8bc1\uff1b2.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u672a\u88ab\u7ea2\u51b2\uff1b3.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u975e\u7ea2\u51b2\u751f\u6210\uff1b4.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7684\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"ArRevcfmUnAuditValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            Long billId = bill.getLong("id");
            if (!errBillIds.contains(billId)) continue;
            this.addErrorMessage(data, errMessage);
        }
    }
}

