/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.errorcode.BaddebtErrorCode;

public class BaddebtResultValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            if ("ar_accrualscheme".equals(info.getDataEntityType().getName())) {
                DynamicObjectCollection policyentrys = info.getDynamicObjectCollection("policyentry");
                ArrayList<Long> policyPks = new ArrayList<Long>();
                for (DynamicObject policyentry : policyentrys) {
                    policyPks.add((Long)policyentry.getDynamicObject("p_policy").getPkValue());
                }
                QFilter qFilter = new QFilter("policyid", "in", policyPks);
                qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
                if (!QueryServiceHelper.exists((String)"ar_baddebtresult", (QFilter[])new QFilter[]{qFilter})) continue;
                String msg = String.format(BaddebtErrorCode.EXISTS_BIZBILL_CANNOT_OPERATION().getMessage(), this.getOperationName());
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            if (!"ar_baddebtreservebill".equals(info.getDataEntityType().getName())) continue;
            QFilter qFilter = new QFilter("org", "=", info.getDynamicObject("org").getPkValue());
            qFilter.and(new QFilter("policytype", "=", info.getDynamicObject("policytype").getPkValue()));
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            if (!QueryServiceHelper.exists((String)"ar_baddebtresult", (QFilter[])new QFilter[]{qFilter})) continue;
            String msg = String.format(BaddebtErrorCode.EXISTS_BIZBILL_CANNOT_OPERATION().getMessage(), this.getOperationName());
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

