/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;

public class BillSubmitSalDeliverBaseQtyValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(4);
        selector.add("entry.e_corebilltype");
        selector.add("entry.corebillid");
        selector.add("entry.corebillentryid");
        selector.add("entry.e_baseunitqty");
        selector.add("billno");
        selector.add("sourcebilltype");
        return selector;
    }

    public void validate() {
        DynamicObjectCollection bills;
        HashSet<Long> corebillIds = new HashSet<Long>(16);
        HashMap<String, BigDecimal> salUpLimitQtyMap = new HashMap<String, BigDecimal>(16);
        String entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashMap<String, BigDecimal> submitedQtyMap = new HashMap<String, BigDecimal>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String sourceBillType = bill.getString("sourcebilltype");
            if ("ar_finarbill".equals(sourceBillType)) continue;
            Long orgId = bill.getLong("org.id");
            orgIds.add(orgId);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if (!"sm_salorder".equals(row.getString("e_corebilltype"))) continue;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryEntryId == 0L) continue;
                corebillIds.add(coreBillId);
                String key = orgId + "_" + coreBillId + "_" + coreBillEntryEntryId;
                BigDecimal baseQty = row.getBigDecimal("e_baseunitqty");
                BigDecimal hadSubmitQty = (BigDecimal)submitedQtyMap.get(key);
                BigDecimal salSubmitQty = hadSubmitQty == null ? baseQty : baseQty.add((BigDecimal)submitedQtyMap.get(key));
                submitedQtyMap.put(key, salSubmitQty);
            }
        }
        if (corebillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection salOrders = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billentry.entrysettleorg,billentry.deliverbaseqtyup,billentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", corebillIds)});
        for (DynamicObject salBill : salOrders) {
            String key = salBill.getLong("billentry.entrysettleorg") + "_" + salBill.getLong("id") + "_" + salBill.getLong("billentry.id");
            salUpLimitQtyMap.put(key, salBill.getBigDecimal("billentry.deliverbaseqtyup"));
        }
        QFilter coreBillFilter = new QFilter("entry.corebillid", "in", corebillIds);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter orgFilter = new QFilter("org.id", "in", orgIds);
        if ("ar_busbill".equals(entityName)) {
            bills = QueryServiceHelper.query((String)entityName, (String)"org,entry.corebillid,entry.corebillentryid,entry.e_baseunitqty", (QFilter[])new QFilter[]{coreBillFilter, orgFilter, statusFilter});
        } else {
            QFilter srcBillTypeFilter = new QFilter("sourcebilltype", "!=", (Object)"ar_finarbill");
            QFilter writtenFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
            QFilter hadWrittenFilter = new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE);
            bills = QueryServiceHelper.query((String)entityName, (String)"org,entry.corebillid,entry.corebillentryid,entry.e_baseunitqty", (QFilter[])new QFilter[]{coreBillFilter, orgFilter, statusFilter, srcBillTypeFilter, writtenFilter, hadWrittenFilter});
        }
        for (DynamicObject bill : bills) {
            String key = bill.getLong("org") + "_" + bill.getLong("entry.corebillid") + "_" + bill.getLong("entry.corebillentryid");
            BigDecimal baseQty = bill.getBigDecimal("entry.e_baseunitqty");
            BigDecimal salSubmitedQty = (BigDecimal)submitedQtyMap.get(key);
            if (salSubmitedQty == null) {
                submitedQtyMap.put(key, baseQty);
                continue;
            }
            submitedQtyMap.put(key, baseQty.add(salSubmitedQty));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String sourceBillType = bill.getString("sourcebilltype");
            Long orgId = bill.getLong("org.id");
            if ("ar_finarbill".equals(sourceBillType)) continue;
            String billNo = bill.getString("billno");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if (!"sm_salorder".equals(row.getString("e_corebilltype"))) continue;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                String key = orgId + "_" + coreBillId + "_" + coreBillEntryId;
                BigDecimal coreUpLimitQty = (BigDecimal)salUpLimitQtyMap.get(key);
                BigDecimal coreSumBaseQty = (BigDecimal)submitedQtyMap.get(key);
                if (coreUpLimitQty == null || coreSumBaseQty == null || coreSumBaseQty.abs().compareTo(coreUpLimitQty.abs()) <= 0) continue;
                int seq = row.getInt("seq");
                String errorMessageTemplate = "ar_busbill".equals(entityName) ? String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355%1$s\uff1a\u7b2c%2$s\u884c\uff0c\u6309\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u7684\u6682\u4f30\u5e94\u6536\u5355\u7d2f\u8ba1\u6570\u91cf\u5df2\u8d85\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillSubmitSalDeliverBaseQtyValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), billNo, seq) : String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%1$s\uff1a\u7b2c%2$s\u884c\uff0c\u6309\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u6536\u5355\u7d2f\u8ba1\u6570\u91cf\u5df2\u8d85\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillSubmitSalDeliverBaseQtyValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), billNo, seq);
                String message = String.format(errorMessageTemplate, bill.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

