/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class BusArBillImportValidator
extends AbstractValidator {
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<Long, InitHelper> initMap = new HashMap<Long, InitHelper>();
        HashMap measureUnitIds = new HashMap();
        for (ExtendedDataEntity data : datas) {
            String message;
            DynamicObject bill = data.getDataEntity();
            long orgPk = (Long)bill.getDynamicObject("org").getPkValue();
            String billSrctype = bill.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            FormServiceHelper.checkMeasureUnitRange((DynamicObjectCollection)entries, (String)"e_material", measureUnitIds);
            for (int i = 0; i < entries.size(); ++i) {
                Long materialId;
                Set usableUnitIds;
                DynamicObject row = (DynamicObject)entries.get(i);
                DynamicObject material = row.getDynamicObject("e_material");
                DynamicObject measureUnit = row.getDynamicObject("e_measureunit");
                if (material != null && measureUnit != null && !(usableUnitIds = (Set)measureUnitIds.get(materialId = Long.valueOf(material.getLong("id")))).contains(measureUnit.getLong("id"))) {
                    this.addMessage(data, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u5728\u7269\u6599\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\u3002", (String)"BusArBillImportValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[]{i + 1}));
                }
                if (material == null) continue;
                String configproperty = material.getString("configproperties");
                DynamicObject configuredcode = row.getDynamicObject("configuredcode");
                if ("2".equals(configproperty)) {
                    if (EmptyUtils.isNotEmpty((Object)configuredcode)) {
                        if (material.getString("number").equals(configuredcode.getString("material.number"))) continue;
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5bfc\u5165\u7684\u201c\u914d\u7f6e\u53f7\u201d\u4e0e\u7269\u6599\u4e0d\u5339\u914d\u3002", (String)"BusArBillImportValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\u201c\u914d\u7f6e\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusArBillImportValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (!EmptyUtils.isNotEmpty((Object)configuredcode)) continue;
                row.set("configuredcode", null);
            }
            InitHelper init = null;
            if (!initMap.containsKey(orgPk)) {
                init = new InitHelper(orgPk, "ar_init");
                if (!ObjectUtils.isEmpty((Object)init.getInitId())) {
                    initMap.put(orgPk, init);
                }
            } else {
                init = (InitHelper)initMap.get(orgPk);
            }
            if (StringUtils.isEmpty((String)(message = this.dataCheck(bill, init)))) continue;
            this.addErrorMessage(data, message);
        }
    }

    private String dataCheck(DynamicObject bill, InitHelper init) {
        String message = null;
        try {
            Date bizDate = bill.getDate("bizdate");
            if (bill.getBoolean("isperiod")) {
                DynamicObject billtype = bill.getDynamicObject("billtype");
                if ("arfin_borrowar_BT_S".equals(billtype.getString("number"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"BusArBillImportValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"BusArBillImportValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (DateUtils.compareTo((Date)bizDate, (Date)init.getStartDate()) >= 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u542f\u7528\u65e5\u671f(%s)\u3002", (String)"BusArBillImportValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(init.getStartDate())));
                }
            } else {
                Date startDate = init.getStartDate();
                if (!ObjectUtils.isEmpty((Object)startDate) && bizDate.compareTo(startDate) < 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u542f\u7528\u65e5\u671f(%s)\u3002", (String)"BusArBillImportValidator_11", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(startDate)));
                }
            }
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }
}

