/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;

public class CoordinationApAdjustValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(CoordinationApAdjustValidator.class);

    public void validate() {
        Set<Long> downHaveApBillIds = this.getDownHaveApBillIds();
        logger.info("CoordinationApAdjustValidator downHaveApBillIds");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<ExtendedDataEntity> needGoonValidateDatas = new ArrayList<ExtendedDataEntity>(8);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finArBill = dataEntity.getDataEntity();
            if (!BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(finArBill.getString("billsrctype")) || !"C".equals(finArBill.getString("billstatus")) || downHaveApBillIds.contains(finArBill.getLong("id"))) {
                this.throwErrorMessage(dataEntity);
                continue;
            }
            needGoonValidateDatas.add(dataEntity);
        }
        if (needGoonValidateDatas.isEmpty()) {
            return;
        }
        Set<Long> canExecuteFinArBillIds = this.getCanExecuteFinArBillIds(needGoonValidateDatas);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finArBill = dataEntity.getDataEntity();
            if (canExecuteFinArBillIds.contains(finArBill.getLong("id"))) continue;
            this.throwErrorMessage(dataEntity);
        }
    }

    private void throwErrorMessage(ExtendedDataEntity dataEntity) {
        String message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u8d22\u52a1\u5e94\u6536\u5355\u662f\u5426\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a", (String)"CoordinationApAdjustValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u5e76\u4e14\u5355\u636e\u6765\u6e90\u7c7b\u578b\u4e3a\u201c\u53d1\u7968\u8c03\u5dee\u751f\u6210\u201d\uff1b", (String)"CoordinationApAdjustValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u7684\u4e0b\u6e38\u6216\u4e0a\u6e38\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u5e76\u4e14\u8fd9\u4e9b\u5e94\u4ed8\u5355\u672a\u8fdb\u884c\u8fc7\u201c\u8c03\u6574\u201d\u3002", (String)"CoordinationApAdjustValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]);
        this.addMessage(dataEntity, message);
    }

    private Set<Long> getDownHaveApBillIds() {
        List finArBillIds = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcebillid", "in", finArBillIds);
        filter.and(new QFilter("sourcebilltype", "=", (Object)"ar_finarbill"));
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> downHaveApBillIds = new HashSet<Long>(16);
        for (DynamicObject finApBill : finApBills) {
            downHaveApBillIds.add(finApBill.getLong("sourcebillid"));
        }
        return downHaveApBillIds;
    }

    private Set<Long> getCanExecuteFinArBillIds(List<ExtendedDataEntity> dataEntities) {
        HashMap<String, Long> srcAr4ArIdMap = new HashMap<String, Long>(8);
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(8);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finArBill = dataEntity.getDataEntity();
            srcAr4ArIdMap.put(finArBill.getString("sourcebillid"), finArBill.getLong("id"));
            sourceBillIds.add(Long.parseLong(finArBill.getString("sourcebillid")));
        }
        HashMap<String, Long> srcAr4ApIdMap = new HashMap<String, Long>(8);
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ar_finarbill");
        filter.and(new QFilter("sourcebillid", "in", sourceBillIds));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter});
        for (DynamicObject finApBill : finApBills) {
            srcAr4ApIdMap.put(finApBill.getString("sourcebillid"), finApBill.getLong("id"));
            sourceBillIds.remove(finApBill.getLong("sourcebillid"));
        }
        if (!sourceBillIds.isEmpty()) {
            QFilter filter1 = new QFilter("id", "in", sourceBillIds);
            filter1.and(new QFilter("sourcebilltype", "=", (Object)"ap_finapbill"));
            DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter1});
            for (Object finArBill : finArBills) {
                srcAr4ApIdMap.put(finArBill.getString("id"), Long.parseLong(finArBill.getString("sourcebillid")));
            }
        }
        QFilter filter2 = new QFilter("sourcebillid", "in", srcAr4ApIdMap.values());
        filter2.and(new QFilter("sourcebilltype", "=", (Object)"ap_finapbill"));
        filter2.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection adjustApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billsrctype,sourcebillid,billtypeid.number", (QFilter[])new QFilter[]{filter2});
        HashSet<Long> apAdjustSrcBillIds = new HashSet<Long>(8);
        for (DynamicObject adjustApBill : adjustApBills) {
            String billSrcType = adjustApBill.getString("billsrctype");
            String billTypeNumber = adjustApBill.getString("billtypeid.number");
            if (!BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(billSrcType) && !"ApFin_borr_BT_S".equals(billTypeNumber)) continue;
            apAdjustSrcBillIds.add(adjustApBill.getLong("sourcebillid"));
        }
        HashSet<Long> canExecuteFinArBillIds = new HashSet<Long>(8);
        for (Map.Entry entrySet : srcAr4ArIdMap.entrySet()) {
            String arSrcId = (String)entrySet.getKey();
            Long finApBillId = (Long)srcAr4ApIdMap.get(arSrcId);
            if (finApBillId == null || apAdjustSrcBillIds.contains(finApBillId)) continue;
            canExecuteFinArBillIds.add((Long)entrySet.getValue());
        }
        return canExecuteFinArBillIds;
    }
}

