/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArAdjustValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>(1);
        for (ExtendedDataEntity data : datas) {
            DynamicObject finArBill = data.getDataEntity();
            DynamicObject billtye = finArBill.getDynamicObject("billtype");
            boolean iswrittenoff = finArBill.getBoolean("iswrittenoff");
            String sourceBillType = finArBill.getString("sourcebilltype");
            if (iswrittenoff || !"arfin_borrowar_BT_S".equals(billtye.getString("number")) || !"ar_finarbill".equals(sourceBillType)) continue;
            long srcId = Long.parseLong(finArBill.getString("sourcebillid"));
            srcBillIds.add(srcId);
        }
        DynamicObject[] srcArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,payproperty", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        Map<Long, DynamicObject> srcArBillMap = Arrays.stream(srcArBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        for (ExtendedDataEntity data : datas) {
            boolean payProperty;
            DynamicObject finArBill = data.getDataEntity();
            DynamicObject billtye = finArBill.getDynamicObject("billtype");
            String sourceBillType = finArBill.getString("sourcebilltype");
            boolean iswrittenoff = finArBill.getBoolean("iswrittenoff");
            if (!iswrittenoff && "arfin_borrowar_BT_S".equals(billtye.getString("number"))) {
                this.adjustTypeAmtVal(data);
            }
            if (iswrittenoff || !"arfin_borrowar_BT_S".equals(billtye.getString("number")) || !"ar_finarbill".equals(sourceBillType)) continue;
            String srcId = finArBill.getString("sourcebillid");
            DynamicObject srcArBiLL = srcArBillMap.get(Long.parseLong(srcId));
            DynamicObject srcPayProperty = srcArBiLL.getDynamicObject("payproperty");
            if (EmptyUtils.isEmpty((Object)srcPayProperty)) {
                Boolean isBasedonamt;
                DynamicObject payProperty2 = finArBill.getDynamicObject("payproperty");
                if (!EmptyUtils.isNotEmpty((Object)payProperty2) || !(isBasedonamt = Boolean.valueOf(payProperty2.getBoolean("isbasedonamt"))).booleanValue()) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u6e38\u6b3e\u9879\u6027\u8d28\u4e3a\u7a7a\uff0c\u8c03\u6574\u5355\u6b3e\u9879\u6027\u8d28\u9700\u8981\u4e3a\u6570\u91cf\u57fa\u51c6\u3002", (String)"FinArAdjustValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean srcPayPro = srcPayProperty.getBoolean("isbasedonamt");
            if (srcPayPro == (payProperty = finArBill.getBoolean("payproperty.isbasedonamt"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u5355\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u9700\u8981\u4e0e\u4e0a\u6e38\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FinArAdjustValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    public void adjustTypeAmtVal(ExtendedDataEntity data) {
        DynamicObject finApBill = data.getDataEntity();
        String adjustType = finApBill.getString("adjusttype");
        DynamicObjectCollection entryColls = finApBill.getDynamicObjectCollection("entry");
        BigDecimal priceTaxTotal = finApBill.getBigDecimal("recamount");
        if (entryColls != null && entryColls.size() > 0) {
            for (int i = 0; i < entryColls.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryColls.get(i);
                BigDecimal e_tax = entry.getBigDecimal("e_tax");
                BigDecimal e_amount = entry.getBigDecimal("e_amount");
                if ("buckle".equals(adjustType)) {
                    if (e_tax.compareTo(BigDecimal.ZERO) <= 0 && e_amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u6263\u7f5a\u6b3e\u201d\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\u3001\u7a0e\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinArAdjustValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if ("rebate".equals(adjustType)) {
                    if (e_tax.compareTo(BigDecimal.ZERO) <= 0 && e_amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u8fd4\u5229\u6298\u6263\u201d\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\u3001\u7a0e\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinArAdjustValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (!"overdue".equals(adjustType) || e_tax.compareTo(BigDecimal.ZERO) >= 0 && e_amount.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u903e\u671f\u5229\u606f\u201d\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\u3001\u7a0e\u989d\u4e3a\u6b63\u6570\u3002", (String)"FinArAdjustValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
            }
        }
        if ("buckle".equals(adjustType)) {
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) >= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u6263\u7f5a\u6b3e\u201d\uff0c\u8bf7\u4fee\u6539\u5e94\u6536\u91d1\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinArAdjustValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        } else if ("rebate".equals(adjustType)) {
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) >= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u8fd4\u5229\u6298\u6263\u201d\uff0c\u8bf7\u4fee\u6539\u5e94\u6536\u91d1\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinArAdjustValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        } else if ("overdue".equals(adjustType) && priceTaxTotal.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u903e\u671f\u5229\u606f\u201d\uff0c\u8bf7\u4fee\u6539\u5e94\u6536\u91d1\u989d\u4e3a\u6b63\u6570\u3002", (String)"FinArAdjustValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }
}

