/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinArBillAutoCfmValidator
extends AbstractExecControlValidator {
    Map<Long, Boolean> org005Map = new HashMap<Long, Boolean>(1);

    public Set<String> preparePropertys() {
        return new HashSet<String>(2);
    }

    public void validate() {
        Set<Long> arBusIds = this.getSrcBusArIds();
        if (arBusIds.size() > 0) {
            Map targetBillIdMap = BOTPHelper.findDirtTargetBillIds((String)"ar_busbill", (Long[])arBusIds.toArray(new Long[0]), (String)"ar_revcfmbill", (String)"ar_revcfmbill");
            block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                String srcBillType = bill.getString("sourcebilltype");
                long orgPk = bill.getLong("org.id");
                boolean ar005 = this.org005Map.get(orgPk);
                if (!ar005 || !"ar_busbill".equals(srcBillType)) continue;
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    Long srcId = entry.getLong("e_srcid");
                    if (targetBillIdMap.get(srcId) == null || ((Set)targetBillIdMap.get(srcId)).size() <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u63a8\u6536\u5165\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u539f\u56e0\u662f\u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\u53c2\u6570\u5df2\u6253\u5f00\uff0c\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u5df2\u786e\u8ba4\u6536\u5165\uff0c\u5982\u9700\u5e94\u6536\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355\uff0c\u8bf7\u5220\u9664\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u6e38\u7684\u6536\u5165\u786e\u8ba4\u5355\u3002", (String)"FinArBillAutoCfmValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
            }
        }
    }

    private Set<Long> getSrcBusArIds() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> arBusIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String srcBillType = bill.getString("sourcebilltype");
            long orgPk = bill.getLong("org.id");
            Boolean ar005 = this.org005Map.get(orgPk);
            if (ar005 == null) {
                ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
                this.org005Map.put(orgPk, ar005);
            }
            if (!ar005.booleanValue() || !"ar_busbill".equals(srcBillType)) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                arBusIds.add(entry.getLong("e_srcid"));
            }
        }
        return arBusIds;
    }
}

