/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class FinArBillImportValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(FinArBillImportValidator.class);
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public void validate() {
        long begin = System.currentTimeMillis();
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<Long, InitHelper> initMap = new HashMap<Long, InitHelper>();
        HashMap measureUnitIds = new HashMap();
        for (ExtendedDataEntity data : datas) {
            DynamicObject billtype;
            DynamicObject bill = data.getDataEntity();
            long orgPk = (Long)bill.getDynamicObject("org").getPkValue();
            String billSrctype = bill.getString("billsrctype");
            if (BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) {
                String message;
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                FormServiceHelper.checkMeasureUnitRange((DynamicObjectCollection)entries, (String)"e_material", measureUnitIds);
                for (int i = 0; i < entries.size(); ++i) {
                    Long materialId;
                    Set usableUnitIds;
                    DynamicObject row = (DynamicObject)entries.get(i);
                    DynamicObject material = row.getDynamicObject("e_material");
                    DynamicObject measureUnit = row.getDynamicObject("e_measureunit");
                    if (material != null && measureUnit != null && !(usableUnitIds = (Set)measureUnitIds.get(materialId = Long.valueOf(material.getLong("id")))).contains(measureUnit.getLong("id"))) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u5728\u7269\u6599\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\u3002", (String)"FinArBillImportValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                    }
                    if (material == null) continue;
                    String configproperty = material.getString("configproperties");
                    DynamicObject configuredcode = row.getDynamicObject("configuredcode");
                    if ("2".equals(configproperty)) {
                        if (EmptyUtils.isNotEmpty((Object)configuredcode)) {
                            if (material.getString("number").equals(configuredcode.getString("material.number"))) continue;
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5bfc\u5165\u7684\u201c\u914d\u7f6e\u53f7\u201d\u4e0e\u7269\u6599\u4e0d\u5339\u914d\u3002", (String)"FinArBillImportValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\u201c\u914d\u7f6e\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinArBillImportValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (!EmptyUtils.isNotEmpty((Object)configuredcode)) continue;
                    row.set("configuredcode", null);
                }
                InitHelper init = null;
                if (!initMap.containsKey(orgPk)) {
                    init = new InitHelper(orgPk, "ar_init");
                    if (!ObjectUtils.isEmpty((Object)init.getInitId())) {
                        initMap.put(orgPk, init);
                    }
                } else {
                    init = (InitHelper)initMap.get(orgPk);
                }
                if (StringUtils.isEmpty((String)(message = this.dataCheck(bill, init)))) continue;
                this.addErrorMessage(data, message);
                continue;
            }
            if (!BillSrcTypeEnum.GLIMPT.getValue().equals(billSrctype) || !"arfin_borrowar_BT_S".equals((billtype = bill.getDynamicObject("billtype")).getString("number"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinArBillImportValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        logger.info("------FinArBillImportValidator.validate:" + (System.currentTimeMillis() - begin));
    }

    private String dataCheck(DynamicObject bill, InitHelper init) {
        String message = null;
        try {
            Date bizDate = bill.getDate("bizdate");
            if (bill.getBoolean("isperiod")) {
                DynamicObject billtype = bill.getDynamicObject("billtype");
                if ("arfin_borrowar_BT_S".equals(billtype.getString("number"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinArBillImportValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinArBillImportValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (DateUtils.compareTo((Date)bizDate, (Date)init.getStartDate()) >= 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f\u5e94\u65e9\u4e8e\u521d\u59cb\u5316\u542f\u7528\u65e5\u671f\u201c%s\u201d\u3002", (String)"FinArBillImportValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(init.getStartDate())));
                }
            } else {
                Date startDate = init.getStartDate();
                if (!ObjectUtils.isEmpty((Object)startDate) && bizDate.compareTo(startDate) < 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u6708\u672b\u5173\u8d26\u7684\u5f53\u524d\u65e5\u671f\u201c%s\u201d\u3002", (String)"FinArBillImportValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(startDate)));
                }
            }
            boolean isIncludeTax = bill.getBoolean("isincludetax");
            DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("entry");
            for (int i = 0; i < detailEntries.size(); ++i) {
                BigDecimal detailDiscountRate;
                DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
                int seq = i + 1;
                String detailDiscountMode = detailEntry.getString("e_discountmode");
                if (!StringUtils.isEmpty((String)detailDiscountMode) && detailDiscountMode.equals("PERCENT")) {
                    detailDiscountRate = detailEntry.getBigDecimal("e_discountrate");
                    if (detailDiscountRate.compareTo(BigDecimal.ZERO) >= 0 && detailDiscountRate.compareTo(new BigDecimal("100")) <= 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%s\u884c\uff0c\u201c\u6298\u6263\u65b9\u5f0f\u201c\u4e3a\u201d\u6298\u6263\u7387\u201d\u65f6\uff0c\u6298\u6263\u7387\u8303\u56f4\u4e3a[0,100]\u3002", (String)"FinArBillImportValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), seq));
                }
                if (StringUtils.isEmpty((String)detailDiscountMode) || !detailDiscountMode.equals("PERUNIT")) continue;
                detailDiscountRate = detailEntry.getBigDecimal("e_discountrate");
                if (isIncludeTax) {
                    BigDecimal detailTaxUnitPrice = detailEntry.getBigDecimal("e_taxunitprice");
                    if (detailDiscountRate.compareTo(detailTaxUnitPrice) <= 0 && detailDiscountRate.compareTo(BigDecimal.ZERO) >= 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%s\u884c\uff0c\u5f55\u5165\u542b\u7a0e\u5355\u4ef7=\u662f\u65f6\uff0c\u5355\u4f4d\u6298\u6263\u989d\u9700\u2264\u542b\u7a0e\u5355\u4ef7\u4e14\u22650\u3002", (String)"FinArBillImportValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal detailUnitPrice = detailEntry.getBigDecimal("e_unitprice");
                if (detailDiscountRate.compareTo(detailUnitPrice) <= 0 && detailDiscountRate.compareTo(BigDecimal.ZERO) >= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%s\u884c\uff0c\u5f55\u5165\u542b\u7a0e\u5355\u4ef7=\u5426\u65f6\uff0c\u5355\u4f4d\u6298\u6263\u989d\u9700\u2264\u5355\u4ef7\u4e14\u22650\u3002", (String)"FinArBillImportValidator_11", (String)"fi-ar-opplugin", (Object[])new Object[0]), seq));
            }
            Date dueDate = bill.getDate("duedate");
            BigDecimal planPricetax = BigDecimal.ZERO;
            DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
            for (int i = 0; i < planEntries.size(); ++i) {
                DynamicObject planEntry = (DynamicObject)planEntries.get(i);
                int seq = i + 1;
                Date planDuedate = planEntry.getDate("planduedate");
                if (!ObjectUtils.isEmpty((Object)planDuedate) && !ObjectUtils.isEmpty((Object)dueDate) && DateUtils.compareTo((Date)planDuedate, (Date)dueDate) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u6536\u6b3e\u8ba1\u5212\u201d\u7b2c%s\u884c\uff0c\u201c\u6536\u6b3e\u8ba1\u5212\u201d\u5230\u671f\u65e5\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u3002", (String)"FinArBillImportValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]), seq));
                }
                planPricetax = planPricetax.add(planEntry.getBigDecimal("planpricetax"));
            }
            if (planPricetax.compareTo(bill.getBigDecimal("recamount")) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6536\u6b3e\u8ba1\u5212\u201d\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u5e94\u6536\u91d1\u989d\u5e94\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FinArBillImportValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }
}

