/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class FinArBillPremAuditValidator
extends AbstractValidator {
    private Map<Long, Boolean> hasNumberMap = new HashMap<Long, Boolean>(2);

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            DynamicObject finBill = data.getDataEntity();
            BigDecimal premiumAmt = finBill.getBigDecimal("premiumamt");
            if (premiumAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (!this.hashNumber(finBill.getLong("id"), finBill.getLong("org.id")).booleanValue()) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u201c\u8d28\u4fdd\u91d1\u6bd4\u4f8b\u201d\u4e0d\u4e3a0\u7684\u5e94\u6536\u5355\u3002", (String)"FinArBillPremAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            BigDecimal unsettleAmt = finBill.getBigDecimal("unsettleamount");
            if (premiumAmt.abs().compareTo(unsettleAmt.abs()) <= 0) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u5927\u4e8e\u6574\u5355\u672a\u7ed3\u7b97\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"FinArBillPremAuditValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private Boolean hashNumber(long billId, long orgPk) {
        Boolean hasNumber = this.hasNumberMap.get(orgPk);
        if (hasNumber == null) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ar_finarbill");
            hasNumber = CodeRuleServiceHelper.isExist((String)"ar_finarbill", (DynamicObject)bill, (String)String.valueOf(orgPk));
            this.hasNumberMap.put(orgPk, hasNumber);
        }
        return hasNumber;
    }
}

