/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.util.DateUtils;

public class FinArBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(datas.length);
        ArrayList<Long> srcFinIds = new ArrayList<Long>(8);
        for (ExtendedDataEntity data : datas) {
            DynamicObject finArBill = data.getDataEntity();
            dataEntities.add(finArBill);
            if (!"ap_finapbill".equals(finArBill.getString("sourcebilltype"))) continue;
            srcFinIds.add(Long.valueOf(finArBill.getString("sourcebillid")));
        }
        if (!ObjectUtils.isEmpty(srcFinIds)) {
            QFilter idFilter = new QFilter("id", "in", srcFinIds);
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,payproperty.isbasedonamt", (QFilter[])new QFilter[]{idFilter});
            for (DynamicObject finApBill : finApBills) {
                paramMap.put(finApBill.getLong("id"), finApBill.getBoolean("payproperty.isbasedonamt"));
            }
        }
        boolean isInDataBase = ArApDataRepairHelper.isInBaseData((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
        for (ExtendedDataEntity data : datas) {
            boolean isPerirod;
            Date duedate;
            DynamicObject finApBill = data.getDataEntity();
            if (finApBill.getBoolean("isbaddebt") && finApBill.getBigDecimal("baddebtamt").compareTo(finApBill.getBigDecimal("recamount")) > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u574f\u8d26\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillSubmitValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if ((duedate = finApBill.getDate("duedate")) != null) {
                duedate = DateUtils.getDataFormat((Date)duedate, (boolean)false);
                DynamicObjectCollection planEntry = finApBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planRow : planEntry) {
                    Date planDuedate = planRow.getDate("planduedate");
                    if (planDuedate == null || DateUtils.compareTo((Date)planDuedate, (Date)duedate) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5230\u671f\u65e5\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u8868\u5934\u5230\u671f\u65e5\u3002", (String)"FinArBillSubmitValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if (isInDataBase) {
                this.checkEntry(data);
            }
            if (isPerirod = finApBill.getBoolean("isperiod")) {
                this.checkConfirmFields(data);
            }
            this.checkCoordinationPayProperty(data, paramMap);
            BigDecimal pricetaxtotal = finApBill.getBigDecimal("recamount");
            BigDecimal premiumamt = finApBill.getBigDecimal("premiumamt");
            if (premiumamt.multiply(pricetaxtotal).compareTo(BigDecimal.ZERO) < 0 || pricetaxtotal.compareTo(BigDecimal.ZERO) == 0 && premiumamt.compareTo(BigDecimal.ZERO) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u65b9\u5411\u4e0e\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArBillSubmitValidator_11", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            } else if (pricetaxtotal.abs().compareTo(premiumamt.abs()) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            this.premiumValidator(data);
        }
    }

    private void checkConfirmFields(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        DynamicObject payproperty = bill.getDynamicObject("payproperty");
        if (ObjectUtils.isEmpty((Object)payproperty)) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\"%1$s\"\uff1a\u6b3e\u578b\u6027\u8d28\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u3002", (String)"FinArBillSubmitValidator_13", (String)"fi-ar-opplugin", (Object[])new Object[0]), bill.getString("billno")));
            return;
        }
        boolean isBasedOnAmt = payproperty.getBoolean("isbasedonamt");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            BigDecimal confirmAmt = entry.getBigDecimal("e_confirmedamt");
            BigDecimal amount = entry.getBigDecimal("e_amount");
            BigDecimal confirmQty = entry.getBigDecimal("e_confirmedqty");
            BigDecimal quantity = entry.getBigDecimal("e_quantity");
            if (confirmAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0 || confirmAmt.abs().compareTo(amount.abs()) > 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u5df2\u786e\u8ba4\u91d1\u989d\u987b\u4e0e\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_14", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
            }
            if (confirmQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || confirmQty.abs().compareTo(quantity.abs()) > 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u5df2\u786e\u8ba4\u6570\u91cf\u987b\u4e0e\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
            }
            if (isBasedOnAmt) {
                if (confirmAmt.compareTo(amount) != 0 && confirmQty.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u90e8\u5206\u91d1\u989d\u786e\u8ba4\u6536\u5165\u65f6\uff0c\u5df2\u786e\u8ba4\u6570\u91cf\u987b\u7b49\u4e8e0\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_16", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
                }
            } else if (confirmQty.compareTo(quantity) == 0 && confirmAmt.compareTo(amount) != 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u6570\u91cf\u57fa\u51c6\u4e1a\u52a1\uff0c\u6309\u6570\u91cf\u5168\u989d\u786e\u8ba4\u6536\u5165\u65f6\uff0c\u5df2\u786e\u8ba4\u91d1\u989d\u987b\u7b49\u4e8e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_17", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0 || confirmAmt.compareTo(amount) != 0 || confirmQty.compareTo(quantity) == 0) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u5df2\u786e\u8ba4\u91d1\u989d\u7b49\u4e8e\u91d1\u989d\uff0c\u5df2\u786e\u8ba4\u6570\u91cf\u987b\u7b49\u4e8e\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_18", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
        }
    }

    private void checkEntry(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            BigDecimal unConfirmAmt;
            BigDecimal recAmount = entry.getBigDecimal("e_recamount");
            BigDecimal invoicedAmt = entry.getBigDecimal("e_invoicedamt");
            BigDecimal unInvoicedAmt = entry.getBigDecimal("e_uninvoicedamt");
            BigDecimal quantity = entry.getBigDecimal("e_quantity");
            BigDecimal invoicedQty = entry.getBigDecimal("e_invoicedqty");
            BigDecimal unInvoicedQty = entry.getBigDecimal("e_uninvoicedqty");
            if (invoicedAmt.add(unInvoicedAmt).compareTo(recAmount) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u672a\u5173\u8054\u5f00\u7968\u91d1\u989d+\u5173\u8054\u5f00\u7968\u91d1\u989d\u9700\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[]{entry.getString("seq")}));
            }
            if (invoicedQty.add(unInvoicedQty).compareTo(quantity) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u672a\u5173\u8054\u5f00\u7968\u6570\u91cf+\u5173\u8054\u5f00\u7968\u6570\u91cf\u9700\u7b49\u4e8e\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[]{entry.getString("seq")}));
            }
            BigDecimal confirmedQty = entry.getBigDecimal("e_confirmedqty");
            BigDecimal unConfirmQty = entry.getBigDecimal("e_unconfirmqty");
            if (unConfirmQty.add(confirmedQty).compareTo(quantity) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u672a\u786e\u8ba4\u6570\u91cf+\u5df2\u786e\u8ba4\u6570\u91cf\u9700\u7b49\u4e8e\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[]{entry.getString("seq")}));
            }
            BigDecimal amount = entry.getBigDecimal("e_amount");
            BigDecimal confirmedAmt = entry.getBigDecimal("e_confirmedamt");
            if (confirmedAmt.add(unConfirmAmt = entry.getBigDecimal("e_unconfirmamt")).compareTo(amount) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u672a\u786e\u8ba4\u91d1\u989d+\u5df2\u786e\u8ba4\u91d1\u989d\u9700\u7b49\u4e8e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[]{entry.getString("seq")}));
            }
            BigDecimal confirmBaseQty = entry.getBigDecimal("e_confirmedbaseqty");
            BigDecimal unConfirmBaseQty = entry.getBigDecimal("e_unconfirmbaseqty");
            BigDecimal baseQty = entry.getBigDecimal("e_baseunitqty");
            if (confirmBaseQty.add(unConfirmBaseQty).compareTo(baseQty) == 0) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7b2c%s\u884c\u672a\u786e\u8ba4\u57fa\u672c\u6570\u91cf+\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u9700\u7b49\u4e8e\u57fa\u672c\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinArBillSubmitValidator_19", (String)"fi-ar-opplugin", (Object[])new Object[0]), entry.getString("seq")));
        }
    }

    private void premiumValidator(ExtendedDataEntity data) {
        DynamicObject finArBill = data.getDataEntity();
        DynamicObjectCollection detailEntry = finArBill.getDynamicObjectCollection("entry");
        DynamicObjectCollection planEntry = finArBill.getDynamicObjectCollection("planentity");
        if (detailEntry.size() <= 1 && planEntry.size() <= 1 || BigDecimal.ZERO.compareTo(finArBill.getBigDecimal("premiumamt")) == 0) {
            return;
        }
        long noZeroCount = 0L;
        long count = 0L;
        for (DynamicObject detail : detailEntry) {
            if (BigDecimal.ZERO.compareTo(detail.getBigDecimal("e_recamount")) == 0) continue;
            if (BigDecimal.ZERO.compareTo(detail.getBigDecimal("e_recamount")) < 0) {
                ++count;
            }
            ++noZeroCount;
        }
        if (count > 0L && count < noZeroCount) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u8d1f\u5206\u5f55\u884c\u7684\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u5f55\u5165\u8d28\u4fdd\u91d1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillSubmitValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        noZeroCount = 0L;
        count = 0L;
        for (DynamicObject plan : planEntry) {
            if (BigDecimal.ZERO.compareTo(plan.getBigDecimal("planpricetax")) == 0) continue;
            if (BigDecimal.ZERO.compareTo(plan.getBigDecimal("planpricetax")) < 0) {
                ++count;
            }
            ++noZeroCount;
        }
        if (count > 0L && count < noZeroCount) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u8d1f\u5206\u5f55\u884c\u7684\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u5f55\u5165\u8d28\u4fdd\u91d1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillSubmitValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkCoordinationPayProperty(ExtendedDataEntity data, Map<Long, Boolean> paramMap) {
        DynamicObject finArBill = data.getDataEntity();
        if ("ap_finapbill".equals(finArBill.getString("sourcebilltype"))) {
            Boolean srcIsBasedonAmt = paramMap.get(finArBill.getLong("sourcebillid"));
            if (srcIsBasedonAmt == null) {
                return;
            }
            if (finArBill.getBoolean("payproperty.isbasedonamt") != srcIsBasedonAmt.booleanValue()) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e0e\u6e90\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArBillSubmitValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

