/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;

public class FinArBillTransferValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        Set billIds = Arrays.stream(datas).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toSet());
        DynamicObject firstFinApBill = datas[0].getDataEntity();
        long firstBiztype = firstFinApBill.getLong("billtype.id");
        String firstAsstactType = firstFinApBill.getString("asstacttype");
        DynamicObject firstOrg = firstFinApBill.getDynamicObject("org");
        DynamicObject firstRecOrg = firstFinApBill.getDynamicObject("recorg");
        DynamicObject firstCurrency = firstFinApBill.getDynamicObject("currency");
        if (!ArApHelper.isExistNumberRule((String)"ar_finarbill", (Long)firstFinApBill.getLong("id"), (String)firstOrg.getString("id"))) {
            this.setAllError(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u503a\u6743\u8f6c\u79fb\u3002", (String)"FinArBillTransferValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(8);
        DynamicObject[] billDatas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,recorg,billtype,asstacttype,currency,entry,e_unlockamt,settlestatus,payproperty,recamount", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashSet<String> isBaseDonAmtSet = new HashSet<String>(2);
        HashSet<Integer> amtDirection = new HashSet<Integer>(2);
        for (DynamicObject dynamicObject : billDatas) {
            billMap.put(dynamicObject.getLong("id"), dynamicObject);
            isBaseDonAmtSet.add(dynamicObject.getString("payproperty.isbasedonamt"));
            amtDirection.add(dynamicObject.getBigDecimal("recamount").signum());
        }
        if (isBaseDonAmtSet.size() != 1) {
            this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u522b\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        if (amtDirection.size() != 1) {
            this.setAllError(ResManager.loadKDString((String)"\u9009\u62e9\u591a\u5f20\u5355\u636e\u8fdb\u884c\u503a\u6743\u8f6c\u79fb\u65f6\uff0c\u9700\u786e\u4fdd\u6bcf\u5f20\u5355\u636e\u7684\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FinArBillTransferValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject dynamicObject : datas) {
            Long billId = dynamicObject.getDataEntity().getLong("id");
            DynamicObject info = (DynamicObject)billMap.get(billId);
            if (firstBiztype != info.getLong("billtype.id")) {
                this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (!firstAsstactType.equals(info.getString("asstacttype"))) {
                this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5f80\u6765\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (firstOrg.getLong("id") != info.getDynamicObject("org").getLong("id")) {
                this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5e94\u6536\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (firstRecOrg.getLong("id") != info.getDynamicObject("recorg").getLong("id")) {
                this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u6536\u6b3e\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (firstCurrency.getLong("id") != info.getDynamicObject("currency").getLong("id")) {
                this.setAllError(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u7ed3\u7b97\u5e01\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u786e\u4fdd\u5355\u636e\u7c7b\u578b\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5e94\u6536\u7ec4\u7ec7\u3001\u6536\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u5e01\u3001\u6b3e\u9879\u6027\u8d28\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4e00\u81f4\u3002", (String)"FinArBillTransferValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (ARSettleStatusEnum.SETTLED.getValue().equals(info.getString("settlestatus"))) {
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u53ea\u6709\u7ed3\u7b97\u72b6\u6001\u4e0d\u7b49\u4e8e\u5168\u90e8\u7ed3\u7b97\u65f6\uff0c\u624d\u53ef\u4ee5\u8fdb\u884c\u503a\u6743\u8f6c\u79fb\u5904\u7406\u3002", (String)"FinArBillTransferValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection detailRows = info.getDynamicObjectCollection("entry");
            boolean isAllDetailIsZero = true;
            for (DynamicObject detailRow : detailRows) {
                if (detailRow.getBigDecimal("e_unlockamt").signum() == 0) continue;
                isAllDetailIsZero = false;
            }
            if (!isAllDetailIsZero) continue;
            this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u4e3a0\uff0c\u624d\u53ef\u8fdb\u884c\u503a\u6743\u8f6c\u79fb\u3002", (String)"FinArBillTransferValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void setAllError(String error) {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            this.addErrorMessage(data, error);
        }
    }
}

