/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillUnAuditPushValidator
extends AbstractValidator {
    Map<Long, Boolean> org011Map = new HashMap<Long, Boolean>();
    Map<Long, Boolean> org002Map = new HashMap<Long, Boolean>();
    Map<Long, Boolean> org005Map = new HashMap<Long, Boolean>();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            billIds.add(info.getLong("id"));
        }
        Map dirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)this.entityKey, (Long[])billIds.toArray(new Long[0]));
        if (dirtTargetBillMap.isEmpty()) {
            return;
        }
        Map<String, DynamicObjectCollection> batchTarBillObjMap = this.getBatchTarBillObjMap(dirtTargetBillMap);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            long billId = info.getLong("id");
            long orgPk = (Long)info.getDynamicObject("org").getPkValue();
            Map singleTarBillIdMap = (Map)dirtTargetBillMap.get(billId);
            if (singleTarBillIdMap == null || singleTarBillIdMap.isEmpty() || this.judgePremFinAr(data, singleTarBillIdMap, batchTarBillObjMap)) continue;
            if (this.judgeArTargetBill(singleTarBillIdMap, orgPk, batchTarBillObjMap) || !this.judageTargetBillIsAutoPush(singleTarBillIdMap, info)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinArBillUnAuditPushValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (this.revcfmBillValidate((Set)singleTarBillIdMap.get("ar_revcfmbill"), orgPk, batchTarBillObjMap)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinArBillUnAuditPushValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (this.isAutoPushApBill(info, singleTarBillIdMap, batchTarBillObjMap)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\uff0c\u672c\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArBillUnAuditPushValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (this.validateCancelTargetBills(singleTarBillIdMap, batchTarBillObjMap)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinArBillUnAuditPushValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean revcfmBillValidate(Set<Long> revcfmBillIds, long orgPk, Map<String, DynamicObjectCollection> batchTarBillObjMap) {
        boolean isVoucher = false;
        if (revcfmBillIds == null || revcfmBillIds.isEmpty()) {
            return false;
        }
        Boolean ar005 = this.org005Map.get(orgPk);
        if (ar005 == null) {
            ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
            this.org005Map.put(orgPk, ar005);
        }
        DynamicObjectCollection revcfmBills = batchTarBillObjMap.get("ar_revcfmbill");
        List revcfmBillList = revcfmBills.stream().filter(revcfmBill -> revcfmBillIds.contains(revcfmBill.getLong("id")) && revcfmBill.getBoolean("isvoucher")).collect(Collectors.toList());
        if (ar005.booleanValue() && !revcfmBillList.isEmpty()) {
            isVoucher = true;
        }
        return isVoucher;
    }

    private boolean validateCancelTargetBills(Map<String, Set<Long>> targetBills, Map<String, DynamicObjectCollection> batchTarBillObjMap) {
        if (targetBills == null) {
            return true;
        }
        targetBills.remove("ar_revcfmbill");
        targetBills.remove("ar_journal");
        targetBills.remove("cas_paybill");
        String changes = null;
        for (String targkey : targetBills.keySet()) {
            if (!targkey.endsWith("arbillchange")) continue;
            changes = targkey;
        }
        if (changes != null) {
            targetBills.remove(changes);
        }
        return targetBills.isEmpty() || this.canApBillDelete(targetBills, batchTarBillObjMap);
    }

    private boolean canApBillDelete(Map<String, Set<Long>> targetBills, Map<String, DynamicObjectCollection> batchTarBillObjMap) {
        for (Map.Entry<String, Set<Long>> entry : targetBills.entrySet()) {
            DynamicObjectCollection bills = batchTarBillObjMap.get(entry.getKey());
            if (EmptyUtils.isEmpty((Object)bills)) continue;
            List billList = bills.stream().filter(bill -> ((Set)entry.getValue()).contains(bill.getLong("id"))).collect(Collectors.toList());
            for (DynamicObject bill2 : billList) {
                if (BillStatusEnum.SAVE.getValue().equals(bill2.getString("billstatus"))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAutoPushApBill(DynamicObject finArBill, Map<String, Set<Long>> singleTarBillIdMap, Map<String, DynamicObjectCollection> batchTarBillObjMap) {
        DynamicObjectCollection apBills;
        List apBillList;
        Set<Long> finbillPks = singleTarBillIdMap.get("ap_finapbill");
        if (EmptyUtils.isEmpty(finbillPks)) {
            return false;
        }
        Boolean ar002 = this.org002Map.get(finArBill.getLong("org.id"));
        if (ar002 == null) {
            ar002 = SystemParameterHelper.getParameterBoolean((long)finArBill.getLong("org.id"), (String)"ar_002");
            this.org002Map.put(finArBill.getLong("org.id"), ar002);
        }
        return ar002 != false && EmptyUtils.isNotEmpty(apBillList = (apBills = batchTarBillObjMap.get("ap_finapbill")).stream().filter(apbill -> finbillPks.contains(apbill.getLong("id"))).collect(Collectors.toList())) && BOTPHelper.isPush((String)"ap_finapbill", (Long)((DynamicObject)apBillList.get(0)).getLong("id"));
    }

    private boolean judageTargetBillIsAutoPush(Map<String, Set<Long>> targetBills, DynamicObject info) {
        Set<Long> recBillIds = targetBills.get("cas_recbill");
        if (recBillIds == null) {
            return true;
        }
        Boolean ar011 = this.org011Map.get(info.getLong("org.id"));
        if (ar011 == null) {
            ar011 = SystemParameterHelper.getParameterBoolean((long)info.getLong("org.id"), (String)"ar_011");
            this.org011Map.put(info.getLong("org.id"), ar011);
        }
        if (StringUtils.equals((CharSequence)info.getString("paymode"), (CharSequence)"CASH") && ar011.booleanValue()) {
            DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIds)});
            boolean flag = true;
            for (DynamicObject recBill : recBills) {
                if ("A".equals(recBill.getString("billstatus"))) continue;
                flag = false;
                break;
            }
            return flag;
        }
        return false;
    }

    private boolean judgeArTargetBill(Map<String, Set<Long>> targetBills, long orgPk, Map<String, DynamicObjectCollection> batchTarBillObjMap) {
        Set<Long> arBillIds = targetBills.get("ar_finarbill");
        Set<Long> invoiceIds = targetBills.get("ar_invoice");
        Set<Long> lossIds = targetBills.get("ar_baddebtlossbill");
        Set<Long> liqBillIds = targetBills.get("ar_liquidation");
        Set<Long> apPayApplyIds = targetBills.get("ap_payapply");
        Set<Long> revcfmBills = targetBills.get("ar_revcfmbill");
        Set<Long> simOriginalBills = targetBills.get("sim_original_bill");
        Boolean ar005 = this.org005Map.get(orgPk);
        if (ar005 == null) {
            ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
            this.org005Map.put(orgPk, ar005);
        }
        if (ar005.booleanValue()) {
            revcfmBills = null;
        }
        if (invoiceIds != null || lossIds != null || liqBillIds != null || apPayApplyIds != null || revcfmBills != null || simOriginalBills != null) {
            return true;
        }
        DynamicObjectCollection arBills = batchTarBillObjMap.get("ar_finarbill");
        if (!ObjectUtils.isEmpty((Object)arBills)) {
            for (DynamicObject arBill : arBills) {
                boolean ispremium;
                long id = arBill.getLong("id");
                if (!arBillIds.contains(id) || (ispremium = arBill.getBoolean("ispremium"))) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<String, DynamicObjectCollection> getBatchTarBillObjMap(Map<Long, Map<String, Set<Long>>> dirtTargetBillMap) {
        HashMap<String, DynamicObjectCollection> batchTarBillObjMap = new HashMap<String, DynamicObjectCollection>(8);
        HashMap<String, HashSet<Long>> batchTarBillIdMap = new HashMap<String, HashSet<Long>>(8);
        Set<Map.Entry<Long, Map<String, Set<Long>>>> dirtTargetBillMapEntries = dirtTargetBillMap.entrySet();
        for (Map.Entry<Long, Map<String, Set<Long>>> dirtTargetBillMapEntry : dirtTargetBillMapEntries) {
            Map<String, Set<Long>> singleTarBillIdMap = dirtTargetBillMapEntry.getValue();
            Set<Map.Entry<String, Set<Long>>> singleTarBillIdMapEntries = singleTarBillIdMap.entrySet();
            for (Map.Entry<String, Set<Long>> singleTarBillIdMapEntry : singleTarBillIdMapEntries) {
                String singleTarBillEntity = singleTarBillIdMapEntry.getKey();
                Set<Long> singleTarBillIds = singleTarBillIdMapEntry.getValue();
                HashSet<Long> batchTarBillIds = (HashSet<Long>)batchTarBillIdMap.get(singleTarBillEntity);
                if (batchTarBillIds == null) {
                    batchTarBillIds = new HashSet<Long>(8);
                    batchTarBillIds.addAll(singleTarBillIds);
                } else {
                    batchTarBillIds.addAll(singleTarBillIds);
                }
                batchTarBillIdMap.put(singleTarBillEntity, batchTarBillIds);
            }
        }
        Set batchTarBillIdMapEntries = batchTarBillIdMap.entrySet();
        for (Map.Entry batchTarBillIdMapEntry : batchTarBillIdMapEntries) {
            String tarBillEntity = (String)batchTarBillIdMapEntry.getKey();
            Set batchTarBillIds = (Set)batchTarBillIdMapEntry.getValue();
            if (batchTarBillIds == null) continue;
            String selector = "id,billstatus";
            if ("ar_revcfmbill".equals(tarBillEntity)) {
                selector = "id,billstatus,isvoucher";
            } else if ("ar_finarbill".equals(tarBillEntity)) {
                selector = "id,billstatus,ispremium";
            }
            DynamicObjectCollection batchTarBillColl = QueryServiceHelper.query((String)tarBillEntity, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)batchTarBillIds)});
            batchTarBillObjMap.put(tarBillEntity, batchTarBillColl);
        }
        return batchTarBillObjMap;
    }

    protected boolean judgePremFinAr(ExtendedDataEntity data, Map<String, Set<Long>> singleTarBillIdMap, Map<String, DynamicObjectCollection> tarBillMap) {
        boolean judgePremFinAr = false;
        DynamicObjectCollection tarBills = tarBillMap.get("ar_finarbill");
        Set<Long> singleTarBillIds = singleTarBillIdMap.get("ar_finarbill");
        if (ObjectUtils.isEmpty((Object)tarBills)) {
            return false;
        }
        for (DynamicObject tarBill : tarBills) {
            boolean ispremium;
            long tarFinArBillId = tarBill.getLong("id");
            if (!singleTarBillIds.contains(tarFinArBillId) || !(ispremium = tarBill.getBoolean("ispremium"))) continue;
            String billstatus = tarBill.getString("billstatus");
            if (!"A".equals(billstatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinArBillUnAuditPushValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                judgePremFinAr = true;
                break;
            }
            boolean isPush = BOTPHelper.isPush((String)"ar_finarbill", (Long)tarBill.getLong("id"));
            if (!isPush) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\uff0c\u672c\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArBillUnAuditPushValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            judgePremFinAr = true;
            break;
        }
        return judgePremFinAr;
    }
}

