/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinArTransferConfirmValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity data = this.dataEntities[0];
        DynamicObject transPay = data.getDataEntity();
        boolean isPlan = SystemParameterHelper.isPlanSettle((long)transPay.getLong("org.id"), (boolean)true);
        DynamicObjectCollection planEntity = transPay.getDynamicObjectCollection("planentity");
        if (isPlan && planEntity.isEmpty()) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8f6c\u5165\u6536\u6b3e\u8ba1\u5212\u3002", (String)"FinArTransferConfirmValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection detailRows = transPay.getDynamicObjectCollection("entryentity");
        if (detailRows.isEmpty()) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f6c\u5165\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArTransferConfirmValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        long srcBillId = ((DynamicObject)detailRows.get(0)).getLong("e_srcfinbillid");
        DynamicObject srcFinArBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"payproperty.isbasedonamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcBillId)});
        if (srcFinArBill.getBoolean("payproperty.isbasedonamt") != transPay.getBoolean("payproperty.isbasedonamt")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6240\u9009\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e0e\u6e90\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArTransferConfirmValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> finBillIds = new HashSet<Long>(64);
        HashMap<Long, BigDecimal> transferAmtSumMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject detailRow : detailRows) {
            long finBillId = detailRow.getLong("e_srcfinbillid");
            finBillIds.add(finBillId);
            BigDecimal transferSumAmt = transferAmtSumMap.getOrDefault(finBillId, BigDecimal.ZERO);
            transferSumAmt = transferSumAmt.add(detailRow.getBigDecimal("e_transrecamount"));
            transferAmtSumMap.put(finBillId, transferSumAmt);
        }
        DataSet sumUnLockAmtDataSet = QueryServiceHelper.queryDataSet((String)"querySumUnLockAmt", (String)"ar_finarbill", (String)"id,entry.e_unlockamt e_unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)}, (String)"");
        sumUnLockAmtDataSet = sumUnLockAmtDataSet.groupBy(new String[]{"id"}).sum("e_unlockamt").finish();
        HashMap<Long, BigDecimal> sumUnLockAmtSumMap = new HashMap<Long, BigDecimal>();
        for (Row row : sumUnLockAmtDataSet) {
            sumUnLockAmtSumMap.put(row.getLong("id"), row.getBigDecimal("e_unlockamt"));
        }
        for (Map.Entry entrySet : transferAmtSumMap.entrySet()) {
            Long finBillId = (Long)entrySet.getKey();
            BigDecimal sumTransferAmt = (BigDecimal)entrySet.getValue();
            BigDecimal sumUnLockAmt = (BigDecimal)sumUnLockAmtSumMap.get(finBillId);
            if (sumUnLockAmt == null) continue;
            if (sumUnLockAmt.signum() != 0 && (sumTransferAmt.abs().compareTo(sumUnLockAmt.abs()) > 0 || sumTransferAmt.signum() != sumUnLockAmt.signum())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u8d85\u8fc7\u4e86\u6e90\u5355\u5e94\u6536\u4f59\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArTransferConfirmValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                break;
            }
            if (sumUnLockAmt.signum() != 0 || sumTransferAmt.signum() == 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u8d85\u8fc7\u4e86\u6e90\u5355\u5e94\u6536\u4f59\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArTransferConfirmValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            break;
        }
    }
}

