/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;

public class FinArUnAuditLockAndSettleAmtValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> lst = new HashSet<String>(8);
        lst.add("paymode");
        lst.add("premiumamt");
        lst.add("e_lockedamt");
        lst.add("e_settledamt");
        lst.add("planlockedamt");
        lst.add("plansettledamt");
        lst.add("settlestatus");
        lst.add("ispremium");
        return lst;
    }

    public void validate() {
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> hadReceiptSrdFinArBillIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String settleSetatus = bill.getString("settlestatus");
            if (!"partsettle".equals(settleSetatus) && !"settled".equals(settleSetatus)) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() > 0) {
            DynamicObject[] receiptSrds;
            QFilter filter = new QFilter("mainbillid", "in", billIds).and(new QFilter("autosettletype", "=", (Object)"5"));
            for (DynamicObject record : receiptSrds = SettleRecordQueryHelper.getSettleRecords((String)"ar_settlerecord", (String)"mainbillid", (String)"ar_finarbill", (Object[])billIds.toArray(new Long[0]), (QFilter)filter)) {
                hadReceiptSrdFinArBillIds.add(record.getLong("mainbillid"));
            }
        }
        block2: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entry;
            DynamicObject bill = dataEntity.getDataEntity();
            Long id = bill.getLong("id");
            String billNo = bill.getString("billno");
            if (hadReceiptSrdFinArBillIds.contains(id)) {
                String message = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%s\u5b58\u5728\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u6536\u6536\u6b3e\u201d\u4e14\u8f85\u65b9\u5355\u636e\u7ecf\u6536\u6b3e\u8ba4\u9886\u6309\u6838\u5fc3\u5355\u636e\u81ea\u52a8\u7ed3\u7b97\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArUnAuditLockAndSettleAmtValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), billNo);
                this.addMessage(dataEntity, message);
                continue;
            }
            String payMode = bill.getString("paymode");
            BigDecimal premiumAmt = bill.getBigDecimal("premiumamt");
            boolean ispremium = bill.getBoolean("ispremium");
            if ("CASH".equals(payMode)) continue;
            if (premiumAmt.compareTo(BigDecimal.ZERO) != 0 && !ispremium) {
                entry = bill.getDynamicObjectCollection("entry");
                BigDecimal e_lockedAmt = BigDecimal.ZERO;
                Object e_settledAmt = BigDecimal.ZERO;
                for (DynamicObject row : entry) {
                    e_lockedAmt = e_lockedAmt.add(row.getBigDecimal("e_lockedamt"));
                    e_settledAmt = ((BigDecimal)e_settledAmt).add(row.getBigDecimal("e_settledamt"));
                }
                if (e_lockedAmt.compareTo((BigDecimal)e_settledAmt) == 0) continue;
                if (e_lockedAmt.subtract(premiumAmt).compareTo((BigDecimal)e_settledAmt) != 0) {
                    String message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArUnAuditLockAndSettleAmtValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo});
                    this.addMessage(dataEntity, message);
                    break;
                }
                DynamicObjectCollection planEntry = bill.getDynamicObjectCollection("planentity");
                BigDecimal p_lockedAmt = BigDecimal.ZERO;
                BigDecimal p_settledAmt = BigDecimal.ZERO;
                for (DynamicObject planRow : planEntry) {
                    p_lockedAmt = p_lockedAmt.add(planRow.getBigDecimal("planlockedamt"));
                    p_settledAmt = p_settledAmt.add(planRow.getBigDecimal("plansettledamt"));
                }
                if (p_lockedAmt.subtract(premiumAmt).compareTo(p_settledAmt) == 0) continue;
                String message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArUnAuditLockAndSettleAmtValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo});
                this.addMessage(dataEntity, message);
                break;
            }
            entry = bill.getDynamicObjectCollection("entry");
            boolean hadInTransitBill = false;
            for (DynamicObject row : entry) {
                if (row.getBigDecimal("e_lockedamt").compareTo(row.getBigDecimal("e_settledamt")) == 0) continue;
                hadInTransitBill = true;
                String message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArUnAuditLockAndSettleAmtValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo});
                this.addMessage(dataEntity, message);
                break;
            }
            if (hadInTransitBill) break;
            DynamicObjectCollection planEntry = bill.getDynamicObjectCollection("planentity");
            for (DynamicObject planRow : planEntry) {
                if (planRow.getBigDecimal("planlockedamt").compareTo(planRow.getBigDecimal("plansettledamt")) == 0) continue;
                String message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArUnAuditLockAndSettleAmtValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{billNo});
                this.addMessage(dataEntity, message);
                continue block2;
            }
        }
    }
}

