/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;

public class FinArWriteOffUnAuditValidator
extends AbstractValidator {
    public void validate() {
        DynamicObjectCollection arOriginalWfRecord;
        Set existArOriginalIdSet;
        DynamicObjectCollection srcFinarBillWfRecord;
        Set set;
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> srcFinArBillIds = new HashSet<Long>(8);
        HashSet<Long> finArOrgIds = new HashSet<Long>(8);
        ArrayList<ExtendedDataEntity> writtenOffList = new ArrayList<ExtendedDataEntity>(2);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            if (!info.getBoolean("iswrittenoff")) continue;
            srcFinArBillIds.add(info.getLong("sourcebillid"));
            finArOrgIds.add(info.getLong("org.id"));
            writtenOffList.add(data);
        }
        if (srcFinArBillIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection srcFinarBillCol = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebilltype,billsrctype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinArBillIds)});
        ArrayList<DynamicObject> srcInfoList = new ArrayList<DynamicObject>(2);
        HashMap<String, Set> srcBillId2AdjBillIdsMap = new HashMap<String, Set>(2);
        for (DynamicObject srcFinarBill : srcFinarBillCol) {
            if ("sim_original_bill".equals(srcFinarBill.getString("sourcebilltype"))) {
                srcInfoList.add(srcFinarBill);
            }
            if (!BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(srcFinarBill.getString("billsrctype"))) continue;
            Set adjBillIds = srcBillId2AdjBillIdsMap.computeIfAbsent(srcFinarBill.getString("sourcebillid"), v -> new HashSet(2));
            adjBillIds.add(srcFinarBill.getLong("id"));
        }
        if (srcInfoList.size() > 0) {
            for (ExtendedDataEntity extendedDataEntity : datas) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                Long sourceBillId = dataEntity.getLong("sourcebillid");
                for (DynamicObject srcFinArInfo : srcInfoList) {
                    Long finArBillId = srcFinArInfo.getLong("id");
                    if (!sourceBillId.equals(finArBillId)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u6216\u7ea2\u51b2\u53d1\u8d77\u7684\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"FinArWriteOffUnAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
        }
        DynamicObjectCollection adjustBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"sourcebillid,entry.e_srcid,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("org.id", "in", finArOrgIds), new QFilter("sourcebillid", "in", srcBillId2AdjBillIdsMap.keySet()), new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()), new QFilter("billtype.number", "=", (Object)"arfin_borrowar_BT_S"), new QFilter("adjusttype", "=", (Object)"adjustinv"), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)});
        HashSet errIds = new HashSet(8);
        for (DynamicObject dynamicObject : adjustBillColl) {
            String sourcebillid = dynamicObject.getString("sourcebillid");
            Set adjBillIds = srcBillId2AdjBillIdsMap.getOrDefault(sourcebillid, new HashSet(1));
            errIds.addAll(adjBillIds);
        }
        if (errIds.size() > 0) {
            for (ExtendedDataEntity extendedDataEntity : writtenOffList) {
                ExtendedDataEntity[] finAr2 = extendedDataEntity.getDataEntity();
                long srcFinArId = finAr2.getLong("sourcebillid");
                if (!errIds.contains(srcFinArId)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u51b2\u9500\u5355\u5c06\u5bfc\u81f4\u5e94\u6536\u4e0e\u53d1\u7968\u4ea7\u751f\u5dee\u5f02\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArWriteOffUnAuditValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
        if ((set = (srcFinarBillWfRecord = QueryServiceHelper.query((String)"ar_saloutwfrecord", (String)"id,entry.billid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", srcFinArBillIds), new QFilter("entry.e_iswrittenoff", "=", (Object)"1")})).stream().map(finAr -> finAr.getLong("entry.billid")).collect(Collectors.toSet())).size() > 0) {
            for (ExtendedDataEntity data : datas) {
                DynamicObject finAr3 = data.getDataEntity();
                long srcFinArId = finAr3.getLong("sourcebillid");
                if (!set.contains(srcFinArId)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u51b2\u9500\u5355\u4e0a\u6e38\u5355\u636e\u5b58\u5728\u7ea2\u51b2\u7684\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArWriteOffUnAuditValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
        if ((existArOriginalIdSet = (arOriginalWfRecord = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,isvoucher,entry.billid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", srcFinArBillIds), new QFilter("entry.e_iswrittenoff", "=", (Object)"1")})).stream().map(finAr -> finAr.getLong("entry.billid")).collect(Collectors.toSet())).size() > 0) {
            for (ExtendedDataEntity data : datas) {
                DynamicObject finAr4 = data.getDataEntity();
                long srcFinArId = finAr4.getLong("sourcebillid");
                if (!srcFinArBillIds.contains(srcFinArId)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u51b2\u9500\u5355\u4e0a\u6e38\u5355\u636e\u5b58\u5728\u7ea2\u51b2\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArWriteOffUnAuditValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

