/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.validator.validatorService.ArValidatorService;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.helper.ArRevUnVerifyValidatorHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SettleRecordValidateHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;

public class FinarBillUnaudValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        ArrayList<Long> allFinArBillId = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> redSettleRecordBillIds = new ArrayList<Long>(64);
        ArrayList<Long> maybePremiumIds = new ArrayList<Long>(64);
        ArrayList<Long> srcTypeNotNullBillIds = new ArrayList<Long>(64);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finArBill = dataEntity.getDataEntity();
            long billId = finArBill.getLong("id");
            String sourceBillId = finArBill.getString("sourcebillid");
            orgIds.add(finArBill.getLong("org.id"));
            allFinArBillId.add(billId);
            if (redAllSettleRecord && !finArBill.getBoolean("iswrittenoff") && !finArBill.getBoolean("istransfer") && !"unsettle".equals(finArBill.getString("settlestatus"))) {
                redSettleRecordBillIds.add(billId);
            }
            if (finArBill.getBoolean("iswrittenoff") && !ObjectUtils.isEmpty((Object)sourceBillId) && !this.getOption().getVariables().containsKey("fiar_unaduit_mode")) {
                maybePremiumIds.add(Long.parseLong(sourceBillId));
            }
            if (ObjectUtils.isEmpty((Object)finArBill.getString("sourcebilltype"))) continue;
            srcTypeNotNullBillIds.add(billId);
        }
        Map validateRecordMessageMap = SettleRecordValidateHelper.validate4Bill(allFinArBillId, orgIds, (String)"ar", (String)"unaudit");
        Set<Long> hasSettleRecordBillIds = this.validateRecSettleRecord(redSettleRecordBillIds, orgIds);
        Set<String> srcPremiumBillIds = this.validateSrcIsPremium(maybePremiumIds);
        Map<Long, Set<String>> finAp4AdjustBillMessageMap = this.validatorBusWriteOff(srcTypeNotNullBillIds, orgIds);
        ArValidatorService vService = new ArValidatorService();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Set<String> adjustBillMessages;
            String errorMessageOther;
            DynamicObject finArBill = dataEntity.getDataEntity();
            long billId = finArBill.getLong("id");
            String sourceBillId = finArBill.getString("sourcebillid");
            String validateRecordMessage = (String)validateRecordMessageMap.get(billId);
            if (!ObjectUtils.isEmpty((Object)validateRecordMessage)) {
                if (!ARSettleStatusEnum.UNSETTLE.getValue().equals(finArBill.getString("settlestatus"))) {
                    this.addErrorMessage(dataEntity, validateRecordMessage);
                    continue;
                }
                if (finArBill.getBoolean("ispremium") || finArBill.getBoolean("istransfer")) {
                    if (validateRecordMessage.contains(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1", (String)"FinarBillUnaudValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]))) {
                        if (finArBill.getBoolean("ispremium")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8f6c\u51fa\u8d28\u4fdd\u91d1\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_14", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, validateRecordMessage);
                    continue;
                }
            }
            if (hasSettleRecordBillIds.contains(billId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u9700\u8981\u88ab\u7ea2\u51b2\uff0c\u8bf7\u5230\u7ed3\u7b97\u8bb0\u5f55\u5217\u8868\u6267\u884c\u53cd\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff01", (String)"SettleRecordValidateHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (finArBill.getBoolean("istransfer") && finArBill.getBoolean("iswrittenoff")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u503a\u6743\u8f6c\u79fb\u4e1a\u52a1\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[]{finArBill.getString("billno")}));
            }
            if (!ObjectUtils.isEmpty((Object)sourceBillId) && srcPremiumBillIds.contains(sourceBillId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u7684\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (!"".equals(errorMessageOther = vService.closeAccountValidate(dataEntity, "ar_finarbill", "bookdate"))) {
                this.addErrorMessage(dataEntity, errorMessageOther);
            }
            if (ObjectUtils.isEmpty(adjustBillMessages = finAp4AdjustBillMessageMap.get(billId))) continue;
            for (String adjustBillMessage : adjustBillMessages) {
                this.addErrorMessage(dataEntity, adjustBillMessage);
            }
        }
        this.arRevUnVerifyValidator(dataEntities, allFinArBillId);
        this.arSaloutUnVerifyValidator(dataEntities, allFinArBillId);
        this.arOriginalUnVerifyValidator(dataEntities, allFinArBillId);
    }

    private Set<Long> validateRecSettleRecord(List<Long> billIds, Set<Long> orgIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        DynamicObjectCollection asMainRecords = QueryServiceHelper.query((String)"ap_settlerecord", (String)"mainbillid", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", billIds)});
        for (DynamicObject asMainRecord : asMainRecords) {
            errorBillIds.add(asMainRecord.getLong("mainbillid"));
        }
        billIds.removeAll(errorBillIds);
        if (!billIds.isEmpty()) {
            DynamicObjectCollection asAssRecords = QueryServiceHelper.query((String)"ap_settlerecord", (String)"entry.billid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billIds), new QFilter("org", "in", orgIds)});
            for (DynamicObject asAssRecord : asAssRecords) {
                errorBillIds.add(asAssRecord.getLong("entry.billid"));
            }
        }
        return errorBillIds;
    }

    private Set<String> validateSrcIsPremium(List<Long> billIds) {
        if (billIds.isEmpty()) {
            return new HashSet<String>(2);
        }
        HashSet<String> errorBillIds = new HashSet<String>(16);
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection premiumBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : premiumBills) {
            errorBillIds.add(bill.getString("id"));
        }
        return errorBillIds;
    }

    private Map<Long, Set<String>> validatorBusWriteOff(List<Long> billIds, Set<Long> orgIds) {
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(16);
        if (billIds.isEmpty()) {
            return result;
        }
        QFilter qf = new QFilter("isadjust", "=", (Object)Boolean.TRUE);
        qf.and("srcfinbillid", "in", billIds);
        qf.and("org", "in", orgIds);
        DynamicObjectCollection busBills = QueryServiceHelper.query((String)"ar_busbill", (String)"id,srcfinbillid,isvoucher,entry.id", (QFilter[])new QFilter[]{qf});
        if (busBills.isEmpty()) {
            return result;
        }
        HashMap<Long, Long> busId4FinIdMap = new HashMap<Long, Long>(32);
        ArrayList<Long> busEntryRowIds = new ArrayList<Long>(32);
        for (DynamicObject busBill : busBills) {
            long busId = busBill.getLong("id");
            long finApBillId = busBill.getLong("srcfinbillid");
            busId4FinIdMap.put(busId, finApBillId);
            busEntryRowIds.add(busBill.getLong("entry.id"));
            if (!busBill.getBoolean("isvoucher")) continue;
            Set errorMessages = result.getOrDefault(finApBillId, new HashSet(4));
            errorMessages.add(ResManager.loadKDString((String)"\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u7684\u51b2\u56de\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinarBillUnaudValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            result.put(finApBillId, errorMessages);
        }
        Map allTargetBillIdsMap = BOTPNewHelper.loadAllTargetBillIds((String)"ar_busbill", (String)"entry", (Long[])busId4FinIdMap.keySet().toArray(new Long[0]), (Long[])busEntryRowIds.toArray(new Long[0]));
        if (allTargetBillIdsMap.isEmpty()) {
            return result;
        }
        for (Map.Entry entrySet : allTargetBillIdsMap.entrySet()) {
            Map targetBillIdsMap;
            Long finApBillId = (Long)busId4FinIdMap.get(entrySet.getKey());
            if (finApBillId == null || (targetBillIdsMap = (Map)entrySet.getValue()).isEmpty()) continue;
            Set errorMessages = result.getOrDefault(finApBillId, new HashSet(4));
            errorMessages.add(ResManager.loadKDString((String)"\u4e0b\u6e38\u51b2\u56de\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            result.put(finApBillId, errorMessages);
        }
        return result;
    }

    private void arOriginalUnVerifyValidator(ExtendedDataEntity[] datas, List<Long> billPks) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,isvoucher,entry.billid,entry.e_hadwrittenoff,entry.e_iswrittenoff,entry.assbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billPks)});
        if (ObjectUtils.isEmpty((Object)records)) {
            return;
        }
        this.originalAndSaloutValidator(datas, records, true);
    }

    private void arSaloutUnVerifyValidator(ExtendedDataEntity[] datas, List<Long> billPks) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_saloutwfrecord", (String)"id,isvoucher,entry.billid,entry.e_hadwrittenoff,entry.e_iswrittenoff,entry.assbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billPks)});
        if (ObjectUtils.isEmpty((Object)records)) {
            return;
        }
        this.originalAndSaloutValidator(datas, records, false);
    }

    private void originalAndSaloutValidator(ExtendedDataEntity[] datas, DynamicObjectCollection records, boolean isOriginal) {
        HashSet<Long> isvoucherIdSet = new HashSet<Long>(records.size());
        HashSet<Long> isWriteOffIdSet = new HashSet<Long>(records.size());
        for (DynamicObject record : records) {
            boolean isvoucher = record.getBoolean("isvoucher");
            boolean isWriteOff = record.getBoolean("entry.e_iswrittenoff");
            long arBillId = record.getLong("entry.billid");
            if (isvoucher) {
                isvoucherIdSet.add(arBillId);
            }
            if (!isWriteOff) continue;
            isWriteOffIdSet.add(arBillId);
        }
        for (ExtendedDataEntity data : datas) {
            DynamicObject finArBill = data.getDataEntity();
            long id = finArBill.getLong("id");
            if (isvoucherIdSet.contains(id)) {
                if (isOriginal) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5bf9\u5e94\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_11", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                } else {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5bf9\u5e94\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
            if (!isWriteOffIdSet.contains(id)) continue;
            if (isOriginal) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5bf9\u5e94\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u88ab\u7ea2\u51b2\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5bf9\u5e94\u7684\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55\u5df2\u88ab\u7ea2\u51b2\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinarBillUnaudValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private void arRevUnVerifyValidator(ExtendedDataEntity[] datas, List<Long> billPks) {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,isvoucher,entry.billid,entry.revbillid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billPks)});
        HashSet<Long> errBillIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            if (ArRevUnVerifyValidatorHelper.unVerifyValidator((DynamicObject)record)) continue;
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                errBillIds.add(entry.getLong("billid"));
            }
        }
        String errMessage = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u5185\u5bb9\uff1a1.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u672a\u751f\u6210\u51ed\u8bc1\uff1b2.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u672a\u88ab\u7ea2\u51b2\uff1b3.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u975e\u7ea2\u51b2\u751f\u6210\uff1b4.\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7684\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinarBillUnaudValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            Long billId = bill.getLong("id");
            if (!errBillIds.contains(billId)) continue;
            this.addErrorMessage(data, errMessage);
        }
    }
}

