/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.paysecurity.ArInvoiceExcessBusValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;

public class Invoice2BusQtyAndAmtToleranceValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> arBillIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            String sourceBillType = bill.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourceBillType)) continue;
            arBillIds.add(bill.getLong("id"));
        }
        if (arBillIds.size() == 0) {
            return;
        }
        ArInvoiceExcessBusValidator validator = new ArInvoiceExcessBusValidator();
        List results = validator.validate(arBillIds, this.getOperateKey());
        Map<Long, String> entryId2Result = results.stream().collect(Collectors.toMap(BusValidatorResult::getEntryId, BusValidatorResult::getMessage));
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long entryId = row.getLong("id");
                String message = entryId2Result.get(entryId);
                if (message == null) continue;
                this.addMessage(data, message);
            }
        }
    }
}

