/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceArBillImportValidator
extends AbstractValidator {
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<Long, InitHelper> initMap = new HashMap<Long, InitHelper>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject dataEntity = data.getDataEntity();
            long orgPk = (Long)dataEntity.getDynamicObject("org").getPkValue();
            String invoiceType = dataEntity.getString("invoicetype");
            String billsrctype = dataEntity.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billsrctype)) continue;
            try {
                DynamicObjectCollection entryList;
                Optional<DynamicObject> findFirst;
                this.checkHeadParams(dataEntity);
                if ("SP".equals(invoiceType) && (findFirst = (entryList = (DynamicObjectCollection)dataEntity.get("entry")).stream().filter(el -> Objects.nonNull(el.getBigDecimal("e_taxrate")) && BigDecimal.ZERO.compareTo(el.getBigDecimal("e_taxrate")) == 0).findFirst()).isPresent()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e13\u7528\u53d1\u7968\u4e0d\u652f\u6301\u5355\u636e\u4f53\u96f6\u7a0e\u7387\u884c\u5f00\u7968\uff0c\u8bf7\u586b\u5199\u7a0e\u7387\u6216\u4fee\u6539\u53d1\u7968\u7c7b\u578b\u3002", (String)"InvoiceArBillImportValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                InitHelper init = null;
                if (!initMap.containsKey(orgPk)) {
                    init = new InitHelper(orgPk, "ar_init");
                    if (!ObjectUtils.isEmpty((Object)init.getInitId())) {
                        initMap.put(orgPk, init);
                    }
                } else {
                    init = (InitHelper)initMap.get(orgPk);
                }
                Date bizDate = dataEntity.getDate("bizdate");
                Date duedate = dataEntity.getDate("duedate");
                Date currentDate = init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = init.getStartDate();
                }
                if (DateUtils.compareTo((Date)bizDate, (Date)currentDate) < 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u6708\u672b\u5173\u8d26\u7684\u5f53\u524d\u65e5\u671f\u201c%s\u201d\u3002", (String)"InvoiceArBillImportValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(currentDate)));
                }
                if (!Objects.nonNull(duedate) || DateUtils.compareTo((Date)duedate, (Date)bizDate) >= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u8fdf\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5355\u636e\u5f00\u7968\u65e5\u671f(%s)\u3002", (String)"InvoiceArBillImportValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), this.df.format(bizDate)));
            }
            catch (KDBizException e) {
                this.addErrorMessage(data, e.getMessage());
            }
        }
    }

    private void checkHeadParams(DynamicObject invoice) {
        String invoiceType = invoice.getString("invoicetype");
        if (invoice.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6574\u5355\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceArBillImportValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        if ("OTHER".equals(invoiceType)) {
            if (Objects.isNull(invoice.getDynamicObject("expense"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d39\u7528\u9879\u76ee\u201d\u3002", (String)"InvoiceArBillImportValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (StringUtils.isEmpty((String)invoice.getString("sellername"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u540d\u79f0\u3002", (String)"InvoiceArBillImportValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)invoice.getString("sellertin"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"InvoiceArBillImportValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)invoice.getString("buyername"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8d2d\u4e70\u65b9\u540d\u79f0\u4fe1\u606f\u3002", (String)"InvoiceArBillImportValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            String invoiceTypeNumber = invoice.getString("invoicetypef7.number");
            if (!("26".equals(invoiceTypeNumber) || "27".equals(invoiceTypeNumber) || "28".equals(invoiceTypeNumber) || "29".equals(invoiceTypeNumber))) {
                if (StringUtils.isEmpty((String)invoice.getString("selleraddr"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u5730\u5740\u4fe1\u606f\u3002", (String)"InvoiceArBillImportValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((String)invoice.getString("selleracct"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u8d26\u53f7\u4fe1\u606f\u3002", (String)"InvoiceArBillImportValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
            if ("SP".equals(invoiceType)) {
                if (StringUtils.isEmpty((String)invoice.getString("buyeraddr"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u4e13\u7528\u53d1\u7968\u8d2d\u4e70\u65b9\u5730\u5740\u4fe1\u606f\u3002", (String)"InvoiceArBillImportValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((String)invoice.getString("buyertin"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u4e13\u7528\u53d1\u7968\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"InvoiceArBillImportValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

